/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.metrics;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableRate;

@InterfaceAudience.Private
@Metrics(about="Recon OM Sync Metrics", context="ozone")
public final class ReconSyncMetrics {
    private static final String SOURCE_NAME = ReconSyncMetrics.class.getSimpleName();
    @Metric(about="Time taken to fetch delta updates from OM")
    private MutableRate deltaFetchDuration;
    @Metric(about="Count of successful delta fetch operations")
    private MutableCounterLong deltaFetchSuccess;
    @Metric(about="Count of failed delta fetch operations")
    private MutableCounterLong deltaFetchFailures;
    @Metric(about="Total size of delta data fetched in bytes")
    private MutableCounterLong deltaDataFetchSize;
    @Metric(about="Time taken to apply delta updates to Recon OM DB")
    private MutableRate deltaApplyDuration;
    @Metric(about="Count of failed delta apply operations")
    private MutableCounterLong deltaApplyFailures;
    @Metric(about="Time taken to fetch full DB snapshot")
    private MutableRate fullDBRequestLatency;
    @Metric(about="Total count of full DB fetch requests made")
    private MutableCounterLong fullDBFetchRequests;
    @Metric(about="Total size of downloaded snapshots in bytes")
    private MutableCounterLong snapshotSizeBytes;
    @Metric(about="Count of successful snapshot downloads")
    private MutableCounterLong snapshotDownloadSuccess;
    @Metric(about="Count of failed snapshot downloads")
    private MutableCounterLong snapshotDownloadFailures;

    private ReconSyncMetrics() {
    }

    public static ReconSyncMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (ReconSyncMetrics)ms.register(SOURCE_NAME, "Recon OM Sync Metrics", (Object)new ReconSyncMetrics());
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    public void updateDeltaFetchDuration(long duration) {
        this.deltaFetchDuration.add(duration);
    }

    public void incrDeltaFetchSuccess() {
        this.deltaFetchSuccess.incr();
    }

    public void incrDeltaFetchFailures() {
        this.deltaFetchFailures.incr();
    }

    public void incrDeltaDataFetchSize(long size) {
        this.deltaDataFetchSize.incr(size);
    }

    public void updateDeltaApplyDuration(long duration) {
        this.deltaApplyDuration.add(duration);
    }

    public void incrDeltaApplyFailures() {
        this.deltaApplyFailures.incr();
    }

    public void updateFullDBRequestLatency(long duration) {
        this.fullDBRequestLatency.add(duration);
    }

    public void incrFullDBFetchRequests() {
        this.fullDBFetchRequests.incr();
    }

    public void incrSnapshotSizeBytes(long size) {
        this.snapshotSizeBytes.incr(size);
    }

    public void incrSnapshotDownloadSuccess() {
        this.snapshotDownloadSuccess.incr();
    }

    public void incrSnapshotDownloadFailures() {
        this.snapshotDownloadFailures.incr();
    }

    public long getDeltaFetchSuccess() {
        return this.deltaFetchSuccess.value();
    }

    public long getDeltaFetchFailures() {
        return this.deltaFetchFailures.value();
    }

    public long getDeltaDataFetchSize() {
        return this.deltaDataFetchSize.value();
    }

    public long getDeltaApplyFailures() {
        return this.deltaApplyFailures.value();
    }

    public MutableRate getDeltaFetchDuration() {
        return this.deltaFetchDuration;
    }

    public MutableRate getDeltaApplyDuration() {
        return this.deltaApplyDuration;
    }

    public long getFullDBFetchRequests() {
        return this.fullDBFetchRequests.value();
    }

    public long getSnapshotSizeBytes() {
        return this.snapshotSizeBytes.value();
    }

    public long getSnapshotDownloadSuccess() {
        return this.snapshotDownloadSuccess.value();
    }

    public long getSnapshotDownloadFailures() {
        return this.snapshotDownloadFailures.value();
    }

    public MutableRate getFullDBRequestLatency() {
        return this.fullDBRequestLatency;
    }
}

