/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.handlers;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.api.handlers.BucketHandler;
import org.apache.hadoop.ozone.recon.api.handlers.EntityHandler;
import org.apache.hadoop.ozone.recon.api.types.CountStats;
import org.apache.hadoop.ozone.recon.api.types.DUResponse;
import org.apache.hadoop.ozone.recon.api.types.EntityType;
import org.apache.hadoop.ozone.recon.api.types.FileSizeDistributionResponse;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.api.types.NamespaceSummaryResponse;
import org.apache.hadoop.ozone.recon.api.types.ObjectDBInfo;
import org.apache.hadoop.ozone.recon.api.types.QuotaUsageResponse;
import org.apache.hadoop.ozone.recon.api.types.ResponseStatus;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;

public class DirectoryEntityHandler
extends EntityHandler {
    public DirectoryEntityHandler(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM, BucketHandler bucketHandler, String path) {
        super(reconNamespaceSummaryManager, omMetadataManager, reconSCM, bucketHandler, path);
    }

    @Override
    public NamespaceSummaryResponse getSummaryResponse() throws IOException {
        long dirObjectId = this.getBucketHandler().getDirObjectId(this.getNames());
        CountStats countStats = new CountStats(-1, -1, this.getTotalDirCount(dirObjectId), this.getTotalKeyCount(dirObjectId));
        return NamespaceSummaryResponse.newBuilder().setEntityType(EntityType.DIRECTORY).setCountStats(countStats).setObjectDBInfo(this.getDirectoryObjDbInfo(this.getNames())).setStatus(ResponseStatus.OK).build();
    }

    private ObjectDBInfo getDirectoryObjDbInfo(String[] names) throws IOException {
        OmDirectoryInfo omDirectoryInfo = this.getBucketHandler().getDirInfo(names);
        if (null == omDirectoryInfo) {
            return new ObjectDBInfo();
        }
        return new ObjectDBInfo(omDirectoryInfo);
    }

    @Override
    public DUResponse getDuResponse(boolean listFile, boolean withReplica, boolean sortSubPaths) throws IOException {
        DUResponse duResponse = new DUResponse();
        duResponse.setPath(this.getNormalizedPath());
        long dirObjectId = this.getBucketHandler().getDirObjectId(this.getNames());
        NSSummary dirNSSummary = this.getReconNamespaceSummaryManager().getNSSummary(dirObjectId);
        if (dirNSSummary == null) {
            if (withReplica) {
                duResponse.setSizeWithReplica(0L);
            }
            return duResponse;
        }
        Set<Long> subdirs = dirNSSummary.getChildDir();
        duResponse.setKeySize(dirNSSummary.getSizeOfFiles());
        long dirDataSize = duResponse.getKeySize();
        long dirDataSizeWithReplica = 0L;
        List<DUResponse.DiskUsage> subdirDUData = new ArrayList<DUResponse.DiskUsage>();
        for (long subdirObjectId : subdirs) {
            NSSummary subdirNSSummary = this.getReconNamespaceSummaryManager().getNSSummary(subdirObjectId);
            Path subdirPath = Paths.get(subdirNSSummary.getDirName(), new String[0]);
            Path subdirFileName = subdirPath.getFileName();
            if (subdirFileName == null) {
                throw new NullPointerException("Subdirectory file name is null.");
            }
            String subdirName = subdirFileName.toString();
            String subpath = BucketHandler.buildSubpath(this.getNormalizedPath(), subdirName);
            DUResponse.DiskUsage diskUsage = new DUResponse.DiskUsage();
            diskUsage.setSubpath(subpath);
            long dataSize = this.getTotalSize(subdirObjectId);
            dirDataSize += dataSize;
            if (withReplica) {
                long subdirDU = this.getBucketHandler().calculateDUUnderObject(subdirObjectId);
                diskUsage.setSizeWithReplica(subdirDU);
                dirDataSizeWithReplica += subdirDU;
            }
            diskUsage.setSize(dataSize);
            subdirDUData.add(diskUsage);
        }
        if (listFile || withReplica) {
            dirDataSizeWithReplica += this.getBucketHandler().handleDirectKeys(dirObjectId, withReplica, listFile, subdirDUData, this.getNormalizedPath());
        }
        if (withReplica) {
            duResponse.setSizeWithReplica(dirDataSizeWithReplica);
        }
        duResponse.setCount(subdirDUData.size());
        duResponse.setSize(dirDataSize);
        if (sortSubPaths) {
            subdirDUData = ReconUtils.sortDiskUsageDescendingWithLimit(subdirDUData, 30);
        }
        duResponse.setDuData(subdirDUData);
        return duResponse;
    }

    @Override
    public QuotaUsageResponse getQuotaResponse() throws IOException {
        QuotaUsageResponse quotaUsageResponse = new QuotaUsageResponse();
        quotaUsageResponse.setResponseCode(ResponseStatus.TYPE_NOT_APPLICABLE);
        return quotaUsageResponse;
    }

    @Override
    public FileSizeDistributionResponse getDistResponse() throws IOException {
        FileSizeDistributionResponse distResponse = new FileSizeDistributionResponse();
        long dirObjectId = this.getBucketHandler().getDirObjectId(this.getNames());
        int[] dirFileSizeDist = this.getTotalFileSizeDist(dirObjectId);
        distResponse.setFileSizeDist(dirFileSizeDist);
        return distResponse;
    }
}

