/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.BindException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.ExitManager;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.ConfigurationTarget;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.HddsTestUtils;
import org.apache.hadoop.hdds.scm.safemode.HealthyPipelineSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.SafeModeRuleFactory;
import org.apache.hadoop.hdds.scm.server.SCMConfigurator;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.ozone.HddsDatanodeService;
import org.apache.hadoop.ozone.MiniOzoneCluster;
import org.apache.hadoop.ozone.MiniOzoneClusterImpl;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.container.common.utils.DatanodeStoreCache;
import org.apache.hadoop.ozone.ha.ConfUtils;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisServer;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.ozone.test.GenericTestUtils;
import org.apache.ratis.util.function.CheckedConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniOzoneHAClusterImpl
extends MiniOzoneClusterImpl {
    private static final Logger LOG = LoggerFactory.getLogger(MiniOzoneHAClusterImpl.class);
    private final OMHAService omhaService;
    private final SCMHAService scmhaService;
    private final String clusterMetaPath;
    private int waitForClusterToBeReadyTimeout = 120000;
    private static final int RATIS_RPC_TIMEOUT = 1000;
    public static final int NODE_FAILURE_TIMEOUT = 2000;

    public MiniOzoneHAClusterImpl(OzoneConfiguration conf, SCMConfigurator scmConfigurator, OMHAService omhaService, SCMHAService scmhaService, List<HddsDatanodeService> hddsDatanodes, String clusterPath, List<MiniOzoneCluster.Service> services) {
        super(conf, scmConfigurator, hddsDatanodes, services);
        this.omhaService = omhaService;
        this.scmhaService = scmhaService;
        this.clusterMetaPath = clusterPath;
    }

    @Override
    public OzoneManager getOzoneManager() {
        return (OzoneManager)this.omhaService.getServices().get(0);
    }

    @Override
    protected OzoneClient createClient() throws IOException {
        String omServiceId = this.omhaService.getServiceId();
        if (omServiceId == null) {
            return OzoneClientFactory.getRpcClient((ConfigurationSource)this.getConf());
        }
        return OzoneClientFactory.getRpcClient((String)omServiceId, (ConfigurationSource)this.getConf());
    }

    public boolean isOMActive(String omNodeId) {
        return this.omhaService.isServiceActive(omNodeId);
    }

    public Iterator<StorageContainerManager> getInactiveSCM() {
        return this.scmhaService.inactiveServices();
    }

    public StorageContainerManager getSCM(String scmNodeId) {
        return (StorageContainerManager)this.scmhaService.getServiceById(scmNodeId);
    }

    public OzoneManager getOzoneManager(int index) {
        return (OzoneManager)this.omhaService.getServiceByIndex(index);
    }

    public OzoneManager getOzoneManager(String omNodeId) {
        return (OzoneManager)this.omhaService.getServiceById(omNodeId);
    }

    public List<OzoneManager> getOzoneManagersList() {
        return this.omhaService.getServices();
    }

    public List<StorageContainerManager> getStorageContainerManagersList() {
        return this.scmhaService.getServices();
    }

    public StorageContainerManager getStorageContainerManager(int index) {
        return (StorageContainerManager)this.scmhaService.getServiceByIndex(index);
    }

    public StorageContainerManager getScmLeader() {
        return this.getStorageContainerManagers().stream().filter(StorageContainerManager::checkLeader).findFirst().orElse(null);
    }

    public OzoneManager waitForLeaderOM() throws TimeoutException, InterruptedException {
        OzoneManager[] om = new OzoneManager[1];
        GenericTestUtils.waitFor(() -> {
            om[0] = this.getOMLeader();
            return om[0] != null;
        }, (int)200, (int)this.waitForClusterToBeReadyTimeout);
        return om[0];
    }

    public OzoneManager getOMLeader() {
        OzoneManager res = null;
        for (OzoneManager ozoneManager : this.omhaService.getActiveServices()) {
            if (!ozoneManager.isLeaderReady()) continue;
            if (res != null) {
                return null;
            }
            res = ozoneManager;
        }
        return res;
    }

    public void startInactiveOM(String omNodeID) throws IOException {
        this.omhaService.startInactiveService(omNodeID, OzoneManager::start);
    }

    public void startInactiveSCM(String scmNodeId) throws IOException {
        this.scmhaService.startInactiveService(scmNodeId, StorageContainerManager::start);
    }

    @Override
    public void restartOzoneManager() throws IOException {
        for (OzoneManager ozoneManager : this.omhaService.getServices()) {
            try {
                MiniOzoneHAClusterImpl.stopOM(ozoneManager);
            }
            catch (Exception e) {
                LOG.warn("Failed to stop OM: {}", (Object)ozoneManager.getOMServiceId());
            }
        }
        this.omhaService.inactiveServices().forEachRemaining(this.omhaService::activate);
        for (OzoneManager ozoneManager : this.omhaService.getServices()) {
            ozoneManager.restart();
        }
    }

    public void shutdownOzoneManager(OzoneManager ozoneManager) {
        LOG.info("Shutting down OzoneManager " + ozoneManager.getOMNodeId());
        ozoneManager.stop();
    }

    public void restartOzoneManager(OzoneManager ozoneManager, boolean waitForOM) throws IOException, TimeoutException, InterruptedException {
        LOG.info("Restarting OzoneManager " + ozoneManager.getOMNodeId());
        ozoneManager.restart();
        if (waitForOM) {
            GenericTestUtils.waitFor(() -> ((OzoneManager)ozoneManager).isRunning(), (int)1000, (int)this.waitForClusterToBeReadyTimeout);
        }
    }

    public void shutdownStorageContainerManager(StorageContainerManager scm) {
        LOG.info("Shutting down StorageContainerManager " + scm.getScmId());
        scm.stop();
        this.scmhaService.removeInstance(scm);
    }

    public StorageContainerManager restartStorageContainerManager(StorageContainerManager scm, boolean waitForSCM) throws IOException, TimeoutException, InterruptedException, AuthenticationException {
        LOG.info("Restarting SCM in cluster " + this.getClass());
        this.scmhaService.removeInstance(scm);
        OzoneConfiguration scmConf = scm.getConfiguration();
        this.shutdownStorageContainerManager(scm);
        scm.join();
        scm = HddsTestUtils.getScmSimple((OzoneConfiguration)scmConf, (SCMConfigurator)this.getSCMConfigurator());
        this.scmhaService.addInstance(scm, true);
        scm.start();
        if (waitForSCM) {
            this.waitForClusterToBeReady();
        }
        return scm;
    }

    @Override
    public String getClusterId() {
        return ((StorageContainerManager)this.scmhaService.getServices().get(0)).getClientProtocolServer().getScmInfo().getClusterId();
    }

    @Override
    public StorageContainerManager getActiveSCM() {
        for (StorageContainerManager scm : this.scmhaService.getServices()) {
            if (!scm.checkLeader()) continue;
            return scm;
        }
        return null;
    }

    @Override
    public void waitForSCMToBeReady() throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(() -> {
            for (StorageContainerManager scm : this.scmhaService.getServices()) {
                if (!scm.checkLeader()) continue;
                return true;
            }
            return false;
        }, (int)1000, (int)this.waitForClusterToBeReadyTimeout);
    }

    @Override
    public void stop() {
        for (OzoneManager ozoneManager : this.omhaService.getServices()) {
            if (ozoneManager == null) continue;
            LOG.info("Stopping the OzoneManager {}", (Object)ozoneManager.getOMNodeId());
            MiniOzoneHAClusterImpl.stopOM(ozoneManager);
        }
        for (StorageContainerManager scm : this.scmhaService.getServices()) {
            if (scm == null) continue;
            LOG.info("Stopping the StorageContainerManager {}", (Object)scm.getScmId());
            scm.stop();
            scm.join();
        }
        super.stop();
    }

    public void stopOzoneManager(int index) {
        this.stopAndDeactivate((OzoneManager)this.omhaService.getServices().get(index));
    }

    private void stopAndDeactivate(OzoneManager om) {
        MiniOzoneHAClusterImpl.stopOM(om);
        this.omhaService.deactivate(om);
    }

    public void stopOzoneManager(String omNodeId) {
        this.stopAndDeactivate((OzoneManager)this.omhaService.getServiceById(omNodeId));
    }

    private static void configureOMPorts(ConfigurationTarget conf, String omServiceId, String omNodeId) {
        String omAddrKey = ConfUtils.addKeySuffixes((String)"ozone.om.address", (String[])new String[]{omServiceId, omNodeId});
        String omHttpAddrKey = ConfUtils.addKeySuffixes((String)"ozone.om.http-address", (String[])new String[]{omServiceId, omNodeId});
        String omHttpsAddrKey = ConfUtils.addKeySuffixes((String)"ozone.om.https-address", (String[])new String[]{omServiceId, omNodeId});
        String omRatisPortKey = ConfUtils.addKeySuffixes((String)"ozone.om.ratis.port", (String[])new String[]{omServiceId, omNodeId});
        conf.set(omAddrKey, GenericTestUtils.PortAllocator.localhostWithFreePort());
        conf.set(omHttpAddrKey, GenericTestUtils.PortAllocator.localhostWithFreePort());
        conf.set(omHttpsAddrKey, GenericTestUtils.PortAllocator.localhostWithFreePort());
        conf.setInt(omRatisPortKey, GenericTestUtils.PortAllocator.getFreePort());
    }

    public void bootstrapOzoneManager(String omNodeId) throws Exception {
        this.bootstrapOzoneManager(omNodeId, true, false);
    }

    public void bootstrapOzoneManager(String omNodeId, boolean updateConfigs, boolean force) throws Exception {
        this.bootstrapOzoneManager(omNodeId, updateConfigs, force, false);
    }

    public void bootstrapOzoneManager(String omNodeId, boolean updateConfigs, boolean force, boolean isListener) throws Exception {
        OzoneManager.setTestReloadConfigFlag((boolean)true);
        int retryCount = 0;
        OzoneManager om = null;
        OzoneManager omLeader = this.waitForLeaderOM();
        long leaderSnapshotIndex = omLeader.getRatisSnapshotIndex();
        while (true) {
            try {
                OzoneConfiguration newConf = this.addNewOMToConfig(this.omhaService.getServiceId(), omNodeId, isListener);
                if (updateConfigs) {
                    this.updateOMConfigs(newConf);
                }
                om = this.bootstrapNewOM(omNodeId, newConf, force);
                LOG.info("Bootstrapped OzoneManager {} RPC server at {}", (Object)omNodeId, (Object)om.getOmRpcServerAddr());
                this.setConf(newConf);
            }
            catch (IOException e) {
                for (OzoneManager existingOM : this.omhaService.getServices()) {
                    existingOM.setConfiguration(this.getConf());
                }
                if (e instanceof BindException || e.getCause() instanceof BindException) {
                    LOG.info("MiniOzoneHACluster port conflicts, retried {} times", (Object)(++retryCount), (Object)e);
                    continue;
                }
                throw e;
            }
            break;
        }
        this.waitForBootstrappedNodeToBeReady(om, leaderSnapshotIndex);
        if (updateConfigs) {
            this.waitForConfigUpdateOnActiveOMs(omNodeId);
        }
    }

    private OzoneConfiguration addNewOMToConfig(String omServiceId, String omNodeId, boolean isListener) {
        OzoneConfiguration newConf = new OzoneConfiguration((Configuration)this.getConf());
        MiniOzoneHAClusterImpl.configureOMPorts((ConfigurationTarget)newConf, omServiceId, omNodeId);
        String omNodesKey = ConfUtils.addKeySuffixes((String)"ozone.om.nodes", (String[])new String[]{omServiceId});
        newConf.set(omNodesKey, newConf.get(omNodesKey) + "," + omNodeId);
        if (isListener) {
            String listenerOmNodesKey = ConfUtils.addKeySuffixes((String)"ozone.om.listener.nodes", (String[])new String[]{omServiceId});
            String existingListenerNodes = newConf.get(listenerOmNodesKey);
            if (StringUtils.isNotEmpty((CharSequence)existingListenerNodes)) {
                newConf.set(listenerOmNodesKey, existingListenerNodes + "," + omNodeId);
            } else {
                newConf.set(listenerOmNodesKey, omNodeId);
            }
        }
        return newConf;
    }

    private void updateOMConfigs(OzoneConfiguration newConf) {
        for (OzoneManager om : this.omhaService.getActiveServices()) {
            om.setConfiguration(newConf);
        }
    }

    private OzoneManager bootstrapNewOM(String nodeId, OzoneConfiguration newConf, boolean force) throws IOException, AuthenticationException {
        OzoneConfiguration config = new OzoneConfiguration((Configuration)newConf);
        config.set("ozone.om.node.id", nodeId);
        String metaDirPath = this.clusterMetaPath + "/" + nodeId;
        config.set("ozone.metadata.dirs", metaDirPath);
        OzoneManager.omInit((OzoneConfiguration)config);
        OzoneManager om = force ? OzoneManager.createOm((OzoneConfiguration)config, (OzoneManager.StartupOption)OzoneManager.StartupOption.FORCE_BOOTSTRAP) : OzoneManager.createOm((OzoneConfiguration)config, (OzoneManager.StartupOption)OzoneManager.StartupOption.BOOTSTRAP);
        ExitManagerForOM exitManager = new ExitManagerForOM(this, nodeId);
        om.setExitManagerForTesting((ExitManager)exitManager);
        this.omhaService.addInstance(om, false);
        this.startInactiveOM(nodeId);
        return om;
    }

    private void waitForBootstrappedNodeToBeReady(OzoneManager newOM, long leaderSnapshotIndex) throws Exception {
        GenericTestUtils.waitFor(() -> {
            try {
                if (newOM.getRatisSnapshotIndex() >= leaderSnapshotIndex) {
                    return true;
                }
            }
            catch (IOException e) {
                return false;
            }
            return false;
        }, (int)1000, (int)this.waitForClusterToBeReadyTimeout);
    }

    private void waitForConfigUpdateOnActiveOMs(String newOMNodeId) throws Exception {
        OzoneManager newOMNode = (OzoneManager)this.omhaService.getServiceById(newOMNodeId);
        OzoneManagerRatisServer newOMRatisServer = newOMNode.getOmRatisServer();
        GenericTestUtils.waitFor(() -> {
            for (OzoneManager om : this.omhaService.getActiveServices()) {
                if (!om.doesPeerExist(newOMNodeId)) {
                    return false;
                }
                if (!newOMNode.doesPeerExist(om.getOMNodeId())) {
                    return false;
                }
                if (newOMRatisServer.doesPeerExist(om.getOMNodeId())) continue;
                return false;
            }
            return true;
        }, (int)1000, (int)this.waitForClusterToBeReadyTimeout);
    }

    public void setupExitManagerForTesting() {
        for (OzoneManager om : this.omhaService.getServices()) {
            om.setExitManagerForTesting((ExitManager)new ExitManagerForOM(this, om.getOMNodeId()));
        }
    }

    public List<StorageContainerManager> getStorageContainerManagers() {
        return new ArrayList<StorageContainerManager>(this.scmhaService.getServices());
    }

    @Override
    public StorageContainerManager getStorageContainerManager() {
        return this.getStorageContainerManagers().get(0);
    }

    static class OMHAService
    extends MiniOzoneHAService<OzoneManager> {
        OMHAService(List<OzoneManager> activeList, List<OzoneManager> inactiveList, String serviceId) {
            super("OM", activeList, inactiveList, serviceId, OzoneManager::getOMNodeId);
        }
    }

    static class SCMHAService
    extends MiniOzoneHAService<StorageContainerManager> {
        SCMHAService(List<StorageContainerManager> activeList, List<StorageContainerManager> inactiveList, String serviceId) {
            super("SCM", activeList, inactiveList, serviceId, StorageContainerManager::getSCMNodeId);
        }
    }

    private static final class ExitManagerForOM
    extends ExitManager {
        private final MiniOzoneHAClusterImpl cluster;
        private final String omNodeId;

        private ExitManagerForOM(MiniOzoneHAClusterImpl cluster, String nodeId) {
            this.cluster = cluster;
            this.omNodeId = nodeId;
        }

        public void exitSystem(int status, String message, Throwable throwable, Logger log) throws IOException {
            LOG.error(this.omNodeId + " - System Exit: " + message, throwable);
            this.cluster.stopOzoneManager(this.omNodeId);
            throw new IOException(throwable);
        }

        public void exitSystem(int status, String message, Logger log) throws IOException {
            LOG.error(this.omNodeId + " - System Exit: " + message);
            this.cluster.stopOzoneManager(this.omNodeId);
            throw new IOException(message);
        }
    }

    static class MiniOzoneHAService<Type> {
        private final Map<String, Type> serviceMap;
        private final List<Type> services;
        private final String serviceId;
        private final String serviceName;
        private final List<Type> activeServices;
        private final List<Type> inactiveServices;
        private final Function<Type, String> serviceIdProvider;

        MiniOzoneHAService(String name, List<Type> activeList, List<Type> inactiveList, String serviceId, Function<Type, String> idProvider) {
            this.serviceName = name;
            this.serviceMap = Maps.newHashMap();
            this.serviceIdProvider = idProvider;
            if (activeList != null) {
                for (Type service : activeList) {
                    this.serviceMap.put(idProvider.apply(service), service);
                }
            }
            if (inactiveList != null) {
                for (Type service : inactiveList) {
                    this.serviceMap.put(idProvider.apply(service), service);
                }
            }
            this.services = new ArrayList<Type>(this.serviceMap.values());
            this.activeServices = activeList;
            this.inactiveServices = inactiveList;
            this.serviceId = serviceId;
            if (serviceId == null) {
                Preconditions.checkArgument((this.services.size() <= 1 ? 1 : 0) != 0);
            }
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public List<Type> getServices() {
            return this.services;
        }

        public List<Type> getActiveServices() {
            return this.activeServices;
        }

        public boolean removeInstance(Type t) {
            boolean result = this.services.remove(t);
            this.serviceMap.remove(this.serviceIdProvider.apply(t));
            this.activeServices.remove(t);
            this.inactiveServices.remove(t);
            return result;
        }

        public void addInstance(Type t, boolean isActive) {
            this.services.add(t);
            this.serviceMap.put(this.serviceIdProvider.apply(t), t);
            if (isActive) {
                this.activeServices.add(t);
            } else {
                this.inactiveServices.add(t);
            }
        }

        public void activate(Type t) {
            this.activeServices.add(t);
            this.inactiveServices.remove(t);
        }

        public void deactivate(Type t) {
            this.activeServices.remove(t);
            this.inactiveServices.add(t);
        }

        public boolean isServiceActive(String id) {
            return this.activeServices.contains(this.serviceMap.get(id));
        }

        public Iterator<Type> inactiveServices() {
            return new ArrayList<Type>(this.inactiveServices).iterator();
        }

        public Type getServiceByIndex(int index) {
            return this.services.get(index);
        }

        public Type getServiceById(String id) {
            return this.serviceMap.get(id);
        }

        public void startInactiveService(String id, CheckedConsumer<Type, IOException> serviceStarter) throws IOException {
            Type service = this.serviceMap.get(id);
            if (!this.inactiveServices.contains(service)) {
                throw new IOException(this.serviceName + " is already active.");
            }
            serviceStarter.accept(service);
            this.activeServices.add(service);
            this.inactiveServices.remove(service);
        }
    }

    public static class Builder
    extends MiniOzoneClusterImpl.Builder {
        private static final String OM_NODE_ID_PREFIX = "omNode-";
        private final List<OzoneManager> activeOMs = new ArrayList<OzoneManager>();
        private final List<OzoneManager> inactiveOMs = new ArrayList<OzoneManager>();
        private static final String SCM_NODE_ID_PREFIX = "scmNode-";
        private final List<StorageContainerManager> activeSCMs = new ArrayList<StorageContainerManager>();
        private final List<StorageContainerManager> inactiveSCMs = new ArrayList<StorageContainerManager>();
        private String omServiceId;
        private int numOfOMs;
        private int numOfActiveOMs = -1;
        private String scmServiceId;
        private int numOfSCMs;
        private int numOfActiveSCMs = -1;

        public Builder(OzoneConfiguration conf) {
            super(conf);
        }

        public Builder setNumOfOzoneManagers(int numOMs) {
            this.numOfOMs = numOMs;
            return this;
        }

        public Builder setNumOfActiveOMs(int numActiveOMs) {
            this.numOfActiveOMs = numActiveOMs;
            return this;
        }

        public Builder setOMServiceId(String serviceId) {
            this.omServiceId = serviceId;
            return this;
        }

        public Builder setNumOfStorageContainerManagers(int numSCMs) {
            this.numOfSCMs = numSCMs;
            return this;
        }

        public Builder setNumOfActiveSCMs(int numActiveSCMs) {
            this.numOfActiveSCMs = numActiveSCMs;
            return this;
        }

        public Builder setSCMServiceId(String serviceId) {
            this.scmServiceId = serviceId;
            return this;
        }

        @Override
        public MiniOzoneHAClusterImpl build() throws IOException {
            OMHAService omService;
            SCMHAService scmService;
            if (this.numOfActiveOMs > this.numOfOMs) {
                throw new IllegalArgumentException("Number of active OMs cannot be more than the total number of OMs");
            }
            if (this.numOfActiveOMs == -1) {
                this.numOfActiveOMs = this.numOfOMs;
            }
            if (this.numOfSCMs == 0) {
                this.numOfSCMs = 1;
            }
            if (this.numOfActiveSCMs == -1) {
                this.numOfActiveSCMs = this.numOfSCMs;
            }
            DefaultMetricsSystem.setMiniClusterMode((boolean)true);
            DatanodeStoreCache.setMiniClusterMode();
            this.initializeConfiguration();
            this.initOMRatisConf();
            try {
                scmService = this.createSCMService();
                omService = this.createOMService();
            }
            catch (AuthenticationException ex) {
                throw new IOException("Unable to build MiniOzoneCluster. ", ex);
            }
            List<HddsDatanodeService> hddsDatanodes = this.createHddsDatanodes();
            MiniOzoneHAClusterImpl cluster = new MiniOzoneHAClusterImpl(this.conf, this.scmConfigurator, omService, scmService, hddsDatanodes, this.path, this.getServices());
            try {
                cluster.startServices();
            }
            catch (Exception e) {
                throw new IOException("Unable to start services", e);
            }
            if (this.startDataNodes) {
                cluster.startHddsDatanodes();
            }
            this.prepareForNextBuild();
            return cluster;
        }

        protected int numberOfOzoneManagers() {
            return this.numOfOMs;
        }

        protected void initOMRatisConf() {
            long curRatisRpcTimeout;
            long defaultDuration = OMConfigKeys.OZONE_OM_RATIS_MINIMUM_TIMEOUT_DEFAULT.getDuration();
            this.conf.setTimeDuration("ozone.om.ratis.minimum.timeout", defaultDuration == (curRatisRpcTimeout = this.conf.getTimeDuration("ozone.om.ratis.minimum.timeout", defaultDuration, TimeUnit.MILLISECONDS)) ? 1000L : curRatisRpcTimeout, TimeUnit.MILLISECONDS);
            long defaultNodeFailureTimeout = OMConfigKeys.OZONE_OM_RATIS_SERVER_FAILURE_TIMEOUT_DURATION_DEFAULT.getDuration();
            long curNodeFailureTimeout = this.conf.getTimeDuration("ozone.om.ratis.server.failure.timeout.duration", defaultNodeFailureTimeout, OMConfigKeys.OZONE_OM_RATIS_SERVER_FAILURE_TIMEOUT_DURATION_DEFAULT.getUnit());
            this.conf.setTimeDuration("ozone.om.ratis.server.failure.timeout.duration", curNodeFailureTimeout == defaultNodeFailureTimeout ? 2000L : curNodeFailureTimeout, TimeUnit.MILLISECONDS);
        }

        protected OMHAService createOMService() throws IOException, AuthenticationException {
            if (this.omServiceId == null) {
                OzoneManager om = this.createAndStartSingleOM();
                return new OMHAService(Collections.singletonList(om), null, null);
            }
            ArrayList omList = Lists.newArrayList();
            int retryCount = 0;
            while (true) {
                try {
                    this.initOMHAConfig();
                    for (int i = 1; i <= this.numOfOMs; ++i) {
                        String nodeId = OM_NODE_ID_PREFIX + i;
                        OzoneConfiguration config = new OzoneConfiguration((Configuration)this.conf);
                        config.set("ozone.om.node.id", nodeId);
                        config.set("ozone.om.http-address", "");
                        config.set("ozone.om.https-address", "");
                        String metaDirPath = this.path + "/" + nodeId;
                        config.set("ozone.metadata.dirs", metaDirPath);
                        OzoneManager.omInit((OzoneConfiguration)config);
                        OzoneManager om = OzoneManager.createOm((OzoneConfiguration)config);
                        this.setClients(om);
                        omList.add(om);
                        if (i <= this.numOfActiveOMs) {
                            om.start();
                            this.activeOMs.add(om);
                            LOG.info("Started OzoneManager {} RPC server at {}", (Object)nodeId, (Object)om.getOmRpcServerAddr());
                            continue;
                        }
                        this.inactiveOMs.add(om);
                        LOG.info("Initialized OzoneManager at {}. This OM is currently inactive (not running).", (Object)om.getOmRpcServerAddr());
                    }
                }
                catch (BindException e) {
                    for (OzoneManager om : omList) {
                        MiniOzoneClusterImpl.stopOM(om);
                        LOG.info("Stopping OzoneManager server at {}", (Object)om.getOmRpcServerAddr());
                    }
                    omList.clear();
                    LOG.info("MiniOzoneHACluster port conflicts, retried {} times", (Object)(++retryCount), (Object)e);
                    continue;
                }
                break;
            }
            return new OMHAService(this.activeOMs, this.inactiveOMs, this.omServiceId);
        }

        protected SCMHAService createSCMService() throws IOException, AuthenticationException {
            if (this.scmServiceId == null) {
                StorageContainerManager scm = this.createAndStartSingleSCM();
                return new SCMHAService(Collections.singletonList(scm), null, null);
            }
            ArrayList scmList = Lists.newArrayList();
            int retryCount = 0;
            while (true) {
                try {
                    this.initSCMHAConfig();
                    for (int i = 1; i <= this.numOfSCMs; ++i) {
                        String nodeId = SCM_NODE_ID_PREFIX + i;
                        String metaDirPath = this.path + "/" + nodeId;
                        OzoneConfiguration scmConfig = new OzoneConfiguration((Configuration)this.conf);
                        scmConfig.set("ozone.metadata.dirs", metaDirPath);
                        scmConfig.set("ozone.scm.node.id", nodeId);
                        this.configureSCM(true);
                        if (i == 1) {
                            StorageContainerManager.scmInit((OzoneConfiguration)scmConfig, (String)this.clusterId);
                        } else {
                            StorageContainerManager.scmBootstrap((OzoneConfiguration)scmConfig);
                        }
                        StorageContainerManager scm = HddsTestUtils.getScmSimple((OzoneConfiguration)scmConfig, (SCMConfigurator)this.scmConfigurator);
                        HealthyPipelineSafeModeRule rule = (HealthyPipelineSafeModeRule)SafeModeRuleFactory.getInstance().getSafeModeRule(HealthyPipelineSafeModeRule.class);
                        if (rule != null) {
                            rule.setHealthyPipelineThresholdCount(this.numOfDatanodes / 3);
                        }
                        scmList.add(scm);
                        if (i <= this.numOfActiveSCMs) {
                            scm.start();
                            this.activeSCMs.add(scm);
                            LOG.info("Started SCM RPC server at {}", (Object)scm.getClientRpcAddress());
                            continue;
                        }
                        this.inactiveSCMs.add(scm);
                        LOG.info("Initialized SCM at {}. This SCM is currently inactive (not running).", (Object)scm.getClientRpcAddress());
                    }
                }
                catch (BindException e) {
                    for (StorageContainerManager scm : scmList) {
                        scm.stop();
                        scm.join();
                        LOG.info("Stopping StorageContainerManager server at {}", (Object)scm.getClientRpcAddress());
                    }
                    scmList.clear();
                    LOG.info("MiniOzoneHACluster port conflicts, retried {} times", (Object)(++retryCount), (Object)e);
                    continue;
                }
                break;
            }
            this.configureScmDatanodeAddress(this.activeSCMs);
            return new SCMHAService(this.activeSCMs, this.inactiveSCMs, this.scmServiceId);
        }

        private void initSCMHAConfig() {
            this.conf.set("ozone.scm.service.ids", this.scmServiceId);
            this.conf.set("ozone.scm.default.service.id", this.scmServiceId);
            String scmNodesKey = ConfUtils.addKeySuffixes((String)"ozone.scm.nodes", (String[])new String[]{this.scmServiceId});
            StringBuilder scmNodesKeyValue = new StringBuilder();
            StringBuilder scmNames = new StringBuilder();
            for (int i = 1; i <= this.numOfSCMs; ++i) {
                String scmNodeId = SCM_NODE_ID_PREFIX + i;
                if (i == 1) {
                    this.conf.set("ozone.scm.primordial.node.id", scmNodeId);
                }
                scmNodesKeyValue.append(',').append(scmNodeId);
                String scmAddrKey = ConfUtils.addKeySuffixes((String)"ozone.scm.address", (String[])new String[]{this.scmServiceId, scmNodeId});
                String scmHttpAddrKey = ConfUtils.addKeySuffixes((String)"ozone.scm.http-address", (String[])new String[]{this.scmServiceId, scmNodeId});
                String scmHttpsAddrKey = ConfUtils.addKeySuffixes((String)"ozone.scm.https-address", (String[])new String[]{this.scmServiceId, scmNodeId});
                String scmRatisPortKey = ConfUtils.addKeySuffixes((String)"ozone.scm.ratis.port", (String[])new String[]{this.scmServiceId, scmNodeId});
                String dnPortKey = ConfUtils.addKeySuffixes((String)"ozone.scm.datanode.address", (String[])new String[]{this.scmServiceId, scmNodeId});
                String blockClientKey = ConfUtils.addKeySuffixes((String)"ozone.scm.block.client.address", (String[])new String[]{this.scmServiceId, scmNodeId});
                String ssClientKey = ConfUtils.addKeySuffixes((String)"ozone.scm.client.address", (String[])new String[]{this.scmServiceId, scmNodeId});
                String scmGrpcPortKey = ConfUtils.addKeySuffixes((String)"ozone.scm.grpc.port", (String[])new String[]{this.scmServiceId, scmNodeId});
                String scmSecurityAddrKey = ConfUtils.addKeySuffixes((String)"ozone.scm.security.service.address", (String[])new String[]{this.scmServiceId, scmNodeId});
                this.conf.set(scmAddrKey, "127.0.0.1");
                this.conf.set(scmHttpAddrKey, GenericTestUtils.PortAllocator.localhostWithFreePort());
                this.conf.set(scmHttpsAddrKey, GenericTestUtils.PortAllocator.localhostWithFreePort());
                this.conf.set(scmSecurityAddrKey, GenericTestUtils.PortAllocator.localhostWithFreePort());
                int ratisPort = GenericTestUtils.PortAllocator.getFreePort();
                this.conf.setInt(scmRatisPortKey, ratisPort);
                int dnPort = GenericTestUtils.PortAllocator.getFreePort();
                this.conf.set(dnPortKey, "127.0.0.1:" + dnPort);
                scmNames.append(",localhost:").append(dnPort);
                this.conf.set(ssClientKey, GenericTestUtils.PortAllocator.localhostWithFreePort());
                this.conf.setInt(scmGrpcPortKey, GenericTestUtils.PortAllocator.getFreePort());
                String blockAddress = GenericTestUtils.PortAllocator.localhostWithFreePort();
                this.conf.set(blockClientKey, blockAddress);
                this.conf.set("ozone.scm.block.client.address", blockAddress);
            }
            this.conf.set(scmNodesKey, scmNodesKeyValue.substring(1));
            this.conf.set("ozone.scm.names", scmNames.substring(1));
        }

        private void initOMHAConfig() {
            this.conf.set("ozone.om.service.ids", this.omServiceId);
            this.conf.set("ozone.om.internal.service.id", this.omServiceId);
            String omNodesKey = ConfUtils.addKeySuffixes((String)"ozone.om.nodes", (String[])new String[]{this.omServiceId});
            ArrayList<String> omNodeIds = new ArrayList<String>();
            for (int i = 1; i <= this.numOfOMs; ++i) {
                String omNodeId = OM_NODE_ID_PREFIX + i;
                omNodeIds.add(omNodeId);
                MiniOzoneHAClusterImpl.configureOMPorts((ConfigurationTarget)this.conf, this.omServiceId, omNodeId);
            }
            this.conf.set(omNodesKey, String.join((CharSequence)",", omNodeIds));
        }
    }
}

