/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.ozone.MiniOzoneCluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniOzoneClusterProvider {
    private static final Logger LOG = LoggerFactory.getLogger(MiniOzoneClusterProvider.class);
    private static final int PRE_CREATE_LIMIT = 1;
    private static final int EXPIRED_LIMIT = 4;
    private volatile boolean shutdown = false;
    private final int clusterLimit;
    private int consumedClusterCount = 0;
    private final MiniOzoneCluster.Builder builder;
    private final Thread createThread;
    private final Thread reapThread;
    private final Set<MiniOzoneCluster> createdClusters = new HashSet<MiniOzoneCluster>();
    private final BlockingQueue<MiniOzoneCluster> clusters = new ArrayBlockingQueue<MiniOzoneCluster>(1);
    private final BlockingQueue<MiniOzoneCluster> expiredClusters = new ArrayBlockingQueue<MiniOzoneCluster>(4);

    public MiniOzoneClusterProvider(MiniOzoneCluster.Builder builder, int clusterLimit) {
        this.builder = builder;
        this.clusterLimit = clusterLimit;
        this.createThread = this.createClusters();
        this.reapThread = this.reapClusters();
    }

    public synchronized MiniOzoneCluster provide() throws InterruptedException, IOException {
        this.ensureNotShutdown();
        if (this.consumedClusterCount >= this.clusterLimit) {
            throw new IOException("The cluster limit of " + this.clusterLimit + " has been reached for this provider. Please increase the value set in the constructor");
        }
        MiniOzoneCluster cluster = this.clusters.poll(100L, TimeUnit.SECONDS);
        if (cluster == null) {
            throw new IOException("Failed to obtain available cluster in time");
        }
        this.createdClusters.add(cluster);
        ++this.consumedClusterCount;
        return cluster;
    }

    public synchronized void destroy(MiniOzoneCluster c) throws InterruptedException, IOException {
        this.ensureNotShutdown();
        this.createdClusters.remove(c);
        this.expiredClusters.put(c);
    }

    public synchronized void shutdown() throws InterruptedException {
        this.createThread.interrupt();
        this.createThread.join();
        this.destroyRemainingClusters();
        this.shutdown = true;
        this.reapThread.join();
    }

    private void ensureNotShutdown() throws IOException {
        if (this.shutdown) {
            throw new IOException("The mini-cluster provider is shutdown");
        }
    }

    private Thread reapClusters() {
        Thread t = new Thread(() -> {
            while (!this.shutdown || !this.expiredClusters.isEmpty()) {
                try {
                    MiniOzoneCluster c = this.expiredClusters.poll(100L, TimeUnit.MILLISECONDS);
                    if (c == null) continue;
                    c.shutdown();
                }
                catch (Exception e) {
                    LOG.error("Unexpected exception received", (Throwable)e);
                }
            }
        });
        t.setName("Mini-Cluster-Provider-Reap");
        t.start();
        return t;
    }

    private Thread createClusters() {
        Thread t = new Thread(() -> {
            for (int createdCount = 0; !Thread.interrupted() && createdCount < this.clusterLimit; ++createdCount) {
                MiniOzoneCluster cluster = null;
                try {
                    cluster = this.builder.build();
                    cluster.waitForClusterToBeReady();
                    this.clusters.put(cluster);
                    continue;
                }
                catch (InterruptedException e) {
                    if (cluster == null) break;
                    cluster.shutdown();
                    break;
                }
                catch (IOException | TimeoutException e) {
                    throw new RuntimeException("Unable to build cluster", e);
                }
            }
        });
        t.setName("Mini-Cluster-Provider-Create");
        t.start();
        return t;
    }

    private void destroyRemainingClusters() {
        MiniOzoneCluster[] remaining;
        while (!this.clusters.isEmpty()) {
            try {
                MiniOzoneCluster cluster = (MiniOzoneCluster)this.clusters.poll();
                if (cluster == null) continue;
                this.destroy(cluster);
            }
            catch (IOException | InterruptedException e) {
                LOG.error("Caught exception when destroying clusters", (Throwable)e);
            }
        }
        for (MiniOzoneCluster c : remaining = this.createdClusters.toArray(new MiniOzoneCluster[0])) {
            try {
                this.destroy(c);
            }
            catch (IOException | InterruptedException e) {
                LOG.error("Caught exception when destroying remaining clusters", (Throwable)e);
            }
        }
        this.createdClusters.clear();
    }
}

