/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.server.SCMConfigurator;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyClient;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.ozone.HddsDatanodeService;
import org.apache.hadoop.ozone.MiniOzoneClusterImpl;
import org.apache.hadoop.ozone.MiniOzoneHAClusterImpl;
import org.apache.hadoop.ozone.UniformDatanodesFactory;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.function.CheckedFunction;

public interface MiniOzoneCluster
extends AutoCloseable {
    public static Builder newBuilder(OzoneConfiguration conf) {
        return new MiniOzoneClusterImpl.Builder(conf);
    }

    public static MiniOzoneHAClusterImpl.Builder newHABuilder(OzoneConfiguration conf) {
        return new MiniOzoneHAClusterImpl.Builder(conf);
    }

    public OzoneConfiguration getConf();

    public void waitForClusterToBeReady() throws TimeoutException, InterruptedException;

    public void waitForPipelineTobeReady(HddsProtos.ReplicationFactor var1, int var2) throws TimeoutException, InterruptedException;

    public void setWaitForClusterToBeReadyTimeout(int var1);

    public void waitTobeOutOfSafeMode() throws TimeoutException, InterruptedException;

    public StorageContainerManager getStorageContainerManager();

    public OzoneManager getOzoneManager();

    public List<HddsDatanodeService> getHddsDatanodes();

    public HddsDatanodeService getHddsDatanode(DatanodeDetails var1) throws IOException;

    public OzoneClient newClient() throws IOException;

    public StorageContainerLocationProtocolClientSideTranslatorPB getStorageContainerLocationClient() throws IOException;

    public void restartStorageContainerManager(boolean var1) throws InterruptedException, TimeoutException, IOException, AuthenticationException;

    public void restartOzoneManager() throws IOException;

    public void restartHddsDatanode(int var1, boolean var2) throws InterruptedException, TimeoutException;

    public int getHddsDatanodeIndex(DatanodeDetails var1) throws IOException;

    public void restartHddsDatanode(DatanodeDetails var1, boolean var2) throws InterruptedException, TimeoutException, IOException;

    public void shutdownHddsDatanode(int var1);

    public void shutdownHddsDatanode(DatanodeDetails var1) throws IOException;

    public void shutdown();

    @Override
    default public void close() {
        this.shutdown();
    }

    public void stop();

    public void startHddsDatanodes();

    public void shutdownHddsDatanodes();

    public String getClusterId();

    default public String getName() {
        return this.getClass().getSimpleName() + "-" + this.getClusterId();
    }

    default public String getBaseDir() {
        return Builder.getTempPath(this.getName());
    }

    public static abstract class Builder {
        protected static final int ACTIVE_OMS_NOT_SET = -1;
        protected static final int ACTIVE_SCMS_NOT_SET = -1;
        protected static final int DEFAULT_RATIS_RPC_TIMEOUT_SEC = 1;
        private static final String SYSPROP_TEST_DATA_DIR = "test.build.data";
        private static final String DEFAULT_TEST_DATA_PATH = "target/test/data/";
        private static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
        protected OzoneConfiguration conf;
        protected String path;
        protected String clusterId;
        protected SCMConfigurator scmConfigurator;
        protected String scmId = UUID.randomUUID().toString();
        protected String omId = UUID.randomUUID().toString();
        protected int numOfDatanodes = 3;
        protected boolean startDataNodes = true;
        protected CertificateClient certClient;
        protected SecretKeyClient secretKeyClient;
        protected DatanodeFactory dnFactory = UniformDatanodesFactory.newBuilder().build();
        private final List<Service> services = new ArrayList<Service>();

        protected Builder(OzoneConfiguration conf) {
            this.conf = conf;
            this.setClusterId();
            this.setSCMConfigurator(new SCMConfigurator());
            ExitUtils.disableSystemExit();
        }

        protected void prepareForNextBuild() {
            this.conf = new OzoneConfiguration((Configuration)this.conf);
            this.conf.unset("ozone.scm.ha.ratis.storage.dir");
            this.conf.unset("ozone.scm.ha.ratis.snapshot.dir");
            this.conf.unset("ozone.scm.db.dirs");
            this.conf.unset("ozone.http.basedir");
            this.conf.unset("ozone.om.ratis.storage.dir");
            this.conf.unset("ozone.om.ratis.snapshot.dir");
            this.conf.unset("ozone.om.db.dirs");
            this.conf.unset("ozone.om.snapshot.diff.db.dir");
            this.setClusterId();
        }

        protected static String getTempPath(String subpath) {
            String prop;
            String string = prop = WINDOWS ? DEFAULT_TEST_DATA_PATH : System.getProperty(SYSPROP_TEST_DATA_DIR, DEFAULT_TEST_DATA_PATH);
            if (prop.isEmpty()) {
                prop = DEFAULT_TEST_DATA_PATH;
            }
            if (!prop.endsWith("/")) {
                prop = prop + "/";
            }
            return prop + subpath;
        }

        public Builder setSCMConfigurator(SCMConfigurator configurator) {
            this.scmConfigurator = configurator;
            return this;
        }

        private void setClusterId() {
            this.clusterId = UUID.randomUUID().toString();
            this.path = Builder.getTempPath(MiniOzoneClusterImpl.class.getSimpleName() + "-" + this.clusterId);
        }

        public Builder withoutDatanodes() {
            this.setNumDatanodes(0);
            this.conf.setBoolean("hdds.scm.safemode.enabled", false);
            return this;
        }

        public Builder setStartDataNodes(boolean nodes) {
            this.startDataNodes = nodes;
            return this;
        }

        public Builder setCertificateClient(CertificateClient client) {
            this.certClient = client;
            return this;
        }

        public Builder setSecretKeyClient(SecretKeyClient client) {
            this.secretKeyClient = client;
            return this;
        }

        public Builder setNumDatanodes(int val) {
            this.numOfDatanodes = val;
            return this;
        }

        public Builder setDatanodeFactory(DatanodeFactory factory) {
            this.dnFactory = factory;
            return this;
        }

        public Builder addService(Service service) {
            this.services.add(service);
            return this;
        }

        public List<Service> getServices() {
            return this.services;
        }

        public abstract MiniOzoneCluster build() throws IOException;
    }

    public static interface Service {
        public void start(OzoneConfiguration var1) throws Exception;

        public void stop() throws Exception;
    }

    public static interface DatanodeFactory
    extends CheckedFunction<OzoneConfiguration, OzoneConfiguration, IOException> {
    }
}

