/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeSetOwnerResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeSetOwnerRequest
extends OMVolumeRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMVolumeSetOwnerRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMVolumeSetOwnerRequest.class);
    }

    public OMVolumeSetOwnerRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        long modificationTime = Time.now();
        OzoneManagerProtocolProtos.SetVolumePropertyRequest.Builder setPropertyRequestBuilder = this.getOmRequest().getSetVolumePropertyRequest().toBuilder().setModificationTime(modificationTime);
        return this.getOmRequest().toBuilder().setSetVolumePropertyRequest(setPropertyRequestBuilder).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        block19: {
            block20: {
                transactionLogIndex = context.getIndex();
                setVolumePropertyRequest = this.getOmRequest().getSetVolumePropertyRequest();
                Preconditions.checkNotNull((Object)setVolumePropertyRequest);
                omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
                if (!setVolumePropertyRequest.hasOwnerName()) {
                    omResponse.setStatus(OzoneManagerProtocolProtos.Status.INVALID_REQUEST).setSuccess(false);
                    return new OMVolumeSetOwnerResponse(omResponse.build());
                }
                omMetrics = ozoneManager.getMetrics();
                omMetrics.incNumVolumeUpdates();
                volume = setVolumePropertyRequest.getVolumeName();
                newOwner = setVolumePropertyRequest.getOwnerName();
                auditLogger = ozoneManager.getAuditLogger();
                userInfo = this.getOmRequest().getUserInfo();
                auditMap = this.buildVolumeAuditMap(volume);
                auditMap.put("owner", newOwner);
                acquiredUserLocks = false;
                acquiredVolumeLock = false;
                exception = null;
                omMetadataManager = ozoneManager.getMetadataManager();
                oldOwner = null;
                omClientResponse = null;
                if (ozoneManager.getAclsEnabled()) {
                    this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, null, null);
                }
                maxUserVolumeCount = ozoneManager.getMaxUserVolumeCount();
                omVolumeArgs = null;
                this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volume}));
                acquiredVolumeLock = this.getOmLockDetails().isLockAcquired();
                omVolumeArgs = this.getVolumeInfo(omMetadataManager, volume);
                oldOwner = omVolumeArgs.getOwnerName();
                if (!oldOwner.equals(newOwner)) break block19;
                OMVolumeSetOwnerRequest.LOG.warn("Volume '{}' owner is already user '{}'.", (Object)volume, (Object)oldOwner);
                omResponse.setStatus(OzoneManagerProtocolProtos.Status.OK).setMessage("Volume '" + volume + "' owner is already '" + newOwner + "'.").setSuccess(false);
                omResponse.setSetVolumePropertyResponse(OzoneManagerProtocolProtos.SetVolumePropertyResponse.newBuilder().setResponse(false).build());
                var25_21 = omClientResponse = new OMVolumeSetOwnerResponse(omResponse.build());
                if (!acquiredUserLocks) break block20;
                omMetadataManager.getLock().releaseMultiUserLock(newOwner, oldOwner);
            }
            if (acquiredVolumeLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volume}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
            return var25_21;
        }
        try {
            try {
                acquiredUserLocks = omMetadataManager.getLock().acquireMultiUserLock(newOwner, oldOwner);
                oldOwnerVolumeList = (OzoneManagerStorageProtos.PersistedUserVolumeInfo)omMetadataManager.getUserTable().get((Object)oldOwner);
                oldOwnerVolumeList = this.delVolumeFromOwnerList(oldOwnerVolumeList, volume, oldOwner, transactionLogIndex);
                newOwnerVolumeList = (OzoneManagerStorageProtos.PersistedUserVolumeInfo)omMetadataManager.getUserTable().get((Object)newOwner);
                newOwnerVolumeList = OMVolumeSetOwnerRequest.addVolumeToOwnerList(newOwnerVolumeList, volume, newOwner, maxUserVolumeCount, transactionLogIndex);
                omVolumeArgs.setOwnerName(newOwner);
                omVolumeArgs.setUpdateID(transactionLogIndex);
                omVolumeArgs.setModificationTime(setVolumePropertyRequest.getModificationTime());
                omMetadataManager.getUserTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getUserKey(newOwner)), CacheValue.get((long)transactionLogIndex, (Object)newOwnerVolumeList));
                omMetadataManager.getUserTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getUserKey(oldOwner)), CacheValue.get((long)transactionLogIndex, (Object)oldOwnerVolumeList));
                omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getVolumeKey(volume)), CacheValue.get((long)transactionLogIndex, (Object)omVolumeArgs));
                omResponse.setSetVolumePropertyResponse(OzoneManagerProtocolProtos.SetVolumePropertyResponse.newBuilder().setResponse(true).build());
                omClientResponse = new OMVolumeSetOwnerResponse(omResponse.build(), oldOwner, oldOwnerVolumeList, newOwnerVolumeList, omVolumeArgs);
            }
            catch (IOException | InvalidPathException ex) {
                exception = ex;
                omClientResponse = new OMVolumeSetOwnerResponse(this.createErrorOMResponse(omResponse, exception));
                if (acquiredUserLocks) {
                    omMetadataManager.getLock().releaseMultiUserLock(newOwner, oldOwner);
                }
                if (acquiredVolumeLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volume}));
                }
                if (omClientResponse == null) ** GOTO lbl92
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        catch (Throwable var24_24) {
            if (acquiredUserLocks) {
                omMetadataManager.getLock().releaseMultiUserLock(newOwner, oldOwner);
            }
            if (acquiredVolumeLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volume}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
            throw var24_24;
        }
        if (acquiredUserLocks) {
            omMetadataManager.getLock().releaseMultiUserLock(newOwner, oldOwner);
        }
        if (acquiredVolumeLock) {
            this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volume}));
        }
        if (omClientResponse != null) {
            omClientResponse.setOmLockDetails(this.getOmLockDetails());
        }
lbl92:
        // 5 sources

        this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.SET_OWNER, auditMap, exception, userInfo));
        if (exception == null) {
            OMVolumeSetOwnerRequest.LOG.debug("Successfully changed Owner of Volume {} from {} -> {}", new Object[]{volume, oldOwner, newOwner});
        } else {
            OMVolumeSetOwnerRequest.LOG.error("Changing volume ownership failed for user:{} volume:{}", new Object[]{newOwner, volume, exception});
            omMetrics.incNumVolumeUpdateFails();
        }
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMVolumeSetOwnerRequest.java", OMVolumeSetOwnerRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.volume.OMVolumeSetOwnerRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 63);
    }
}

