/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.snapshot;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ResolvedBucket;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.snapshot.OMSnapshotRenameResponse;
import org.apache.hadoop.ozone.om.snapshot.RequireSnapshotFeatureState;
import org.apache.hadoop.ozone.om.snapshot.RequireSnapshotFeatureStateAspect;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.DisallowedUntilLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OMSnapshotRenameRequest
extends OMClientRequest {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public OMSnapshotRenameRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.FILESYSTEM_SNAPSHOT)
    @RequireSnapshotFeatureState(value=true)
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2);
        RequireSnapshotFeatureStateAspect.aspectOf().checkFeatureState(joinPoint);
        OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(joinPoint);
        }
        OzoneManagerProtocolProtos.OMRequest omRequest = super.preExecute(ozoneManager);
        OzoneManagerProtocolProtos.RenameSnapshotRequest renameSnapshotRequest = omRequest.getRenameSnapshotRequest();
        String snapshotNewName = renameSnapshotRequest.getSnapshotNewName();
        OmUtils.validateSnapshotName((String)snapshotNewName);
        String volumeName = renameSnapshotRequest.getVolumeName();
        String bucketName = renameSnapshotRequest.getBucketName();
        ResolvedBucket resolvedBucket = ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)volumeName, (Object)bucketName), (OMClientRequest)this);
        volumeName = resolvedBucket.realVolume();
        bucketName = resolvedBucket.realBucket();
        UserGroupInformation ugi = this.createUGIForApi();
        String bucketOwner = ozoneManager.getBucketOwner(volumeName, bucketName, IAccessAuthorizer.ACLType.READ, OzoneObj.ResourceType.BUCKET);
        if (!ozoneManager.isAdmin(ugi) && !ozoneManager.isOwner(ugi, bucketOwner)) {
            throw new OMException("Only bucket owners and Ozone admins can rename snapshots", OMException.ResultCodes.PERMISSION_DENIED);
        }
        OzoneManagerProtocolProtos.OMRequest.Builder omRequestBuilder = omRequest.toBuilder().setRenameSnapshotRequest(OzoneManagerProtocolProtos.RenameSnapshotRequest.newBuilder().setVolumeName(volumeName).setBucketName(bucketName).setSnapshotNewName(snapshotNewName).setSnapshotOldName(renameSnapshotRequest.getSnapshotOldName()).setRenameTime(Time.now()));
        return omRequestBuilder.build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        SnapshotInfo snapshotOldInfo;
        String snapshotOldName;
        String bucketName;
        String volumeName;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        OMClientResponse omClientResponse;
        Exception exception;
        block24: {
            OMMetrics omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumSnapshotRenames();
            boolean acquiredBucketLock = false;
            boolean acquiredSnapshotOldLock = false;
            boolean acquiredSnapshotNewLock = false;
            exception = null;
            OmMetadataManagerImpl omMetadataManager = (OmMetadataManagerImpl)ozoneManager.getMetadataManager();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omClientResponse = null;
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            OzoneManagerProtocolProtos.RenameSnapshotRequest request = this.getOmRequest().getRenameSnapshotRequest();
            volumeName = request.getVolumeName();
            bucketName = request.getBucketName();
            String snapshotNewName = request.getSnapshotNewName();
            snapshotOldName = request.getSnapshotOldName();
            snapshotOldInfo = null;
            try {
                try {
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    acquiredBucketLock = this.getOmLockDetails().isLockAcquired();
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.SNAPSHOT_LOCK, new String[]{volumeName, bucketName, snapshotOldName}));
                    acquiredSnapshotOldLock = this.getOmLockDetails().isLockAcquired();
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.SNAPSHOT_LOCK, new String[]{volumeName, bucketName, snapshotNewName}));
                    acquiredSnapshotNewLock = this.getOmLockDetails().isLockAcquired();
                    String snapshotNewTableKey = SnapshotInfo.getTableKey((String)volumeName, (String)bucketName, (String)snapshotNewName);
                    if (omMetadataManager.getSnapshotInfoTable().isExist((Object)snapshotNewTableKey)) {
                        throw new OMException("Snapshot with name " + snapshotNewName + " already exist", OMException.ResultCodes.FILE_ALREADY_EXISTS);
                    }
                    String snapshotOldTableKey = SnapshotInfo.getTableKey((String)volumeName, (String)bucketName, (String)snapshotOldName);
                    snapshotOldInfo = (SnapshotInfo)omMetadataManager.getSnapshotInfoTable().get((Object)snapshotOldTableKey);
                    if (snapshotOldInfo == null) {
                        throw new OMException("Snapshot with name " + snapshotOldName + "does not exist", OMException.ResultCodes.FILE_NOT_FOUND);
                    }
                    switch (snapshotOldInfo.getSnapshotStatus()) {
                        case SNAPSHOT_DELETED: {
                            throw new OMException("Snapshot is already deleted. Pending reclamation.", OMException.ResultCodes.FILE_NOT_FOUND);
                        }
                        case SNAPSHOT_ACTIVE: {
                            break;
                        }
                        default: {
                            throw new OMException("Snapshot exists but no longer in active state", OMException.ResultCodes.FILE_NOT_FOUND);
                        }
                    }
                    snapshotOldInfo.setName(snapshotNewName);
                    omMetadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)snapshotOldTableKey), CacheValue.get((long)context.getIndex()));
                    omMetadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)snapshotNewTableKey), CacheValue.get((long)context.getIndex(), (Object)snapshotOldInfo));
                    omMetadataManager.getSnapshotChainManager().updateSnapshot(snapshotOldInfo);
                    omResponse.setRenameSnapshotResponse(OzoneManagerProtocolProtos.RenameSnapshotResponse.newBuilder().setSnapshotInfo(snapshotOldInfo.getProtobuf()));
                    omClientResponse = new OMSnapshotRenameResponse(omResponse.build(), snapshotOldTableKey, snapshotNewTableKey, snapshotOldInfo);
                }
                catch (IOException | InvalidPathException ex) {
                    omMetrics.incNumSnapshotRenameFails();
                    exception = ex;
                    omClientResponse = new OMSnapshotRenameResponse(this.createErrorOMResponse(omResponse, exception));
                    if (acquiredSnapshotNewLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.SNAPSHOT_LOCK, new String[]{volumeName, bucketName, snapshotNewName}));
                    }
                    if (acquiredSnapshotOldLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.SNAPSHOT_LOCK, new String[]{volumeName, bucketName, snapshotOldName}));
                    }
                    if (acquiredBucketLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (acquiredSnapshotNewLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.SNAPSHOT_LOCK, new String[]{volumeName, bucketName, snapshotNewName}));
                }
                if (acquiredSnapshotOldLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.SNAPSHOT_LOCK, new String[]{volumeName, bucketName, snapshotOldName}));
                }
                if (acquiredBucketLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredSnapshotNewLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.SNAPSHOT_LOCK, new String[]{volumeName, bucketName, snapshotNewName}));
            }
            if (acquiredSnapshotOldLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.SNAPSHOT_LOCK, new String[]{volumeName, bucketName, snapshotOldName}));
            }
            if (acquiredBucketLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        if (snapshotOldInfo == null) {
            snapshotOldInfo = SnapshotInfo.newInstance((String)volumeName, (String)bucketName, (String)snapshotOldName, null, (long)Time.now());
        }
        this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.RENAME_SNAPSHOT, snapshotOldInfo.toAuditMap(), exception, userInfo));
        return omClientResponse;
    }

    static {
        OMSnapshotRenameRequest.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMSnapshotRenameRequest.java", OMSnapshotRenameRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.snapshot.OMSnapshotRenameRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 69);
    }
}

