/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.validation.RequestFeatureValidator;
import org.apache.hadoop.ozone.om.request.validation.ValidationCondition;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3MultipartUploadCommitPartResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.request.validation.RequestProcessingPhase;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3MultipartUploadCommitPartRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        S3MultipartUploadCommitPartRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(S3MultipartUploadCommitPartRequest.class);
    }

    public S3MultipartUploadCommitPartRequest(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.MultipartCommitUploadPartRequest multipartCommitUploadPartRequest = super.preExecute(ozoneManager).getCommitMultiPartUploadRequest();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = multipartCommitUploadPartRequest.getKeyArgs();
        String keyPath = keyArgs.getKeyName();
        keyPath = S3MultipartUploadCommitPartRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyPath, this.getBucketLayout());
        OzoneManagerProtocolProtos.KeyArgs newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now()).setKeyName(keyPath).build();
        OzoneManagerProtocolProtos.KeyArgs resolvedArgs = this.resolveBucketAndCheckOpenKeyAcls(newKeyArgs, ozoneManager, IAccessAuthorizer.ACLType.WRITE, multipartCommitUploadPartRequest.getClientID());
        return this.getOmRequest().toBuilder().setCommitMultiPartUploadRequest(multipartCommitUploadPartRequest.toBuilder().setKeyArgs(resolvedArgs)).setUserInfo(this.getUserInfo()).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMClientRequest.Result result;
        OMClientResponse omClientResponse;
        String partName;
        Exception exception;
        String keyName;
        String bucketName;
        String volumeName;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.KeyArgs keyArgs;
        OzoneManagerProtocolProtos.MultipartCommitUploadPartRequest multipartCommitUploadPartRequest;
        block16: {
            long trxnLogIndex = context.getIndex();
            multipartCommitUploadPartRequest = this.getOmRequest().getCommitMultiPartUploadRequest();
            keyArgs = multipartCommitUploadPartRequest.getKeyArgs();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            auditMap.put("uploadID", keyArgs.getMultipartUploadID());
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            keyName = keyArgs.getKeyName();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            ozoneManager.getMetrics().incNumCommitMultipartUploadParts();
            boolean acquiredLock = false;
            exception = null;
            partName = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omClientResponse = null;
            OzoneManagerProtocolProtos.PartKeyInfo oldPartKeyInfo = null;
            String openKey = null;
            OmKeyInfo omKeyInfo = null;
            String multipartKey = null;
            OmMultipartKeyInfo multipartKeyInfo = null;
            result = null;
            OmBucketInfo omBucketInfo = null;
            OmBucketInfo copyBucketInfo = null;
            long bucketId = 0L;
            try {
                try {
                    long clientID = multipartCommitUploadPartRequest.getClientID();
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    acquiredLock = this.getOmLockDetails().isLockAcquired();
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    bucketId = omMetadataManager.getBucketId(volumeName, bucketName);
                    String uploadID = keyArgs.getMultipartUploadID();
                    multipartKey = this.getMultipartKey(volumeName, bucketName, keyName, omMetadataManager, uploadID);
                    multipartKeyInfo = (OmMultipartKeyInfo)omMetadataManager.getMultipartInfoTable().get((Object)multipartKey);
                    openKey = this.getOpenKey(volumeName, bucketName, keyName, omMetadataManager, clientID);
                    String ozoneKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
                    omKeyInfo = this.getOmKeyInfo(omMetadataManager, openKey, keyName);
                    if (omKeyInfo == null) {
                        throw new OMException("Failed to commit Multipart Upload key, as " + openKey + "entry is not found in the openKey table", OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    omKeyInfo.getMetadata().putAll(KeyValueUtil.getFromProtobuf((List)keyArgs.getMetadataList()));
                    omKeyInfo.setDataSize(keyArgs.getDataSize());
                    List uncommitted = omKeyInfo.updateLocationInfoList(keyArgs.getKeyLocationsList().stream().map(OmKeyLocationInfo::getFromProtobuf).collect(Collectors.toList()), true);
                    omKeyInfo.setModificationTime(keyArgs.getModificationTime());
                    omKeyInfo.setUpdateID(trxnLogIndex);
                    int partNumber = keyArgs.getMultipartNumber();
                    partName = S3MultipartUploadCommitPartRequest.getPartName(ozoneKey, uploadID, partNumber);
                    if (multipartKeyInfo == null) {
                        throw new OMException("No such Multipart upload is with specified uploadId " + uploadID, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
                    }
                    oldPartKeyInfo = multipartKeyInfo.getPartKeyInfo(partNumber);
                    OzoneManagerProtocolProtos.PartKeyInfo.Builder partKeyInfo = OzoneManagerProtocolProtos.PartKeyInfo.newBuilder();
                    partKeyInfo.setPartName(partName);
                    partKeyInfo.setPartNumber(partNumber);
                    partKeyInfo.setPartKeyInfo(omKeyInfo.getProtobuf(this.getOmRequest().getVersion()));
                    multipartKeyInfo.addPartKeyInfo(partKeyInfo.build());
                    multipartKeyInfo.setUpdateID(trxnLogIndex);
                    omMetadataManager.getMultipartInfoTable().addCacheEntry(new CacheKey((Object)multipartKey), CacheValue.get((long)trxnLogIndex, (Object)multipartKeyInfo));
                    omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)openKey), CacheValue.get((long)trxnLogIndex));
                    omBucketInfo = S3MultipartUploadCommitPartRequest.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    Map<String, RepeatedOmKeyInfo> keyVersionsToDeleteMap = null;
                    long correctedSpace = omKeyInfo.getReplicatedSize();
                    if (oldPartKeyInfo != null) {
                        OmKeyInfo partKeyToBeDeleted = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)oldPartKeyInfo.getPartKeyInfo());
                        correctedSpace -= partKeyToBeDeleted.getReplicatedSize();
                        RepeatedOmKeyInfo oldVerKeyInfo = this.getOldVersionsToCleanUp(partKeyToBeDeleted, omBucketInfo.getObjectID(), trxnLogIndex);
                        String delKeyName = omMetadataManager.getOzoneDeletePathKey(partKeyToBeDeleted.getObjectID(), multipartKey);
                        if (!oldVerKeyInfo.getOmKeyInfoList().isEmpty()) {
                            keyVersionsToDeleteMap = new HashMap<String, RepeatedOmKeyInfo>();
                            keyVersionsToDeleteMap.put(delKeyName, oldVerKeyInfo);
                        }
                    }
                    this.checkBucketQuotaInBytes(omMetadataManager, omBucketInfo, correctedSpace);
                    omBucketInfo.incrUsedBytes(correctedSpace);
                    OmKeyInfo pseudoKeyInfo = this.wrapUncommittedBlocksAsPseudoKey(uncommitted, omKeyInfo);
                    keyVersionsToDeleteMap = S3MultipartUploadCommitPartRequest.addKeyInfoToDeleteMap(ozoneManager, trxnLogIndex, ozoneKey, omBucketInfo.getObjectID(), pseudoKeyInfo, keyVersionsToDeleteMap);
                    OzoneManagerProtocolProtos.MultipartCommitUploadPartResponse.Builder commitResponseBuilder = OzoneManagerProtocolProtos.MultipartCommitUploadPartResponse.newBuilder().setPartName(partName);
                    String eTag = (String)omKeyInfo.getMetadata().get("ETag");
                    if (eTag != null) {
                        commitResponseBuilder.setETag(eTag);
                    }
                    omResponse.setCommitMultiPartUploadResponse(commitResponseBuilder);
                    omClientResponse = this.getOmClientResponse(ozoneManager, keyVersionsToDeleteMap, openKey, omKeyInfo, multipartKey, multipartKeyInfo, omResponse.build(), omBucketInfo.copyObject(), bucketId);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = this.getOmClientResponse(ozoneManager, null, openKey, omKeyInfo, multipartKey, multipartKeyInfo, this.createErrorOMResponse(omResponse, exception), copyBucketInfo, bucketId);
                    if (acquiredLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (acquiredLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.logResult(ozoneManager, multipartCommitUploadPartRequest, keyArgs, auditMap, volumeName, bucketName, keyName, exception, partName, result);
        return omClientResponse;
    }

    @VisibleForTesting
    public static String getPartName(String ozoneKey, String uploadID, long partNumber) {
        return String.valueOf(ozoneKey) + "-" + uploadID + "-" + partNumber;
    }

    protected S3MultipartUploadCommitPartResponse getOmClientResponse(OzoneManager ozoneManager, Map<String, RepeatedOmKeyInfo> keyToDeleteMap, String openKey, OmKeyInfo omKeyInfo, String multipartKey, OmMultipartKeyInfo multipartKeyInfo, OzoneManagerProtocolProtos.OMResponse build, OmBucketInfo omBucketInfo, long bucketId) {
        return new S3MultipartUploadCommitPartResponse(build, multipartKey, openKey, multipartKeyInfo, keyToDeleteMap, omKeyInfo, omBucketInfo, bucketId, this.getBucketLayout());
    }

    protected OmKeyInfo getOmKeyInfo(OMMetadataManager omMetadataManager, String openKey, String keyName) throws IOException {
        return (OmKeyInfo)omMetadataManager.getOpenKeyTable(this.getBucketLayout()).get((Object)openKey);
    }

    protected String getOpenKey(String volumeName, String bucketName, String keyName, OMMetadataManager omMetadataManager, long clientID) throws IOException {
        return omMetadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
    }

    private void logResult(OzoneManager ozoneManager, OzoneManagerProtocolProtos.MultipartCommitUploadPartRequest multipartCommitUploadPartRequest, OzoneManagerProtocolProtos.KeyArgs keyArgs, Map<String, String> auditMap, String volumeName, String bucketName, String keyName, Exception exception, String partName, OMClientRequest.Result result) {
        auditMap.put("partNumber", String.valueOf(keyArgs.getMultipartNumber()));
        auditMap.put("partName", partName);
        this.markForAudit(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.COMMIT_MULTIPART_UPLOAD_PARTKEY, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (result) {
            case SUCCESS: {
                LOG.debug("MultipartUpload Commit is successfully for Key:{} in Volume/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName});
                break;
            }
            case FAILURE: {
                ozoneManager.getMetrics().incNumCommitMultipartUploadPartFails();
                LOG.error("MultipartUpload Commit is failed for Key:{} in Volume/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for S3MultipartUploadCommitPartRequest: {}", (Object)multipartCommitUploadPartRequest);
            }
        }
    }

    private String getMultipartKey(String volumeName, String bucketName, String keyName, OMMetadataManager omMetadataManager, String uploadID) {
        return omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
    }

    @RequestFeatureValidator(conditions={ValidationCondition.CLUSTER_NEEDS_FINALIZATION}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.CommitMultiPartUpload)
    public static OzoneManagerProtocolProtos.OMRequest disallowCommitMultiPartUploadWithECReplicationConfig(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws OMException {
        if (!ctx.versionManager().isAllowed((LayoutFeature)OMLayoutFeature.ERASURE_CODED_STORAGE_SUPPORT) && req.getCommitMultiPartUploadRequest().getKeyArgs().hasEcReplicationConfig()) {
            throw new OMException("Cluster does not have the Erasure Coded Storage support feature finalized yet, but the request contains an Erasure Coded replication type. Rejecting the request, please finalize the cluster upgrade and then try again.", OMException.ResultCodes.NOT_SUPPORTED_OPERATION_PRIOR_FINALIZATION);
        }
        return req;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.CommitMultiPartUpload)
    public static OzoneManagerProtocolProtos.OMRequest blockMPUCommitWithBucketLayoutFromOldClient(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs;
        if (req.getCommitMultiPartUploadRequest().hasKeyArgs() && (keyArgs = req.getCommitMultiPartUploadRequest().getKeyArgs()).hasVolumeName() && keyArgs.hasBucketName()) {
            BucketLayout bucketLayout = ctx.getBucketLayout(keyArgs.getVolumeName(), keyArgs.getBucketName());
            bucketLayout.validateSupportedOperation();
        }
        return req;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("S3MultipartUploadCommitPartRequest.java", S3MultipartUploadCommitPartRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadCommitPartRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 80);
    }
}

