/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.multitenant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.ozone.om.multitenant.MultiTenantAccessController;

public class InMemoryMultiTenantAccessController
implements MultiTenantAccessController {
    private final Map<String, MultiTenantAccessController.Policy> policies = new HashMap<String, MultiTenantAccessController.Policy>();
    private final Map<String, MultiTenantAccessController.Role> roles = new HashMap<String, MultiTenantAccessController.Role>();
    private long nextRoleID = 0L;
    private long serviceVersion = 0L;

    @Override
    public MultiTenantAccessController.Policy createPolicy(MultiTenantAccessController.Policy policy) throws IOException {
        if (this.policies.containsKey(policy.getName())) {
            throw new IOException("Policy already exists.");
        }
        for (MultiTenantAccessController.Policy existingPolicy : this.policies.values()) {
            if (!existingPolicy.getVolumes().equals(policy.getVolumes()) || !existingPolicy.getBuckets().equals(policy.getBuckets()) || !existingPolicy.getKeys().equals(policy.getKeys())) continue;
            throw new IOException("Policy for the same resource already defined.");
        }
        this.policies.put(policy.getName(), policy);
        for (String roleName : policy.getRoleAcls().keySet()) {
            if (this.roles.containsKey(roleName)) continue;
            this.createRole(new MultiTenantAccessController.Role.Builder().setName(roleName).build());
        }
        ++this.serviceVersion;
        return policy;
    }

    @Override
    public MultiTenantAccessController.Policy getPolicy(String policyName) throws IOException {
        if (!this.policies.containsKey(policyName)) {
            throw new IOException("Policy does not exist.");
        }
        return this.policies.get(policyName);
    }

    @Override
    public List<MultiTenantAccessController.Policy> getLabeledPolicies(String label) throws IOException {
        ArrayList<MultiTenantAccessController.Policy> result = new ArrayList<MultiTenantAccessController.Policy>();
        for (MultiTenantAccessController.Policy policy : this.policies.values()) {
            if (!policy.getLabels().contains(label)) continue;
            result.add(policy);
        }
        return result;
    }

    @Override
    public MultiTenantAccessController.Policy updatePolicy(MultiTenantAccessController.Policy policy) throws IOException {
        if (!this.policies.containsKey(policy.getName())) {
            throw new IOException("Policy does not exist.");
        }
        this.policies.put(policy.getName(), policy);
        ++this.serviceVersion;
        return policy;
    }

    @Override
    public void deletePolicy(String policyName) throws IOException {
        if (!this.policies.containsKey(policyName)) {
            throw new IOException("Policy does not exist.");
        }
        this.policies.remove(policyName);
        ++this.serviceVersion;
    }

    @Override
    public MultiTenantAccessController.Role createRole(MultiTenantAccessController.Role role) throws IOException {
        if (this.roles.containsKey(role.getName())) {
            throw new IOException("Role already exists.");
        }
        MultiTenantAccessController.Role newRole = new MultiTenantAccessController.Role.Builder(role).setID(this.nextRoleID).build();
        ++this.nextRoleID;
        this.roles.put(newRole.getName(), newRole);
        ++this.serviceVersion;
        return role;
    }

    @Override
    public MultiTenantAccessController.Role getRole(String roleName) throws IOException {
        if (!this.roles.containsKey(roleName)) {
            throw new IOException("Role does not exist.");
        }
        return this.roles.get(roleName);
    }

    @Override
    public MultiTenantAccessController.Role updateRole(long roleId, MultiTenantAccessController.Role role) throws IOException {
        Optional<MultiTenantAccessController.Role> originalRole = this.roles.values().stream().filter(r -> r.getId().isPresent() && r.getId().get() == roleId).findFirst();
        if (!originalRole.isPresent()) {
            throw new IOException("Role does not exist.");
        }
        this.roles.remove(originalRole.get().getName());
        this.roles.put(role.getName(), role);
        ++this.serviceVersion;
        return role;
    }

    @Override
    public void deleteRole(String roleName) throws IOException {
        if (!this.roles.containsKey(roleName)) {
            throw new IOException("Role does not exist.");
        }
        this.roles.remove(roleName);
        ++this.serviceVersion;
    }

    @Override
    public long getRangerServicePolicyVersion() {
        return this.serviceVersion;
    }
}

