/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.lock;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OMLockDetails;
import org.apache.hadoop.ozone.om.lock.OzoneLockStrategy;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;

public class OBSKeyPathLockStrategy
implements OzoneLockStrategy {
    @Override
    public OMLockDetails acquireWriteLock(OMMetadataManager omMetadataManager, String volumeName, String bucketName, String keyName) throws IOException {
        OMFileRequest.validateBucket(omMetadataManager, volumeName, bucketName);
        OMLockDetails omLockDetails = omMetadataManager.getLock().acquireReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        Preconditions.checkArgument((boolean)omLockDetails.isLockAcquired(), (Object)"BUCKET_LOCK should be acquired!");
        omLockDetails.merge(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.KEY_PATH_LOCK, new String[]{volumeName, bucketName, keyName}));
        return omLockDetails;
    }

    @Override
    public OMLockDetails releaseWriteLock(OMMetadataManager omMetadataManager, String volumeName, String bucketName, String keyName) {
        OMLockDetails omLockDetails = omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.KEY_PATH_LOCK, new String[]{volumeName, bucketName, keyName});
        omLockDetails.merge(omMetadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
        return omLockDetails;
    }

    @Override
    public OMLockDetails acquireReadLock(OMMetadataManager omMetadataManager, String volumeName, String bucketName, String keyName) throws IOException {
        OMFileRequest.validateBucket(omMetadataManager, volumeName, bucketName);
        OMLockDetails omLockDetails = omMetadataManager.getLock().acquireReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        Preconditions.checkArgument((boolean)omLockDetails.isLockAcquired(), (Object)"BUCKET_LOCK should be acquired!");
        omLockDetails.merge(omMetadataManager.getLock().acquireReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.KEY_PATH_LOCK, new String[]{volumeName, bucketName, keyName}));
        return omLockDetails;
    }

    @Override
    public OMLockDetails releaseReadLock(OMMetadataManager omMetadataManager, String volumeName, String bucketName, String keyName) {
        OMLockDetails omLockDetails = omMetadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.KEY_PATH_LOCK, new String[]{volumeName, bucketName, keyName});
        omLockDetails.merge(omMetadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
        return omLockDetails;
    }
}

