/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;

@InterfaceAudience.Private
@Metrics(about="Ozone Bucket Utilization Metrics", context="ozone")
public class BucketUtilizationMetrics
implements MetricsSource {
    private static final String SOURCE = BucketUtilizationMetrics.class.getSimpleName();
    private final OMMetadataManager metadataManager;

    public BucketUtilizationMetrics(OMMetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }

    public static BucketUtilizationMetrics create(OMMetadataManager metadataManager) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (BucketUtilizationMetrics)ms.register(SOURCE, "Bucket Utilization Metrics", (Object)new BucketUtilizationMetrics(metadataManager));
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        Iterator bucketIterator = this.metadataManager.getBucketIterator();
        while (bucketIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)bucketIterator.next();
            OmBucketInfo bucketInfo = (OmBucketInfo)((CacheValue)entry.getValue()).getCacheValue();
            if (bucketInfo == null) continue;
            long quotaInBytes = bucketInfo.getQuotaInBytes();
            long availableSpace = quotaInBytes == -1L ? quotaInBytes : Math.max(bucketInfo.getQuotaInBytes() - bucketInfo.getTotalBucketSpace(), 0L);
            collector.addRecord(SOURCE).setContext("Bucket metrics").tag((MetricsInfo)BucketMetricsInfo.VolumeName, bucketInfo.getVolumeName()).tag((MetricsInfo)BucketMetricsInfo.BucketName, bucketInfo.getBucketName()).addGauge((MetricsInfo)BucketMetricsInfo.BucketUsedBytes, bucketInfo.getUsedBytes()).addGauge((MetricsInfo)BucketMetricsInfo.BucketSnapshotUsedBytes, bucketInfo.getSnapshotUsedBytes()).addGauge((MetricsInfo)BucketMetricsInfo.BucketQuotaBytes, bucketInfo.getQuotaInBytes()).addGauge((MetricsInfo)BucketMetricsInfo.BucketQuotaNamespace, bucketInfo.getQuotaInNamespace()).addGauge((MetricsInfo)BucketMetricsInfo.BucketAvailableBytes, availableSpace);
        }
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE);
    }

    static enum BucketMetricsInfo implements MetricsInfo
    {
        VolumeName("Volume Metrics."),
        BucketName("Bucket Metrics."),
        BucketUsedBytes("Bytes used by bucket in AOS."),
        BucketQuotaBytes("Bucket quota in bytes"),
        BucketSnapshotUsedBytes("Bucket quota bytes held in snapshots"),
        BucketQuotaNamespace("Bucket quota in namespace."),
        BucketAvailableBytes("Bucket available space.");

        private final String desc;

        private BucketMetricsInfo(String desc) {
            this.desc = desc;
        }

        public String description() {
            return this.desc;
        }
    }
}

