/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty;

import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.security.TlsConf;
import org.apache.ratis.thirdparty.io.netty.util.NettyRuntime;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface NettyConfigKeys {
    public static final String PREFIX = "raft.netty";

    public static void main(String[] args2) {
        ConfUtils.printAll(NettyConfigKeys.class);
    }

    public static interface DataStream {
        public static final Logger LOG = LoggerFactory.getLogger(DataStream.class);
        public static final String PREFIX = "raft.netty.dataStream";
        public static final String HOST_KEY = "raft.netty.dataStream.host";
        public static final String HOST_DEFAULT = null;
        public static final String PORT_KEY = "raft.netty.dataStream.port";
        public static final int PORT_DEFAULT = 0;

        public static Consumer<String> getDefaultLog() {
            return arg_0 -> ((Logger)LOG).info(arg_0);
        }

        public static String host(RaftProperties properties) {
            return ConfUtils.get(properties::get, HOST_KEY, HOST_DEFAULT, DataStream.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setHost(RaftProperties properties, String host) {
            ConfUtils.set(properties::set, HOST_KEY, host, new BiConsumer[0]);
        }

        public static int port(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, PORT_KEY, 0, DataStream.getDefaultLog(), ConfUtils.requireMin(0), ConfUtils.requireMax(65536));
        }

        public static void setPort(RaftProperties properties, int port) {
            ConfUtils.setInt(properties::setInt, PORT_KEY, port, new BiConsumer[0]);
        }

        public static interface Server {
            public static final String PREFIX = "raft.netty.dataStream.server";
            public static final String TLS_CONF_PARAMETER = "raft.netty.dataStream.server.tls.conf";
            public static final Class<TlsConf> TLS_CONF_CLASS = TlsConf.class;
            public static final String USE_EPOLL_KEY = "raft.netty.dataStream.server.use-epoll";
            public static final boolean USE_EPOLL_DEFAULT = true;
            public static final String BOSS_GROUP_SIZE_KEY = "raft.netty.dataStream.server.boss-group.size";
            public static final int BOSS_GROUP_SIZE_DEFAULT = 0;
            public static final String WORKER_GROUP_SIZE_KEY = "raft.netty.dataStream.server.worker-group.size";
            public static final int WORKER_GROUP_SIZE_DEFAULT = 0;
            public static final String CHANNEL_INACTIVE_GRACE_PERIOD_KEY = "raft.netty.dataStream.server.channel.inactive.grace-period";
            public static final TimeDuration CHANNEL_INACTIVE_GRACE_PERIOD_DEFAULT = TimeDuration.valueOf(10L, TimeUnit.MINUTES);

            public static TlsConf tlsConf(Parameters parameters) {
                return ConfUtils.getTlsConf(key -> parameters.get((String)key, TLS_CONF_CLASS), TLS_CONF_PARAMETER, DataStream.getDefaultLog());
            }

            public static void setTlsConf(Parameters parameters, TlsConf conf) {
                LOG.info("setTlsConf " + conf);
                ConfUtils.setTlsConf((key, value) -> parameters.put((String)key, value, TLS_CONF_CLASS), TLS_CONF_PARAMETER, conf);
            }

            public static boolean useEpoll(RaftProperties properties) {
                return ConfUtils.getBoolean(properties::getBoolean, USE_EPOLL_KEY, true, DataStream.getDefaultLog(), new BiConsumer[0]);
            }

            public static void setUseEpoll(RaftProperties properties, boolean enable) {
                ConfUtils.setBoolean(properties::setBoolean, USE_EPOLL_KEY, enable, new BiConsumer[0]);
            }

            public static int bossGroupSize(RaftProperties properties) {
                return ConfUtils.getInt(properties::getInt, BOSS_GROUP_SIZE_KEY, 0, DataStream.getDefaultLog(), ConfUtils.requireMin(0), ConfUtils.requireMax(65536));
            }

            public static void setBossGroupSize(RaftProperties properties, int num) {
                ConfUtils.setInt(properties::setInt, BOSS_GROUP_SIZE_KEY, num, new BiConsumer[0]);
            }

            public static int workerGroupSize(RaftProperties properties) {
                return ConfUtils.getInt(properties::getInt, WORKER_GROUP_SIZE_KEY, 0, DataStream.getDefaultLog(), ConfUtils.requireMin(0), ConfUtils.requireMax(65536));
            }

            public static void setWorkerGroupSize(RaftProperties properties, int num) {
                ConfUtils.setInt(properties::setInt, WORKER_GROUP_SIZE_KEY, num, new BiConsumer[0]);
            }

            public static TimeDuration channelInactiveGracePeriod(RaftProperties properties) {
                return ConfUtils.getTimeDuration(properties.getTimeDuration(CHANNEL_INACTIVE_GRACE_PERIOD_DEFAULT.getUnit()), CHANNEL_INACTIVE_GRACE_PERIOD_KEY, CHANNEL_INACTIVE_GRACE_PERIOD_DEFAULT, DataStream.getDefaultLog(), new BiConsumer[0]);
            }

            public static void setChannelInactiveGracePeriod(RaftProperties properties, TimeDuration timeoutDuration) {
                ConfUtils.setTimeDuration(properties::setTimeDuration, CHANNEL_INACTIVE_GRACE_PERIOD_KEY, timeoutDuration, new BiConsumer[0]);
            }
        }

        public static interface Client {
            public static final String PREFIX = "raft.netty.dataStream.client";
            public static final String TLS_CONF_PARAMETER = "raft.netty.dataStream.client.tls.conf";
            public static final Class<TlsConf> TLS_CONF_CLASS = TlsConf.class;
            public static final String USE_EPOLL_KEY = "raft.netty.dataStream.client.use-epoll";
            public static final boolean USE_EPOLL_DEFAULT = true;
            public static final String WORKER_GROUP_SIZE_KEY = "raft.netty.dataStream.client.worker-group.size";
            public static final int WORKER_GROUP_SIZE_DEFAULT = Math.max(1, NettyRuntime.availableProcessors() * 2);
            public static final String WORKER_GROUP_SHARE_KEY = "raft.netty.dataStream.client.worker-group.share";
            public static final boolean WORKER_GROUP_SHARE_DEFAULT = true;
            public static final String REPLY_QUEUE_GRACE_PERIOD_KEY = "raft.netty.dataStream.client.reply.queue.grace-period";
            public static final TimeDuration REPLY_QUEUE_GRACE_PERIOD_DEFAULT = TimeDuration.ONE_SECOND;

            public static TlsConf tlsConf(Parameters parameters) {
                return ConfUtils.getTlsConf(key -> parameters.get((String)key, TLS_CONF_CLASS), TLS_CONF_PARAMETER, DataStream.getDefaultLog());
            }

            public static void setTlsConf(Parameters parameters, TlsConf conf) {
                LOG.info("setTlsConf " + conf);
                ConfUtils.setTlsConf((key, value) -> parameters.put((String)key, value, TLS_CONF_CLASS), TLS_CONF_PARAMETER, conf);
            }

            public static boolean useEpoll(RaftProperties properties) {
                return ConfUtils.getBoolean(properties::getBoolean, USE_EPOLL_KEY, true, DataStream.getDefaultLog(), new BiConsumer[0]);
            }

            public static void setUseEpoll(RaftProperties properties, boolean enable) {
                ConfUtils.setBoolean(properties::setBoolean, USE_EPOLL_KEY, enable, new BiConsumer[0]);
            }

            public static int workerGroupSize(RaftProperties properties) {
                return ConfUtils.getInt(properties::getInt, WORKER_GROUP_SIZE_KEY, WORKER_GROUP_SIZE_DEFAULT, DataStream.getDefaultLog(), ConfUtils.requireMin(1), ConfUtils.requireMax(65536));
            }

            public static void setWorkerGroupSize(RaftProperties properties, int clientWorkerGroupSize) {
                ConfUtils.setInt(properties::setInt, WORKER_GROUP_SIZE_KEY, clientWorkerGroupSize, new BiConsumer[0]);
            }

            public static boolean workerGroupShare(RaftProperties properties) {
                return ConfUtils.getBoolean(properties::getBoolean, WORKER_GROUP_SHARE_KEY, true, DataStream.getDefaultLog(), new BiConsumer[0]);
            }

            public static void setWorkerGroupShare(RaftProperties properties, boolean clientWorkerGroupShare) {
                ConfUtils.setBoolean(properties::setBoolean, WORKER_GROUP_SHARE_KEY, clientWorkerGroupShare, new BiConsumer[0]);
            }

            public static TimeDuration replyQueueGracePeriod(RaftProperties properties) {
                return ConfUtils.getTimeDuration(properties.getTimeDuration(REPLY_QUEUE_GRACE_PERIOD_DEFAULT.getUnit()), REPLY_QUEUE_GRACE_PERIOD_KEY, REPLY_QUEUE_GRACE_PERIOD_DEFAULT, DataStream.getDefaultLog(), new BiConsumer[0]);
            }

            public static void setReplyQueueGracePeriod(RaftProperties properties, TimeDuration timeoutDuration) {
                ConfUtils.setTimeDuration(properties::setTimeDuration, REPLY_QUEUE_GRACE_PERIOD_KEY, timeoutDuration, new BiConsumer[0]);
            }
        }
    }

    public static interface Client {
        public static final Logger LOG = LoggerFactory.getLogger(Client.class);
        public static final String PREFIX = "raft.netty.client";
        public static final String USE_EPOLL_KEY = "raft.netty.client.use-epoll";
        public static final boolean USE_EPOLL_DEFAULT = true;

        public static Consumer<String> getDefaultLog() {
            return arg_0 -> ((Logger)LOG).debug(arg_0);
        }

        public static boolean useEpoll(RaftProperties properties) {
            return ConfUtils.getBoolean(properties::getBoolean, USE_EPOLL_KEY, true, Client.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setUseEpoll(RaftProperties properties, boolean enable) {
            ConfUtils.setBoolean(properties::setBoolean, USE_EPOLL_KEY, enable, new BiConsumer[0]);
        }
    }

    public static interface Server {
        public static final Logger LOG = LoggerFactory.getLogger(Server.class);
        public static final String PREFIX = "raft.netty.server";
        public static final String HOST_KEY = "raft.netty.server.host";
        public static final String HOST_DEFAULT = null;
        public static final String PORT_KEY = "raft.netty.server.port";
        public static final int PORT_DEFAULT = 0;
        public static final String USE_EPOLL_KEY = "raft.netty.server.use-epoll";
        public static final boolean USE_EPOLL_DEFAULT = true;

        public static Consumer<String> getDefaultLog() {
            return arg_0 -> ((Logger)LOG).info(arg_0);
        }

        public static String host(RaftProperties properties) {
            return ConfUtils.get(properties::get, HOST_KEY, HOST_DEFAULT, Server.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setHost(RaftProperties properties, String host) {
            ConfUtils.set(properties::set, HOST_KEY, host, new BiConsumer[0]);
        }

        public static int port(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, PORT_KEY, 0, Server.getDefaultLog(), ConfUtils.requireMin(0), ConfUtils.requireMax(65536));
        }

        public static void setPort(RaftProperties properties, int port) {
            ConfUtils.setInt(properties::setInt, PORT_KEY, port, new BiConsumer[0]);
        }

        public static boolean useEpoll(RaftProperties properties) {
            return ConfUtils.getBoolean(properties::getBoolean, USE_EPOLL_KEY, true, Server.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setUseEpoll(RaftProperties properties, boolean enable) {
            ConfUtils.setBoolean(properties::setBoolean, USE_EPOLL_KEY, enable, new BiConsumer[0]);
        }
    }
}

