/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.util;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableMetric;
import org.apache.hadoop.metrics2.util.SampleStat;
import org.apache.hadoop.ozone.shaded.org.apache.commons.lang3.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableMinMax
extends MutableMetric {
    private final SampleStat.MinMax intervalMinMax = new SampleStat.MinMax();
    private final SampleStat.MinMax prevMinMax = new SampleStat.MinMax();
    private final MetricsInfo iMinInfo;
    private final MetricsInfo iMaxInfo;

    public MutableMinMax(MetricsRegistry registry, String name, String description, String valueName) {
        String ucName = StringUtils.capitalize(name);
        String desc = StringUtils.uncapitalize(description);
        String uvName = StringUtils.capitalize(valueName);
        String lvName = StringUtils.uncapitalize(valueName);
        this.iMinInfo = Interns.info((String)(ucName + "IMin" + uvName), (String)("Min " + lvName + " for " + desc + "in the last reporting interval"));
        this.iMaxInfo = Interns.info((String)(ucName + "IMax" + uvName), (String)("Max " + lvName + " for " + desc + "in the last reporting interval"));
        registry.newGauge(this.iMinInfo, 0);
        registry.newGauge(this.iMaxInfo, 0);
    }

    public synchronized void add(long value) {
        this.intervalMinMax.add((double)value);
        this.setChanged();
    }

    private SampleStat.MinMax lastMinMax() {
        return this.changed() ? this.intervalMinMax : this.prevMinMax;
    }

    public synchronized void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            builder.addGauge(this.iMinInfo, this.lastMinMax().min());
            builder.addGauge(this.iMaxInfo, this.lastMinMax().max());
            if (this.changed()) {
                this.prevMinMax.reset(this.intervalMinMax);
                this.intervalMinMax.reset();
                this.clearChanged();
            }
        }
    }
}

