/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.bouncycastle.mime.smime;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.mime.BasicMimeParser;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.mime.Headers;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.mime.MimeParser;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.mime.MimeParserProvider;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.mime.smime.SMimeParserContext;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.mime.smime.SMimeUtils;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.DigestCalculatorProvider;

public class SMimeParserProvider
implements MimeParserProvider {
    private final String defaultContentTransferEncoding;
    private final DigestCalculatorProvider digestCalculatorProvider;

    public SMimeParserProvider(String string, DigestCalculatorProvider digestCalculatorProvider) {
        this.defaultContentTransferEncoding = string;
        this.digestCalculatorProvider = digestCalculatorProvider;
    }

    @Override
    public MimeParser createParser(InputStream inputStream2) throws IOException {
        return new BasicMimeParser(new SMimeParserContext(this.defaultContentTransferEncoding, this.digestCalculatorProvider), SMimeUtils.autoBuffer(inputStream2));
    }

    @Override
    public MimeParser createParser(Headers headers, InputStream inputStream2) throws IOException {
        return new BasicMimeParser(new SMimeParserContext(this.defaultContentTransferEncoding, this.digestCalculatorProvider), headers, SMimeUtils.autoBuffer(inputStream2));
    }
}

