/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.protocolPB;

import java.io.IOException;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.ozone.om.protocolPB.OmTransport;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface OmTransportFactory {
    public static final Logger LOG = LoggerFactory.getLogger(OmTransportFactory.class);

    public OmTransport createOmTransport(ConfigurationSource var1, UserGroupInformation var2, String var3) throws IOException;

    public static OmTransport create(ConfigurationSource conf, UserGroupInformation ugi, String omServiceId) throws IOException {
        OmTransportFactory factory2 = OmTransportFactory.createFactory(conf);
        return factory2.createOmTransport(conf, ugi, omServiceId);
    }

    public static OmTransportFactory createFactory(ConfigurationSource conf) throws IOException {
        try {
            ServiceLoader<OmTransportFactory> transportFactoryServiceLoader = ServiceLoader.load(OmTransportFactory.class);
            Iterator<OmTransportFactory> iterator2 = transportFactoryServiceLoader.iterator();
            if (iterator2.hasNext()) {
                OmTransportFactory next = iterator2.next();
                LOG.debug("Found OM transport implementation {} from service loader.", (Object)next.getClass().getName());
                return next;
            }
            String transportClassName = conf.get("ozone.om.transport.class", "org.apache.hadoop.ozone.om.protocolPB.Hadoop3OmTransportFactory");
            LOG.debug("Loading OM transport implementation {} as specified by configuration.", (Object)transportClassName);
            return OmTransportFactory.class.getClassLoader().loadClass(transportClassName).asSubclass(OmTransportFactory.class).newInstance();
        }
        catch (Exception ex) {
            throw new IOException("Can't create the default OmTransport implementation", ex);
        }
    }
}

