/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import org.apache.hadoop.ozone.om.helpers.WithMetadata;

public abstract class WithObjectID
extends WithMetadata {
    private long objectID;
    private long updateID;

    protected WithObjectID() {
    }

    protected WithObjectID(Builder b) {
        super(b);
        this.objectID = b.objectID;
        this.updateID = b.updateID;
    }

    protected WithObjectID(WithObjectID other) {
        super(other);
        this.objectID = other.objectID;
        this.updateID = other.updateID;
    }

    public final long getObjectID() {
        return this.objectID;
    }

    public final long getUpdateID() {
        return this.updateID;
    }

    public final void setObjectID(long obId) {
        if (this.objectID != 0L && obId != 0L) {
            throw new UnsupportedOperationException("Attempt to modify object ID which is not zero. Current Object ID is " + this.objectID);
        }
        this.objectID = obId;
    }

    public final void setUpdateID(long newValue) {
        long currentValue = this.getUpdateID();
        if (newValue < currentValue) {
            throw new IllegalArgumentException(String.format("Trying to set updateID to %d which is not greater than the current value of %d for %s", newValue, currentValue, this.getObjectInfo()));
        }
        this.updateID = newValue;
    }

    public String getObjectInfo() {
        return this.toString();
    }

    public static class Builder
    extends WithMetadata.Builder {
        private long objectID;
        private long updateID;

        protected Builder() {
        }

        protected Builder(WithObjectID obj) {
            super(obj);
            this.objectID = obj.getObjectID();
            this.updateID = obj.getUpdateID();
        }

        public Builder setObjectID(long obId) {
            this.objectID = obId;
            return this;
        }

        public Builder setUpdateID(long id) {
            this.updateID = id;
            return this;
        }

        public long getObjectID() {
            return this.objectID;
        }

        public long getUpdateID() {
            return this.updateID;
        }
    }
}

