/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.hadoop.ozone.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hadoop.ozone.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffResponse;

public class SnapshotDiffJob {
    private static final Codec<SnapshotDiffJob> CODEC = new SnapshotDiffJobCodec();
    private long creationTime;
    private String jobId;
    private SnapshotDiffResponse.JobStatus status;
    private String volume;
    private String bucket;
    private String fromSnapshot;
    private String toSnapshot;
    private boolean forceFullDiff;
    private boolean disableNativeDiff;
    private long totalDiffEntries;
    private String reason;

    public static Codec<SnapshotDiffJob> getCodec() {
        return CODEC;
    }

    public SnapshotDiffJob() {
    }

    public SnapshotDiffJob(long creationTime, String jobId, SnapshotDiffResponse.JobStatus jobStatus, String volume, String bucket, String fromSnapshot, String toSnapshot, boolean forceFullDiff, boolean disableNativeDiff, long totalDiffEntries) {
        this.creationTime = creationTime;
        this.jobId = jobId;
        this.status = jobStatus;
        this.volume = volume;
        this.bucket = bucket;
        this.fromSnapshot = fromSnapshot;
        this.toSnapshot = toSnapshot;
        this.forceFullDiff = forceFullDiff;
        this.disableNativeDiff = disableNativeDiff;
        this.totalDiffEntries = totalDiffEntries;
        this.reason = "";
    }

    public String getJobId() {
        return this.jobId;
    }

    public SnapshotDiffResponse.JobStatus getStatus() {
        return this.status;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setStatus(SnapshotDiffResponse.JobStatus status) {
        this.status = status;
    }

    public String getVolume() {
        return this.volume;
    }

    public void setVolume(String volume) {
        this.volume = volume;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getFromSnapshot() {
        return this.fromSnapshot;
    }

    public void setFromSnapshot(String fromSnapshot) {
        this.fromSnapshot = fromSnapshot;
    }

    public String getToSnapshot() {
        return this.toSnapshot;
    }

    public void setToSnapshot(String toSnapshot) {
        this.toSnapshot = toSnapshot;
    }

    public boolean isForceFullDiff() {
        return this.forceFullDiff;
    }

    public void setForceFullDiff(boolean forceFullDiff) {
        this.forceFullDiff = forceFullDiff;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getTotalDiffEntries() {
        return this.totalDiffEntries;
    }

    public void setTotalDiffEntries(long totalDiffEntries) {
        this.totalDiffEntries = totalDiffEntries;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean isNativeDiffDisabled() {
        return this.disableNativeDiff;
    }

    public void disableNativeDiff(boolean disableNativeDiffVal) {
        this.disableNativeDiff = disableNativeDiffVal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("creationTime : ").append(this.creationTime).append(", jobId: ").append(this.jobId).append(", status: ").append((Object)this.status).append(", volume: ").append(this.volume).append(", bucket: ").append(this.bucket).append(", fromSnapshot: ").append(this.fromSnapshot).append(", toSnapshot: ").append(this.toSnapshot).append(", forceFullDiff: ").append(this.forceFullDiff).append(", disableNativeDiff: ").append(this.disableNativeDiff).append(", totalDiffEntries: ").append(this.totalDiffEntries);
        if (StringUtils.isNotEmpty(this.reason)) {
            sb.append(", reason: ").append(this.reason);
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SnapshotDiffJob) {
            SnapshotDiffJob otherJob = (SnapshotDiffJob)other;
            return Objects.equals(this.creationTime, otherJob.creationTime) && Objects.equals(this.jobId, otherJob.jobId) && Objects.equals((Object)this.status, (Object)otherJob.status) && Objects.equals(this.volume, otherJob.volume) && Objects.equals(this.bucket, otherJob.bucket) && Objects.equals(this.fromSnapshot, otherJob.fromSnapshot) && Objects.equals(this.toSnapshot, otherJob.toSnapshot) && Objects.equals(this.forceFullDiff, otherJob.forceFullDiff) && Objects.equals(this.totalDiffEntries, otherJob.totalDiffEntries) && Objects.equals(this.disableNativeDiff, otherJob.disableNativeDiff) && Objects.equals(this.reason, otherJob.reason);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.creationTime, this.jobId, this.status, this.volume, this.bucket, this.fromSnapshot, this.toSnapshot, this.forceFullDiff, this.disableNativeDiff, this.totalDiffEntries, this.reason});
    }

    public OzoneManagerProtocolProtos.SnapshotDiffJobProto toProtoBuf() {
        return OzoneManagerProtocolProtos.SnapshotDiffJobProto.newBuilder().setCreationTime(this.creationTime).setJobId(this.jobId).setStatus(this.status.toProtobuf()).setVolume(this.volume).setBucket(this.bucket).setFromSnapshot(this.fromSnapshot).setToSnapshot(this.toSnapshot).setForceFullDiff(this.forceFullDiff).setDisableNativeDiff(this.disableNativeDiff).setTotalDiffEntries(this.totalDiffEntries).build();
    }

    public static SnapshotDiffJob getFromProtoBuf(OzoneManagerProtocolProtos.SnapshotDiffJobProto diffJobProto) {
        return new SnapshotDiffJob(diffJobProto.getCreationTime(), diffJobProto.getJobId(), SnapshotDiffResponse.JobStatus.fromProtobuf(diffJobProto.getStatus()), diffJobProto.getVolume(), diffJobProto.getBucket(), diffJobProto.getFromSnapshot(), diffJobProto.getToSnapshot(), diffJobProto.getForceFullDiff(), diffJobProto.getDisableNativeDiff(), diffJobProto.getTotalDiffEntries());
    }

    private static final class SnapshotDiffJobCodec
    implements Codec<SnapshotDiffJob> {
        private static final ObjectMapper MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

        private SnapshotDiffJobCodec() {
        }

        @Override
        public Class<SnapshotDiffJob> getTypeClass() {
            return SnapshotDiffJob.class;
        }

        @Override
        public byte[] toPersistedFormat(SnapshotDiffJob object) throws IOException {
            return MAPPER.writeValueAsBytes(object);
        }

        @Override
        public SnapshotDiffJob fromPersistedFormat(byte[] rawData) throws IOException {
            return MAPPER.readValue(rawData, SnapshotDiffJob.class);
        }

        @Override
        public SnapshotDiffJob copyObject(SnapshotDiffJob object) {
            return object;
        }
    }
}

