/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CopyObject;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.shaded.org.apache.commons.lang3.tuple.ImmutablePair;

public class RepeatedOmKeyInfo
implements CopyObject<RepeatedOmKeyInfo> {
    private static final Codec<RepeatedOmKeyInfo> CODEC_TRUE = RepeatedOmKeyInfo.newCodec(true);
    private static final Codec<RepeatedOmKeyInfo> CODEC_FALSE = RepeatedOmKeyInfo.newCodec(false);
    private final List<OmKeyInfo> omKeyInfoList;

    private static Codec<RepeatedOmKeyInfo> newCodec(boolean ignorePipeline) {
        return new DelegatedCodec<RepeatedOmKeyInfo, OzoneManagerProtocolProtos.RepeatedKeyInfo>(Proto2Codec.get(OzoneManagerProtocolProtos.RepeatedKeyInfo.getDefaultInstance()), RepeatedOmKeyInfo::getFromProto, k -> k.getProto(ignorePipeline, ClientVersion.CURRENT_VERSION), RepeatedOmKeyInfo.class);
    }

    public static Codec<RepeatedOmKeyInfo> getCodec(boolean ignorePipeline) {
        return ignorePipeline ? CODEC_TRUE : CODEC_FALSE;
    }

    public RepeatedOmKeyInfo() {
        this.omKeyInfoList = new ArrayList<OmKeyInfo>();
    }

    public RepeatedOmKeyInfo(List<OmKeyInfo> omKeyInfos) {
        this.omKeyInfoList = omKeyInfos;
    }

    public RepeatedOmKeyInfo(OmKeyInfo omKeyInfos) {
        this.omKeyInfoList = new ArrayList<OmKeyInfo>();
        this.omKeyInfoList.add(omKeyInfos);
    }

    public void addOmKeyInfo(OmKeyInfo info) {
        this.omKeyInfoList.add(info);
    }

    public List<OmKeyInfo> getOmKeyInfoList() {
        return this.omKeyInfoList;
    }

    public ImmutablePair<Long, Long> getTotalSize() {
        long replicatedSize = 0L;
        long unreplicatedSize = 0L;
        for (OmKeyInfo omKeyInfo : this.omKeyInfoList) {
            if (omKeyInfo.getReplicatedSize() != 0L) {
                replicatedSize += omKeyInfo.getReplicatedSize();
            }
            unreplicatedSize += omKeyInfo.getDataSize();
        }
        return new ImmutablePair<Long, Long>(unreplicatedSize, replicatedSize);
    }

    public List<OmKeyInfo> cloneOmKeyInfoList() {
        return new ArrayList<OmKeyInfo>(this.omKeyInfoList);
    }

    public static RepeatedOmKeyInfo getFromProto(OzoneManagerProtocolProtos.RepeatedKeyInfo repeatedKeyInfo) throws IOException {
        ArrayList<OmKeyInfo> list = new ArrayList<OmKeyInfo>();
        for (OzoneManagerProtocolProtos.KeyInfo k : repeatedKeyInfo.getKeyInfoList()) {
            list.add(OmKeyInfo.getFromProtobuf(k));
        }
        return new Builder().setOmKeyInfos(list).build();
    }

    public OzoneManagerProtocolProtos.RepeatedKeyInfo getProto(boolean compact, int clientVersion) {
        ArrayList<OzoneManagerProtocolProtos.KeyInfo> list = new ArrayList<OzoneManagerProtocolProtos.KeyInfo>();
        for (OmKeyInfo k : this.cloneOmKeyInfoList()) {
            list.add(k.getProtobuf(compact, clientVersion));
        }
        OzoneManagerProtocolProtos.RepeatedKeyInfo.Builder builder = OzoneManagerProtocolProtos.RepeatedKeyInfo.newBuilder().addAllKeyInfo(list);
        return builder.build();
    }

    public String toString() {
        return "RepeatedOmKeyInfo{omKeyInfoList=" + this.omKeyInfoList + '}';
    }

    @Override
    public RepeatedOmKeyInfo copyObject() {
        return new RepeatedOmKeyInfo(new ArrayList<OmKeyInfo>(this.omKeyInfoList));
    }

    public static class Builder {
        private List<OmKeyInfo> omKeyInfos;

        public Builder setOmKeyInfos(List<OmKeyInfo> infoList) {
            this.omKeyInfos = infoList;
            return this;
        }

        public RepeatedOmKeyInfo build() {
            return new RepeatedOmKeyInfo(this.omKeyInfos);
        }
    }
}

