/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.QuotaUtil;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.shaded.org.apache.commons.lang3.StringUtils;

public final class BasicOmKeyInfo {
    private final String volumeName;
    private final String bucketName;
    private final String keyName;
    private final long dataSize;
    private final long creationTime;
    private final long modificationTime;
    private final ReplicationConfig replicationConfig;
    private final boolean isFile;
    private final String eTag;
    private String ownerName;

    private BasicOmKeyInfo(Builder b) {
        this.volumeName = b.volumeName;
        this.bucketName = b.bucketName;
        this.keyName = b.keyName;
        this.dataSize = b.dataSize;
        this.creationTime = b.creationTime;
        this.modificationTime = b.modificationTime;
        this.replicationConfig = b.replicationConfig;
        this.isFile = b.isFile;
        this.eTag = StringUtils.isNotEmpty(b.eTag) ? b.eTag : null;
        this.ownerName = b.ownerName;
    }

    private BasicOmKeyInfo(OmKeyInfo b) {
        this.volumeName = b.getVolumeName();
        this.bucketName = b.getBucketName();
        this.keyName = b.getKeyName();
        this.dataSize = b.getDataSize();
        this.creationTime = b.getCreationTime();
        this.modificationTime = b.getModificationTime();
        this.replicationConfig = b.getReplicationConfig();
        this.isFile = b.isFile();
        this.eTag = b.getMetadata().get("ETag");
        this.ownerName = b.getOwnerName();
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public String getETag() {
        return this.eTag;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public long getReplicatedSize() {
        return QuotaUtil.getReplicatedSize(this.getDataSize(), this.replicationConfig);
    }

    public OzoneManagerProtocolProtos.BasicKeyInfo getProtobuf() {
        OzoneManagerProtocolProtos.BasicKeyInfo.Builder builder = OzoneManagerProtocolProtos.BasicKeyInfo.newBuilder().setKeyName(this.keyName).setDataSize(this.dataSize).setCreationTime(this.creationTime).setModificationTime(this.modificationTime).setType(this.replicationConfig.getReplicationType());
        if (this.ownerName != null) {
            builder.setOwnerName(this.ownerName);
        }
        if (this.replicationConfig instanceof ECReplicationConfig) {
            builder.setEcReplicationConfig(((ECReplicationConfig)this.replicationConfig).toProto());
        } else {
            builder.setFactor(ReplicationConfig.getLegacyFactor(this.replicationConfig));
        }
        if (StringUtils.isNotEmpty(this.eTag)) {
            builder.setETag(this.eTag);
        }
        return builder.build();
    }

    public static BasicOmKeyInfo getFromProtobuf(OzoneManagerProtocolProtos.BasicKeyInfo basicKeyInfo, OzoneManagerProtocolProtos.ListKeysRequest request) throws IOException {
        if (basicKeyInfo == null || request == null) {
            return null;
        }
        String keyName = basicKeyInfo.getKeyName();
        Builder builder = new Builder().setVolumeName(request.getVolumeName()).setBucketName(request.getBucketName()).setKeyName(keyName).setDataSize(basicKeyInfo.getDataSize()).setCreationTime(basicKeyInfo.getCreationTime()).setModificationTime(basicKeyInfo.getModificationTime()).setReplicationConfig(ReplicationConfig.fromProto(basicKeyInfo.getType(), basicKeyInfo.getFactor(), basicKeyInfo.getEcReplicationConfig())).setETag(basicKeyInfo.getETag()).setIsFile(!keyName.endsWith("/")).setOwnerName(basicKeyInfo.getOwnerName());
        return builder.build();
    }

    public static BasicOmKeyInfo getFromProtobuf(String volumeName, String bucketName, OzoneManagerProtocolProtos.BasicKeyInfo basicKeyInfo) throws IOException {
        if (basicKeyInfo == null) {
            return null;
        }
        String keyName = basicKeyInfo.getKeyName();
        Builder builder = new Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setDataSize(basicKeyInfo.getDataSize()).setCreationTime(basicKeyInfo.getCreationTime()).setModificationTime(basicKeyInfo.getModificationTime()).setReplicationConfig(ReplicationConfig.fromProto(basicKeyInfo.getType(), basicKeyInfo.getFactor(), basicKeyInfo.getEcReplicationConfig())).setETag(basicKeyInfo.getETag()).setIsFile(!keyName.endsWith("/")).setOwnerName(basicKeyInfo.getOwnerName());
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicOmKeyInfo basicOmKeyInfo = (BasicOmKeyInfo)o;
        return this.volumeName.equals(basicOmKeyInfo.volumeName) && this.bucketName.equals(basicOmKeyInfo.bucketName) && this.keyName.equals(basicOmKeyInfo.keyName) && this.dataSize == basicOmKeyInfo.dataSize && this.creationTime == basicOmKeyInfo.creationTime && this.modificationTime == basicOmKeyInfo.modificationTime && this.replicationConfig.equals(basicOmKeyInfo.replicationConfig) && Objects.equals(this.eTag, basicOmKeyInfo.eTag) && this.isFile == basicOmKeyInfo.isFile && this.ownerName.equals(basicOmKeyInfo.ownerName);
    }

    public int hashCode() {
        return Objects.hash(this.volumeName, this.bucketName, this.keyName);
    }

    public static BasicOmKeyInfo fromOmKeyInfo(OmKeyInfo omKeyInfo) {
        return new BasicOmKeyInfo(omKeyInfo);
    }

    public static class Builder {
        private String volumeName;
        private String bucketName;
        private String keyName;
        private long dataSize;
        private long creationTime;
        private long modificationTime;
        private ReplicationConfig replicationConfig;
        private boolean isFile;
        private String eTag;
        private String ownerName;

        public Builder setVolumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public Builder setBucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder setKeyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public Builder setDataSize(long dataSize) {
            this.dataSize = dataSize;
            return this;
        }

        public Builder setCreationTime(long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder setModificationTime(long modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public Builder setReplicationConfig(ReplicationConfig replicationConfig) {
            this.replicationConfig = replicationConfig;
            return this;
        }

        public Builder setIsFile(boolean isFile) {
            this.isFile = isFile;
            return this;
        }

        public Builder setETag(String etag) {
            this.eTag = etag;
            return this;
        }

        public Builder setOwnerName(String ownerName) {
            this.ownerName = ownerName;
            return this;
        }

        public BasicOmKeyInfo build() {
            return new BasicOmKeyInfo(this);
        }
    }
}

