/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ha;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.ha.ConfUtils;
import org.apache.hadoop.ozone.om.ha.OMFailoverProxyProviderBase;
import org.apache.hadoop.ozone.om.ha.OMProxyInfo;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopRpcOMFailoverProxyProvider<T>
extends OMFailoverProxyProviderBase<T> {
    public static final Logger LOG = LoggerFactory.getLogger(HadoopRpcOMFailoverProxyProvider.class);
    private final Text delegationTokenService = this.computeDelegationTokenService();
    private Map<String, OMProxyInfo> omProxyInfos;

    public HadoopRpcOMFailoverProxyProvider(ConfigurationSource configuration, UserGroupInformation ugi, String omServiceId, Class<T> protocol) throws IOException {
        super(configuration, ugi, omServiceId, protocol);
    }

    @Override
    protected void loadOMClientConfigs(ConfigurationSource config, String omSvcId) throws IOException {
        HashMap omProxies = new HashMap();
        this.omProxyInfos = new HashMap<String, OMProxyInfo>();
        ArrayList<String> omNodeIDList = new ArrayList<String>();
        HashMap<String, InetSocketAddress> omNodeAddressMap = new HashMap<String, InetSocketAddress>();
        Collection<String> omNodeIds = OmUtils.getActiveOMNodeIds(config, omSvcId);
        for (String nodeId : OmUtils.emptyAsSingletonNull(omNodeIds)) {
            String rpcAddrKey = ConfUtils.addKeySuffixes("ozone.om.address", omSvcId, nodeId);
            String rpcAddrStr = OmUtils.getOmRpcAddress(config, rpcAddrKey);
            if (rpcAddrStr == null) continue;
            OMProxyInfo omProxyInfo = new OMProxyInfo(omSvcId, nodeId, rpcAddrStr);
            if (omProxyInfo.getAddress() != null) {
                if (nodeId == null) {
                    nodeId = "om1";
                }
                omProxies.put(nodeId, null);
                this.omProxyInfos.put(nodeId, omProxyInfo);
                omNodeIDList.add(nodeId);
                omNodeAddressMap.put(nodeId, omProxyInfo.getAddress());
                continue;
            }
            LOG.error("Failed to create OM proxy for {} at address {}", (Object)nodeId, (Object)rpcAddrStr);
        }
        if (omProxies.isEmpty()) {
            throw new IllegalArgumentException("Could not find any configured addresses for OM. Please configure the system with ozone.om.address");
        }
        this.setOmProxies(omProxies);
        this.setOmNodeIDList(omNodeIDList);
        this.setOmNodeAddressMap(omNodeAddressMap);
    }

    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        FailoverProxyProvider.ProxyInfo currentProxyInfo = this.getOMProxyMap().get(this.getCurrentProxyOMNodeId());
        if (currentProxyInfo == null) {
            currentProxyInfo = this.createOMProxy(this.getCurrentProxyOMNodeId());
        }
        return currentProxyInfo;
    }

    protected FailoverProxyProvider.ProxyInfo createOMProxy(String nodeId) {
        FailoverProxyProvider.ProxyInfo proxyInfo;
        OMProxyInfo omProxyInfo = this.omProxyInfos.get(nodeId);
        InetSocketAddress address = omProxyInfo.getAddress();
        try {
            Object proxy = this.createOMProxy(address);
            proxyInfo = new FailoverProxyProvider.ProxyInfo(proxy, omProxyInfo.toString());
            this.getOMProxyMap().put(nodeId, proxyInfo);
        }
        catch (IOException ioe) {
            LOG.error("{} Failed to create RPC proxy to OM at {}", new Object[]{this.getClass().getSimpleName(), address, ioe});
            throw new RuntimeException(ioe);
        }
        return proxyInfo;
    }

    public Text getCurrentProxyDelegationToken() {
        return this.delegationTokenService;
    }

    protected Text computeDelegationTokenService() {
        ArrayList<String> addresses = new ArrayList<String>();
        for (Map.Entry<String, OMProxyInfo> omProxyInfoSet : this.omProxyInfos.entrySet()) {
            Text dtService = omProxyInfoSet.getValue().getDelegationTokenService();
            if (dtService == null) continue;
            addresses.add(dtService.toString());
        }
        if (!addresses.isEmpty()) {
            Collections.sort(addresses);
            return new Text(String.join((CharSequence)",", addresses));
        }
        return null;
    }

    @Override
    public synchronized void close() throws IOException {
        for (FailoverProxyProvider.ProxyInfo proxyInfo : this.getOMProxies()) {
            if (proxyInfo == null) continue;
            RPC.stopProxy((Object)proxyInfo.proxy);
        }
    }

    @VisibleForTesting
    public List<OMProxyInfo> getOMProxyInfos() {
        return new ArrayList<OMProxyInfo>(this.omProxyInfos.values());
    }

    @VisibleForTesting
    public Map<String, OMProxyInfo> getOMProxyInfoMap() {
        return this.omProxyInfos;
    }

    @VisibleForTesting
    protected void setProxiesForTesting(Map<String, FailoverProxyProvider.ProxyInfo<T>> setOMProxies, Map<String, OMProxyInfo> setOMProxyInfos, List<String> setOMNodeIDList, Map<String, InetSocketAddress> setOMNodeAddress) {
        this.setOmProxies(setOMProxies);
        this.omProxyInfos = setOMProxyInfos;
        this.setOmNodeIDList(setOMNodeIDList);
        this.setOmNodeAddressMap(setOMNodeAddress);
    }
}

