/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.BlockOutputStream;
import org.apache.hadoop.hdds.scm.storage.ECBlockOutputStream;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.ozone.client.io.BlockOutputStreamEntry;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.com.google.common.collect.ImmutableList;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECBlockOutputStreamEntry
extends BlockOutputStreamEntry {
    private static final Logger LOG = LoggerFactory.getLogger(ECBlockOutputStreamEntry.class);
    private final ECReplicationConfig replicationConfig;
    private final long length;
    private ECBlockOutputStream[] blockOutputStreams;
    private int currentStreamIdx = 0;
    private long successfulBlkGrpAckedLen;

    ECBlockOutputStreamEntry(Builder b) {
        super(b);
        this.replicationConfig = Preconditions.assertInstanceOf(b.getPipeline().getReplicationConfig(), ECReplicationConfig.class);
        this.length = (long)this.replicationConfig.getData() * b.getLength();
    }

    @Override
    void checkStream() throws IOException {
        if (!this.isInitialized()) {
            ECBlockOutputStream[] streams = new ECBlockOutputStream[this.replicationConfig.getRequiredNodes()];
            for (int i = this.currentStreamIdx; i < this.replicationConfig.getRequiredNodes(); ++i) {
                List<DatanodeDetails> nodes = this.getPipeline().getNodes();
                streams[i] = new ECBlockOutputStream(this.getBlockID(), this.getXceiverClientManager(), this.createSingleECBlockPipeline(this.getPipeline(), nodes.get(i), i + 1), this.getBufferPool(), this.getConf(), this.getToken(), this.getClientMetrics(), this.getStreamBufferArgs(), this.getExecutorServiceSupplier());
            }
            this.blockOutputStreams = streams;
        }
    }

    @Override
    void cleanup(boolean invalidateClient) {
        if (this.isInitialized()) {
            IOUtils.close(LOG, this.blockOutputStreams);
            this.blockOutputStreams = null;
        }
    }

    @Override
    public OutputStream getOutputStream() {
        if (!this.isInitialized()) {
            return null;
        }
        org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions.checkState(this.blockOutputStreams[this.currentStreamIdx] != null);
        return this.blockOutputStreams[this.currentStreamIdx];
    }

    @Override
    boolean isInitialized() {
        return this.blockOutputStreams != null;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    public int getCurrentStreamIdx() {
        return this.currentStreamIdx;
    }

    public void useNextBlockStream() {
        this.currentStreamIdx = (this.currentStreamIdx + 1) % this.replicationConfig.getRequiredNodes();
    }

    public void markFailed(Exception e) {
        if (this.isInitialized() && this.blockOutputStreams[this.currentStreamIdx] != null) {
            this.blockOutputStreams[this.currentStreamIdx].setIoException(e);
        }
    }

    public void forceToFirstParityBlock() {
        this.currentStreamIdx = this.replicationConfig.getData();
    }

    public void resetToFirstEntry() {
        this.currentStreamIdx = 0;
    }

    @Override
    void incCurrentPosition() {
        if (this.isWritingParity()) {
            return;
        }
        super.incCurrentPosition();
    }

    @Override
    void incCurrentPosition(long len) {
        if (this.isWritingParity()) {
            return;
        }
        super.incCurrentPosition(len);
    }

    @Override
    public void flush() throws IOException {
        if (!this.isInitialized()) {
            return;
        }
        for (int i = 0; i <= this.currentStreamIdx && i < this.blockOutputStreams.length; ++i) {
            if (this.blockOutputStreams[i] == null) continue;
            this.blockOutputStreams[i].flush();
        }
    }

    @Override
    boolean isClosed() {
        if (!this.isInitialized()) {
            return false;
        }
        return this.blockStreams().allMatch(BlockOutputStream::isClosed);
    }

    @Override
    public void close() throws IOException {
        if (!this.isInitialized()) {
            return;
        }
        for (ECBlockOutputStream stream : this.blockOutputStreams) {
            if (stream == null) continue;
            stream.close();
        }
        this.updateBlockID(this.underlyingBlockID());
    }

    @Override
    long getTotalAckDataLength() {
        if (!this.isInitialized()) {
            return 0L;
        }
        this.updateBlockID(this.underlyingBlockID());
        return this.successfulBlkGrpAckedLen;
    }

    void updateBlockGroupToAckedPosition(long len) {
        if (this.isWritingParity()) {
            return;
        }
        this.successfulBlkGrpAckedLen = len;
    }

    @Override
    long getWrittenDataLength() {
        if (!this.isInitialized()) {
            return 0L;
        }
        return this.dataStreams().mapToLong(BlockOutputStream::getWrittenDataLength).sum();
    }

    @Override
    Collection<DatanodeDetails> getFailedServers() {
        if (!this.isInitialized()) {
            return Collections.emptyList();
        }
        return this.blockStreams().flatMap(outputStream2 -> outputStream2.getFailedServers().stream()).collect(Collectors.toList());
    }

    @VisibleForTesting
    Pipeline createSingleECBlockPipeline(Pipeline ecPipeline, DatanodeDetails node, int replicaIndex) {
        Map<DatanodeDetails, Integer> indiciesForSinglePipeline = Collections.singletonMap(node, replicaIndex);
        return Pipeline.newBuilder().setId(ecPipeline.getId()).setReplicationConfig(ecPipeline.getReplicationConfig()).setState(ecPipeline.getPipelineState()).setNodes(ImmutableList.of(node)).setReplicaIndexes(indiciesForSinglePipeline).build();
    }

    void executePutBlock(boolean isClose, long blockGroupLength, ByteString checksum) {
        if (!this.isInitialized()) {
            return;
        }
        for (ECBlockOutputStream stream : this.blockOutputStreams) {
            if (stream == null) continue;
            try {
                stream.executePutBlock(isClose, true, blockGroupLength, checksum);
            }
            catch (Exception e) {
                stream.setIoException(e);
            }
        }
    }

    private BlockID underlyingBlockID() {
        if (this.blockOutputStreams[0] == null) {
            return null;
        }
        return this.blockOutputStreams[0].getBlockID();
    }

    public List<ECBlockOutputStream> streamsWithWriteFailure() {
        return this.getFailedStreams(false);
    }

    public List<ECBlockOutputStream> streamsWithPutBlockFailure() {
        return this.getFailedStreams(true);
    }

    private List<ECBlockOutputStream> getFailedStreams(boolean forPutBlock) {
        Iterator iter = this.blockStreams().iterator();
        ArrayList<ECBlockOutputStream> failedStreams = new ArrayList<ECBlockOutputStream>();
        while (iter.hasNext()) {
            ECBlockOutputStream stream = (ECBlockOutputStream)iter.next();
            if (!forPutBlock && stream.getWrittenDataLength() <= 0L) continue;
            CompletableFuture<ContainerProtos.ContainerCommandResponseProto> responseFuture = null;
            responseFuture = forPutBlock ? stream.getCurrentPutBlkResponseFuture() : stream.getCurrentChunkResponseFuture();
            if (!this.isFailed(stream, responseFuture)) continue;
            failedStreams.add(stream);
        }
        return failedStreams;
    }

    private boolean isFailed(ECBlockOutputStream outputStream2, CompletableFuture<ContainerProtos.ContainerCommandResponseProto> chunkWriteResponseFuture) {
        if (chunkWriteResponseFuture == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to reap response from datanode {}", (Object)outputStream2.getDatanodeDetails());
            }
            return true;
        }
        ContainerProtos.ContainerCommandResponseProto containerCommandResponseProto = null;
        try {
            containerCommandResponseProto = chunkWriteResponseFuture.get();
        }
        catch (InterruptedException e) {
            outputStream2.setIoException(e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            outputStream2.setIoException(e);
        }
        if (outputStream2.getIoException() != null) {
            return true;
        }
        if (containerCommandResponseProto == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Empty response from datanode {}", (Object)outputStream2.getDatanodeDetails());
            }
            return true;
        }
        return false;
    }

    private boolean isWritingParity() {
        return this.currentStreamIdx >= this.replicationConfig.getData();
    }

    private Stream<ECBlockOutputStream> blockStreams() {
        return this.isInitialized() ? Arrays.stream(this.blockOutputStreams).filter(Objects::nonNull) : Stream.empty();
    }

    private Stream<ECBlockOutputStream> dataStreams() {
        return this.isInitialized() ? Arrays.stream(this.blockOutputStreams).limit(this.replicationConfig.getData()).filter(Objects::nonNull) : Stream.empty();
    }

    public ByteString calculateChecksum() throws IOException {
        if (this.blockOutputStreams == null) {
            throw new IOException("Block Output Stream is null");
        }
        ArrayList<ContainerProtos.ChunkInfo> chunkInfos = new ArrayList<ContainerProtos.ChunkInfo>();
        int currentIdx = this.blockOutputStreams[0].getContainerBlockData().getChunksCount();
        for (ECBlockOutputStream stream : this.blockOutputStreams) {
            if (stream.getContainerBlockData().getChunksCount() <= currentIdx - 1) continue;
            chunkInfos.add(stream.getContainerBlockData().getChunksList().get(currentIdx - 1));
        }
        ByteString checksum = ByteString.EMPTY;
        for (ContainerProtos.ChunkInfo info : chunkInfos) {
            for (ByteString byteString : info.getChecksumData().getChecksumsList()) {
                checksum = checksum.concat(byteString);
            }
        }
        return checksum;
    }

    public static class Builder
    extends BlockOutputStreamEntry.Builder {
        @Override
        public ECBlockOutputStreamEntry build() {
            return new ECBlockOutputStreamEntry(this);
        }
    }
}

