/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.http.ParseException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class OFSPath {
    private String authority = "";
    private String volumeName = "";
    private String bucketName = "";
    private String mountName = "";
    private String keyName = "";
    private OzoneConfiguration conf;
    private static final String OFS_MOUNT_NAME_TMP = "tmp";
    @VisibleForTesting
    public static final String OFS_MOUNT_TMP_VOLUMENAME = "tmp";
    private static final String OFS_SHARED_TMP_BUCKETNAME = "tmp";

    public OFSPath(Path path, OzoneConfiguration conf) {
        this.conf = conf;
        this.initOFSPath(path.toUri(), false);
    }

    public OFSPath(String pathStr, OzoneConfiguration conf) {
        this.conf = conf;
        if (StringUtils.isEmpty(pathStr)) {
            return;
        }
        Path fsPath = new Path(pathStr);
        boolean endsWithSlash = pathStr.endsWith("/");
        this.initOFSPath(fsPath.toUri(), endsWithSlash);
    }

    public static boolean isSharedTmpBucket(OzoneObjInfo objInfo) {
        return "tmp".equals(objInfo.getVolumeName()) && "tmp".equals(objInfo.getBucketName());
    }

    private void initOFSPath(URI uri, boolean endsWithSlash) {
        String scheme = uri.getScheme();
        if (scheme != null && !scheme.equalsIgnoreCase("ofs")) {
            throw new ParseException("Can't parse schemes other than ofs.");
        }
        this.authority = uri.getAuthority() == null ? "" : uri.getAuthority();
        String pathStr = uri.getPath();
        StringTokenizer token = new StringTokenizer(pathStr, "/");
        int numToken = token.countTokens();
        if (numToken > 0) {
            String firstToken = token.nextToken();
            if (firstToken.equals("tmp")) {
                this.mountName = firstToken;
                this.volumeName = "tmp";
                try {
                    if (this.conf.getBoolean("ozone.om.enable.ofs.shared.tmp.dir", false)) {
                        this.bucketName = "tmp";
                    }
                    this.bucketName = OFSPath.getTempMountBucketNameOfCurrentUser();
                }
                catch (IOException ex) {
                    throw new ParseException("Failed to get temp bucket name for current user.");
                }
            } else if (numToken >= 2) {
                this.volumeName = firstToken;
                this.bucketName = token.nextToken();
            } else {
                this.volumeName = firstToken;
            }
        }
        if (token.hasMoreTokens()) {
            this.keyName = token.nextToken("").substring(1);
            if (endsWithSlash) {
                this.keyName = this.keyName + "/";
            }
        }
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getMountName() {
        return this.mountName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    private boolean isEmpty() {
        return this.getAuthority().isEmpty() && this.getMountName().isEmpty() && this.getVolumeName().isEmpty() && this.getBucketName().isEmpty() && this.getKeyName().isEmpty();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        Preconditions.checkNotNull(this.authority);
        StringBuilder sb = new StringBuilder();
        if (!this.isMount()) {
            sb.append(this.volumeName);
            sb.append("/");
            if (!this.bucketName.isEmpty()) {
                sb.append(this.bucketName);
                sb.append("/");
            }
        } else {
            sb.append(this.mountName);
            sb.append("/");
        }
        if (!this.keyName.isEmpty()) {
            sb.append(this.keyName);
        }
        if (this.authority.isEmpty()) {
            sb.insert(0, "/");
            return sb.toString();
        }
        Path pathWithSchemeAuthority = new Path("ofs", this.authority, "/");
        sb.insert(0, pathWithSchemeAuthority.toString());
        return sb.toString();
    }

    public String getNonKeyPath() {
        if (this.isEmpty()) {
            return "";
        }
        return "/" + this.getNonKeyPathNoPrefixDelim();
    }

    public String getNonKeyPathNoPrefixDelim() {
        if (this.isEmpty()) {
            return "";
        }
        if (this.isMount()) {
            return this.mountName;
        }
        return this.volumeName + "/" + this.bucketName;
    }

    public boolean isMount() {
        return !this.mountName.isEmpty();
    }

    private static boolean isInSameBucketAsInternal(OFSPath p1, OFSPath p2) {
        return p1.getVolumeName().equals(p2.getVolumeName()) && p1.getBucketName().equals(p2.getBucketName());
    }

    public boolean isInSameBucketAs(OFSPath p2) {
        return OFSPath.isInSameBucketAsInternal(this, p2);
    }

    public boolean isRoot() {
        return this.getVolumeName().isEmpty() && this.getBucketName().isEmpty();
    }

    public boolean isVolume() {
        return this.getBucketName().isEmpty() && !this.getVolumeName().isEmpty();
    }

    public boolean isBucket() {
        return this.getKeyName().isEmpty() && !this.getBucketName().isEmpty() && !this.getVolumeName().isEmpty();
    }

    public boolean isSnapshotPath() {
        String[] keyNames;
        if (this.keyName.startsWith(".snapshot") && (keyNames = this.keyName.split("/")).length == 1) {
            return !this.bucketName.isEmpty() && !this.volumeName.isEmpty();
        }
        return false;
    }

    public String getSnapshotName() {
        if (this.keyName.startsWith(".snapshot") && !this.bucketName.isEmpty() && !this.volumeName.isEmpty()) {
            String[] keyNames = this.keyName.split("/");
            return keyNames.length > 1 ? keyNames[1] : null;
        }
        return null;
    }

    public boolean isKey() {
        return !this.getKeyName().isEmpty();
    }

    private static String md5Hex(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(input.getBytes(StandardCharsets.UTF_8));
            BigInteger bigInt = new BigInteger(1, digest);
            StringBuilder sb = new StringBuilder(bigInt.toString(16));
            while (sb.length() < 32) {
                sb.insert(0, "0");
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    @VisibleForTesting
    static String getTempMountBucketName(String username) {
        Preconditions.checkNotNull(username);
        return OFSPath.md5Hex(username);
    }

    public static String getTempMountBucketNameOfCurrentUser() throws IOException {
        String username = UserGroupInformation.getCurrentUser().getShortUserName();
        return OFSPath.getTempMountBucketName(username);
    }

    public Path getTrashRoot() {
        if (!this.isKey()) {
            throw new RuntimeException("Recursive rm of volume or bucket with trash enabled is not permitted. Consider using the -skipTrash option.");
        }
        try {
            String username = UserGroupInformation.getCurrentUser().getShortUserName();
            Path pathRoot = new Path("ofs", this.authority, "/");
            Path pathToVolume = new Path(pathRoot, this.volumeName);
            Path pathToBucket = new Path(pathToVolume, this.bucketName);
            Path pathToTrash = new Path(pathToBucket, ".Trash");
            return new Path(pathToTrash, username);
        }
        catch (IOException ex) {
            throw new RuntimeException("getTrashRoot failed.", ex);
        }
    }
}

