/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.io;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer.asReadOnlyBuffer();
    }

    @Override
    public int read() throws IOException {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(@Nonnull byte[] array, int offset, int length) throws IOException {
        ByteBufferInputStream.assertArrayIndex(array, offset, length);
        if (length == 0) {
            return 0;
        }
        int remaining = this.buffer.remaining();
        if (remaining <= 0) {
            return -1;
        }
        int min2 = Math.min(remaining, length);
        this.buffer.get(array, offset, min2);
        return min2;
    }

    static void assertArrayIndex(@Nonnull byte[] array, int offset, int length) {
        Objects.requireNonNull(array, "array == null");
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("offset = " + offset + " < 0");
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException("length = " + length + " < 0");
        }
        int end = offset + length;
        if (end < 0) {
            throw new ArrayIndexOutOfBoundsException("Overflow: offset+length > Integer.MAX_VALUE, offset=" + offset + ", length=" + length);
        }
        if (end > array.length) {
            throw new ArrayIndexOutOfBoundsException("offset+length > array.length = " + array.length + ", offset=" + offset + ", length=" + length);
        }
    }
}

