/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.XceiverClientGrpc;
import org.apache.hadoop.hdds.scm.client.ClientTrustManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.ratis.thirdparty.io.grpc.Status;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyChannelBuilder;

public class ECXceiverClientGrpc
extends XceiverClientGrpc {
    private final boolean enableRetries;

    public ECXceiverClientGrpc(Pipeline pipeline, ConfigurationSource config, ClientTrustManager trustManager) {
        super(pipeline, config, trustManager);
        this.enableRetries = config.getBoolean("ozone.client.ec.grpc.retries.enabled", true);
        this.setTimeout(config.getTimeDuration("ozone.client.ec.grpc.write.timeout", "30s", TimeUnit.SECONDS));
    }

    @Override
    protected boolean shouldBlockAndWaitAsyncReply(ContainerProtos.ContainerCommandRequestProto request) {
        return false;
    }

    @Override
    protected NettyChannelBuilder createChannel(DatanodeDetails dn, int port) throws IOException {
        NettyChannelBuilder channelBuilder = super.createChannel(dn, port);
        if (this.enableRetries) {
            double maxAttempts = this.getConfig().getInt("ozone.client.ec.grpc.retries.max", 3);
            ((NettyChannelBuilder)((NettyChannelBuilder)channelBuilder.defaultServiceConfig((Map)this.createRetryServiceConfig(maxAttempts))).maxRetryAttempts((int)maxAttempts)).enableRetry();
        }
        return channelBuilder;
    }

    private Map<String, Object> createRetryServiceConfig(double maxAttempts) {
        HashMap<String, Object> retryPolicy = new HashMap<String, Object>();
        retryPolicy.put("maxAttempts", maxAttempts);
        retryPolicy.put("initialBackoff", "0.5s");
        retryPolicy.put("maxBackoff", "3s");
        retryPolicy.put("backoffMultiplier", 1.5);
        retryPolicy.put("retryableStatusCodes", Collections.singletonList(Status.Code.DEADLINE_EXCEEDED.name()));
        HashMap<String, Object> methodConfig = new HashMap<String, Object>();
        methodConfig.put("retryPolicy", retryPolicy);
        HashMap<String, String> name = new HashMap<String, String>();
        name.put("service", "hadoop.hdds.datanode.XceiverClientProtocolService");
        methodConfig.put("name", Collections.singletonList(name));
        HashMap<String, Object> serviceConfig = new HashMap<String, Object>();
        serviceConfig.put("methodConfig", Collections.singletonList(methodConfig));
        return serviceConfig;
    }
}

