/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Strings;
import org.apache.ratis.util.Preconditions;

public final class OzoneQuota {
    private static final List<Units> PARSE_ORDER;
    private static final RawQuotaInBytes ZERO_BYTES;
    private long quotaInNamespace;
    private final long quotaInBytes;
    private final RawQuotaInBytes rawQuotaInBytes;

    public long getRawSize() {
        return this.rawQuotaInBytes.getSize();
    }

    public Units getUnit() {
        return this.rawQuotaInBytes.getUnit();
    }

    private OzoneQuota(RawQuotaInBytes rawQuotaInBytes) {
        this.rawQuotaInBytes = rawQuotaInBytes;
        this.quotaInBytes = rawQuotaInBytes.sizeInBytes();
    }

    private OzoneQuota(long quotaInNamespace, RawQuotaInBytes rawQuotaInBytes) {
        this.quotaInNamespace = quotaInNamespace;
        this.rawQuotaInBytes = rawQuotaInBytes;
        this.quotaInBytes = rawQuotaInBytes.sizeInBytes();
    }

    public static OzoneQuota parseSpaceQuota(String quotaInBytes) {
        long nSize;
        if (Strings.isNullOrEmpty(quotaInBytes)) {
            throw new IllegalArgumentException("Quota string cannot be null or empty.");
        }
        String uppercase = quotaInBytes.toUpperCase().replaceAll("\\s+", "");
        String size = "";
        Units currUnit = Units.B;
        try {
            for (Units unit : PARSE_ORDER) {
                String quota = unit.name();
                if (!uppercase.endsWith(quota)) continue;
                size = uppercase.substring(0, uppercase.length() - quota.length());
                currUnit = unit;
                break;
            }
            if (size.isEmpty()) {
                size = uppercase;
            }
            nSize = Long.parseLong(size);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(quotaInBytes + " is invalid. The quota value should be a positive integer with byte numeration(B, KB, MB, GB and TB)");
        }
        if (nSize <= 0L) {
            throw new IllegalArgumentException("Invalid value for space quota: " + nSize);
        }
        return new OzoneQuota(new RawQuotaInBytes(currUnit, nSize));
    }

    public static OzoneQuota parseNameSpaceQuota(String quotaInNamespace) {
        if (Strings.isNullOrEmpty(quotaInNamespace)) {
            throw new IllegalArgumentException("Quota string cannot be null or empty.");
        }
        try {
            long nameSpaceQuota = Long.parseLong(quotaInNamespace);
            if (nameSpaceQuota <= 0L) {
                throw new IllegalArgumentException("Invalid value for namespace quota: " + nameSpaceQuota);
            }
            return new OzoneQuota(nameSpaceQuota, new RawQuotaInBytes(Units.B, -1L));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(quotaInNamespace + " is invalid. The quota value should be a positive integer");
        }
    }

    public static OzoneQuota parseQuota(String quotaInBytes, String quotaInNamespace) {
        return new OzoneQuota(OzoneQuota.parseNameSpaceQuota((String)quotaInNamespace).quotaInNamespace, OzoneQuota.parseSpaceQuota((String)quotaInBytes).rawQuotaInBytes);
    }

    public static OzoneQuota getOzoneQuota(long quotaInBytes, long quotaInNamespace) {
        return new OzoneQuota(quotaInNamespace, RawQuotaInBytes.valueOf(quotaInBytes));
    }

    public long getQuotaInNamespace() {
        return this.quotaInNamespace;
    }

    public long getQuotaInBytes() {
        return this.quotaInBytes;
    }

    public String toString() {
        return "Space Bytes Quota: " + this.rawQuotaInBytes.toString() + "\nCounts Quota: " + this.quotaInNamespace;
    }

    static {
        ArrayList<Units> reversed = new ArrayList<Units>(Arrays.asList(Units.values()));
        Collections.reverse(reversed);
        PARSE_ORDER = Collections.unmodifiableList(reversed);
        ZERO_BYTES = new RawQuotaInBytes(Units.B, 0L);
    }

    private static class RawQuotaInBytes {
        private final Units unit;
        private final long size;

        static RawQuotaInBytes valueOf(long quotaInBytes) {
            Preconditions.assertTrue(quotaInBytes >= 0L, () -> "quotaInBytes = " + quotaInBytes + " must be >= 0");
            if (quotaInBytes == 0L) {
                return ZERO_BYTES;
            }
            int i = Long.numberOfTrailingZeros(quotaInBytes) / 10;
            Units unit = Units.values()[i];
            RawQuotaInBytes b = unit.getRawQuotaInBytes(quotaInBytes >> i * 10);
            Preconditions.assertSame(quotaInBytes, b.sizeInBytes(), "sizeInBytes");
            return b;
        }

        RawQuotaInBytes(Units unit, long size) {
            this.unit = unit;
            this.size = size;
        }

        public Units getUnit() {
            return this.unit;
        }

        public long getSize() {
            return this.size;
        }

        public long sizeInBytes() {
            return this.getSize() * this.getUnit().getSize();
        }

        public String toString() {
            return this.size + " " + (Object)((Object)this.unit);
        }
    }

    public static enum Units {
        B(1L),
        KB(1024L),
        MB(0x100000L),
        GB(0x40000000L),
        TB(0x10000000000L),
        PB(0x4000000000000L),
        EB(0x1000000000000000L);

        private final long size;
        private final List<RawQuotaInBytes> cache;

        private Units(long size) {
            this.size = size;
            this.cache = Units.createCache(this);
        }

        private static List<RawQuotaInBytes> createCache(Units unit) {
            ArrayList<RawQuotaInBytes> quotas = new ArrayList<RawQuotaInBytes>(1024);
            for (int i = 0; i < 1024; ++i) {
                quotas.add(new RawQuotaInBytes(unit, i));
            }
            return Collections.unmodifiableList(quotas);
        }

        public long getSize() {
            return this.size;
        }

        RawQuotaInBytes getRawQuotaInBytes(long b) {
            return b < (long)this.cache.size() ? this.cache.get(Math.toIntExact(b)) : new RawQuotaInBytes(this, b);
        }
    }
}

