/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security.acl;

import java.net.InetAddress;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.security.UserGroupInformation;

public class RequestContext {
    private final String host;
    private final InetAddress ip;
    private final UserGroupInformation clientUgi;
    private final String serviceId;
    private final IAccessAuthorizer.ACLIdentityType aclType;
    private final IAccessAuthorizer.ACLType aclRights;
    private final String ownerName;
    private final boolean recursiveAccessCheck;
    private final String sessionPolicy;

    public RequestContext(String host, InetAddress ip, UserGroupInformation clientUgi, String serviceId, IAccessAuthorizer.ACLIdentityType aclType, IAccessAuthorizer.ACLType aclRights, String ownerName) {
        this(host, ip, clientUgi, serviceId, aclType, aclRights, ownerName, false, null);
    }

    public RequestContext(String host, InetAddress ip, UserGroupInformation clientUgi, String serviceId, IAccessAuthorizer.ACLIdentityType aclType, IAccessAuthorizer.ACLType aclRights, String ownerName, boolean recursiveAccessCheck) {
        this(host, ip, clientUgi, serviceId, aclType, aclRights, ownerName, recursiveAccessCheck, null);
    }

    public RequestContext(String host, InetAddress ip, UserGroupInformation clientUgi, String serviceId, IAccessAuthorizer.ACLIdentityType aclType, IAccessAuthorizer.ACLType aclRights, String ownerName, boolean recursiveAccessCheck, String sessionPolicy) {
        this.host = host;
        this.ip = ip;
        this.clientUgi = clientUgi;
        this.serviceId = serviceId;
        this.aclType = aclType;
        this.aclRights = aclRights;
        this.ownerName = ownerName;
        this.recursiveAccessCheck = recursiveAccessCheck;
        this.sessionPolicy = sessionPolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder getBuilder(UserGroupInformation ugi, InetAddress remoteAddress, String hostName, IAccessAuthorizer.ACLType aclType, String ownerName) {
        return RequestContext.getBuilder(ugi, remoteAddress, hostName, aclType, ownerName, false);
    }

    public static Builder getBuilder(UserGroupInformation ugi, InetAddress remoteAddress, String hostName, IAccessAuthorizer.ACLType aclType, String ownerName, boolean recursiveAccessCheck) {
        return RequestContext.getBuilder(ugi, remoteAddress, hostName, aclType, ownerName, recursiveAccessCheck, null);
    }

    public static Builder getBuilder(UserGroupInformation ugi, InetAddress remoteAddress, String hostName, IAccessAuthorizer.ACLType aclType, String ownerName, boolean recursiveAccessCheck, String sessionPolicy) {
        return RequestContext.newBuilder().setClientUgi(ugi).setIp(remoteAddress).setHost(hostName).setAclType(IAccessAuthorizer.ACLIdentityType.USER).setAclRights(aclType).setOwnerName(ownerName).setRecursiveAccessCheck(recursiveAccessCheck).setSessionPolicy(sessionPolicy);
    }

    public static Builder getBuilder(UserGroupInformation ugi, IAccessAuthorizer.ACLType aclType, String ownerName) {
        return RequestContext.getBuilder(ugi, ProtobufRpcEngine.Server.getRemoteIp(), ProtobufRpcEngine.Server.getRemoteIp().getHostName(), aclType, ownerName);
    }

    public String getHost() {
        return this.host;
    }

    public InetAddress getIp() {
        return this.ip;
    }

    public UserGroupInformation getClientUgi() {
        return this.clientUgi;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public IAccessAuthorizer.ACLIdentityType getAclType() {
        return this.aclType;
    }

    public IAccessAuthorizer.ACLType getAclRights() {
        return this.aclRights;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public boolean isRecursiveAccessCheck() {
        return this.recursiveAccessCheck;
    }

    public String getSessionPolicy() {
        return this.sessionPolicy;
    }

    public static class Builder {
        private String host;
        private InetAddress ip;
        private UserGroupInformation clientUgi;
        private String serviceId;
        private IAccessAuthorizer.ACLIdentityType aclType;
        private IAccessAuthorizer.ACLType aclRights;
        private String ownerName;
        private boolean recursiveAccessCheck;
        private String sessionPolicy;

        public Builder setHost(String bHost) {
            this.host = bHost;
            return this;
        }

        public Builder setIp(InetAddress cIp) {
            this.ip = cIp;
            return this;
        }

        public Builder setClientUgi(UserGroupInformation cUgi) {
            this.clientUgi = cUgi;
            return this;
        }

        public Builder setServiceId(String sId) {
            this.serviceId = sId;
            return this;
        }

        public Builder setAclType(IAccessAuthorizer.ACLIdentityType acl) {
            this.aclType = acl;
            return this;
        }

        public IAccessAuthorizer.ACLType getAclRights() {
            return this.aclRights;
        }

        public Builder setAclRights(IAccessAuthorizer.ACLType aclRight) {
            this.aclRights = aclRight;
            return this;
        }

        public Builder setOwnerName(String owner) {
            this.ownerName = owner;
            return this;
        }

        public Builder setRecursiveAccessCheck(boolean recursiveAccessCheckFlag) {
            this.recursiveAccessCheck = recursiveAccessCheckFlag;
            return this;
        }

        public Builder setSessionPolicy(String sessionPolicy) {
            this.sessionPolicy = sessionPolicy;
            return this;
        }

        public RequestContext build() {
            return new RequestContext(this.host, this.ip, this.clientUgi, this.serviceId, this.aclType, this.aclRights, this.ownerName, this.recursiveAccessCheck, this.sessionPolicy);
        }
    }
}

