/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.protobuf.MessageLite;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CopyObject;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.WithParentObjectId;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OmDirectoryInfo
extends WithParentObjectId
implements CopyObject<OmDirectoryInfo> {
    private static final Codec<OmDirectoryInfo> CODEC = new DelegatedCodec(Proto2Codec.get((MessageLite)OzoneManagerProtocolProtos.DirectoryInfo.getDefaultInstance()), OmDirectoryInfo::getFromProtobuf, OmDirectoryInfo::getProtobuf, OmDirectoryInfo.class);
    private final String name;
    private String owner;
    private final long creationTime;
    private final long modificationTime;
    private final List<OzoneAcl> acls;

    public OmDirectoryInfo(Builder builder) {
        super(builder);
        this.name = builder.name;
        this.owner = builder.owner;
        this.acls = builder.acls;
        this.creationTime = builder.creationTime;
        this.modificationTime = builder.modificationTime;
    }

    public static Codec<OmDirectoryInfo> getCodec() {
        return CODEC;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return this.getPath() + ":" + this.getObjectID();
    }

    public String getPath() {
        return this.getParentObjectID() + "/" + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public OzoneManagerProtocolProtos.DirectoryInfo getProtobuf() {
        OzoneManagerProtocolProtos.DirectoryInfo.Builder pib = OzoneManagerProtocolProtos.DirectoryInfo.newBuilder().setName(this.name).setCreationTime(this.creationTime).setModificationTime(this.modificationTime).addAllMetadata(KeyValueUtil.toProtobuf(this.getMetadata())).setObjectID(this.getObjectID()).setUpdateID(this.getUpdateID()).setParentID(this.getParentObjectID());
        if (this.owner != null) {
            pib.setOwnerName(this.owner);
        }
        if (this.acls != null) {
            pib.addAllAcls(OzoneAclUtil.toProtobuf(this.acls));
        }
        return pib.build();
    }

    public static OmDirectoryInfo getFromProtobuf(OzoneManagerProtocolProtos.DirectoryInfo dirInfo) {
        Builder opib = OmDirectoryInfo.newBuilder().setName(dirInfo.getName()).setCreationTime(dirInfo.getCreationTime()).setModificationTime(dirInfo.getModificationTime()).setAcls(OzoneAclUtil.fromProtobuf(dirInfo.getAclsList()));
        if (dirInfo.getMetadataList() != null) {
            opib.addAllMetadata((Map)KeyValueUtil.getFromProtobuf(dirInfo.getMetadataList()));
        }
        if (dirInfo.hasObjectID()) {
            opib.setObjectID(dirInfo.getObjectID());
        }
        if (dirInfo.hasParentID()) {
            opib.setParentObjectID(dirInfo.getParentID());
        }
        if (dirInfo.hasUpdateID()) {
            opib.setUpdateID(dirInfo.getUpdateID());
        }
        if (dirInfo.hasOwnerName()) {
            opib.setOwner(dirInfo.getOwnerName());
        }
        return opib.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OmDirectoryInfo omDirInfo = (OmDirectoryInfo)o;
        return this.creationTime == omDirInfo.creationTime && this.modificationTime == omDirInfo.modificationTime && this.name.equals(omDirInfo.name) && Objects.equals(this.owner, omDirInfo.owner) && Objects.equals(this.getMetadata(), omDirInfo.getMetadata()) && Objects.equals(this.acls, omDirInfo.acls) && this.getObjectID() == omDirInfo.getObjectID() && this.getUpdateID() == omDirInfo.getUpdateID() && this.getParentObjectID() == omDirInfo.getParentObjectID();
    }

    public int hashCode() {
        return Objects.hash(this.getObjectID(), this.getParentObjectID(), this.name);
    }

    public OmDirectoryInfo copyObject() {
        Builder builder = new Builder().setName(this.name).setOwner(this.owner).setCreationTime(this.creationTime).setModificationTime(this.modificationTime).setAcls(this.acls).setParentObjectID(this.getParentObjectID()).setObjectID(this.getObjectID()).setUpdateID(this.getUpdateID());
        if (this.getMetadata() != null) {
            builder.addAllMetadata((Map)this.getMetadata());
        }
        return builder.build();
    }

    public static class Builder
    extends WithParentObjectId.Builder {
        private String name;
        private String owner;
        private long creationTime;
        private long modificationTime;
        private final List<OzoneAcl> acls = new LinkedList<OzoneAcl>();

        @Override
        public Builder setParentObjectID(long parentObjectId) {
            super.setParentObjectID(parentObjectId);
            return this;
        }

        @Override
        public Builder setObjectID(long objectId) {
            super.setObjectID(objectId);
            return this;
        }

        @Override
        public Builder setUpdateID(long updateId) {
            super.setUpdateID(updateId);
            return this;
        }

        public Builder setName(String dirName) {
            this.name = dirName;
            return this;
        }

        public Builder setOwner(String ownerName) {
            this.owner = ownerName;
            return this;
        }

        public Builder setCreationTime(long newCreationTime) {
            this.creationTime = newCreationTime;
            return this;
        }

        public Builder setModificationTime(long newModificationTime) {
            this.modificationTime = newModificationTime;
            return this;
        }

        public Builder setAcls(List<OzoneAcl> listOfAcls) {
            if (listOfAcls != null) {
                this.acls.addAll(listOfAcls);
            }
            return this;
        }

        public Builder addAcl(OzoneAcl ozoneAcl) {
            if (ozoneAcl != null) {
                this.acls.add(ozoneAcl);
            }
            return this;
        }

        @Override
        public Builder addMetadata(String key, String value) {
            super.addMetadata(key, value);
            return this;
        }

        @Override
        public Builder addAllMetadata(Map<String, String> additionalMetadata) {
            super.addAllMetadata(additionalMetadata);
            return this;
        }

        public OmDirectoryInfo build() {
            return new OmDirectoryInfo(this);
        }
    }
}

