/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ha;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.ha.ConfUtils;
import org.apache.hadoop.ozone.om.ha.OMFailoverProxyProviderBase;
import org.apache.hadoop.ozone.om.protocolPB.GrpcOmTransport;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcOMFailoverProxyProvider<T>
extends OMFailoverProxyProviderBase<T> {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcOMFailoverProxyProvider.class);

    public GrpcOMFailoverProxyProvider(ConfigurationSource configuration, UserGroupInformation ugi, String omServiceId, Class<T> protocol) throws IOException {
        super(configuration, ugi, omServiceId, protocol);
    }

    @Override
    protected void loadOMClientConfigs(ConfigurationSource config, String omSvcId) throws IOException {
        Collection<String> omNodeIds = OmUtils.getActiveOMNodeIds(config, omSvcId);
        HashMap omProxies = new HashMap();
        ArrayList<String> omNodeIDList = new ArrayList<String>();
        HashMap<String, InetSocketAddress> omNodeAddressMap = new HashMap<String, InetSocketAddress>();
        for (String nodeId : OmUtils.emptyAsSingletonNull(omNodeIds)) {
            String rpcAddrKey = ConfUtils.addKeySuffixes((String)"ozone.om.address", (String[])new String[]{omSvcId, nodeId});
            Optional hostaddr = HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)config, (String[])new String[]{rpcAddrKey});
            OptionalInt hostport = HddsUtils.getNumberFromConfigKeys((ConfigurationSource)config, (String[])new String[]{ConfUtils.addKeySuffixes((String)"ozone.om.grpc.port", (String[])new String[]{omSvcId, nodeId}), "ozone.om.grpc.port"});
            if (nodeId == null) {
                nodeId = "om1";
            }
            if (!hostaddr.isPresent()) {
                LOG.error("expected host address not defined for: {}", (Object)rpcAddrKey);
                throw new ConfigurationException(rpcAddrKey + "is not defined");
            }
            int port = hostport.orElse(((GrpcOmTransport.GrpcOmTransportConfig)config.getObject(GrpcOmTransport.GrpcOmTransportConfig.class)).getPort());
            FailoverProxyProvider.ProxyInfo proxyInfo = new FailoverProxyProvider.ProxyInfo(this.createOMProxy(), (String)hostaddr.get() + ":" + port);
            omProxies.put(nodeId, proxyInfo);
            omNodeAddressMap.put(nodeId, NetUtils.createSocketAddr((String)proxyInfo.proxyInfo));
            omNodeIDList.add(nodeId);
        }
        if (omProxies.isEmpty()) {
            throw new IllegalArgumentException("Could not find any configured addresses for OM. Please configure the system with ozone.om.address");
        }
        this.setOmProxies(omProxies);
        this.setOmNodeIDList(omNodeIDList);
        this.setOmNodeAddressMap(omNodeAddressMap);
    }

    private T createOMProxy() throws IOException {
        InetSocketAddress addr = new InetSocketAddress(0);
        return this.createOMProxy(addr);
    }

    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        return this.getOMProxyMap().get(this.getCurrentProxyOMNodeId());
    }

    @Override
    protected synchronized boolean shouldFailover(Exception ex) {
        if (ex instanceof StatusRuntimeException) {
            StatusRuntimeException srexp = (StatusRuntimeException)ex;
            Status status = srexp.getStatus();
            if (status.getCode() == Status.Code.RESOURCE_EXHAUSTED) {
                LOG.debug("Grpc response has invalid length, {}", (Object)srexp.getMessage());
                return false;
            }
            if (status.getCode() == Status.Code.DATA_LOSS) {
                LOG.debug("Grpc unrecoverable data loss or corruption, {}", (Object)srexp.getMessage());
                return false;
            }
        }
        return super.shouldFailover(ex);
    }

    @Override
    public synchronized void close() throws IOException {
    }

    public String getGrpcProxyAddress(String nodeId) throws IOException {
        Map omProxies = this.getOMProxyMap();
        if (omProxies.containsKey(nodeId)) {
            return omProxies.get((Object)nodeId).proxyInfo;
        }
        LOG.error("expected nodeId not found in omProxies for proxyhost {}", (Object)nodeId);
        throw new IOException("expected nodeId not found in omProxies for proxyhost");
    }

    public List<String> getGrpcOmNodeIDList() {
        return this.getOmNodeIDList();
    }
}

