/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.scm;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.ozone.admin.scm.ScmAdmin;
import org.apache.hadoop.ozone.upgrade.UpgradeException;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalization;
import picocli.CommandLine;

@CommandLine.Command(name="finalizeupgrade", description={"Finalize SCM Upgrade"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class FinalizeScmUpgradeSubcommand
extends ScmSubcommand {
    @CommandLine.ParentCommand
    private ScmAdmin parent;
    @CommandLine.Option(names={"--takeover"}, description={"Forces takeover of monitoring from another client, if finalization has already been started and did not finish yet."})
    private boolean force;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        String upgradeClientID = "Upgrade-Client-" + UUID.randomUUID().toString();
        try {
            UpgradeFinalization.StatusAndMessages finalizationResponse = scmClient.finalizeScmUpgrade(upgradeClientID);
            if (UpgradeFinalization.isFinalized((UpgradeFinalization.Status)finalizationResponse.status())) {
                System.out.println("Upgrade has already been finalized.");
                UpgradeFinalization.emitExitMsg();
                return;
            }
            if (!UpgradeFinalization.isStarting((UpgradeFinalization.Status)finalizationResponse.status())) {
                System.err.println("Invalid response from Storage Container Manager.");
                System.err.println("Current finalization status is: " + finalizationResponse.status());
                throw new IOException("Exiting...");
            }
        }
        catch (UpgradeException e) {
            UpgradeFinalization.handleInvalidRequestAfterInitiatingFinalization((boolean)this.force, (UpgradeException)e);
        }
        this.monitorAndWaitFinalization(scmClient, upgradeClientID);
    }

    private void monitorAndWaitFinalization(ScmClient client, String upgradeClientID) throws IOException {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Future<Void> monitor = exec.submit(new UpgradeMonitor(client, upgradeClientID, this.force));
        try {
            monitor.get();
            UpgradeFinalization.emitFinishedMsg((String)"Storage Container Manager");
        }
        catch (CancellationException e) {
            UpgradeFinalization.emitCancellationMsg((String)"Storage Container Manager");
        }
        catch (InterruptedException e) {
            UpgradeFinalization.emitCancellationMsg((String)"Storage Container Manager");
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            UpgradeFinalization.emitGeneralErrorMsg();
            throw new IOException(e.getCause());
        }
        finally {
            exec.shutdown();
        }
    }

    private static class UpgradeMonitor
    implements Callable<Void> {
        private ScmClient client;
        private String upgradeClientID;
        private boolean force;

        UpgradeMonitor(ScmClient client, String upgradeClientID, boolean force) {
            this.client = client;
            this.upgradeClientID = upgradeClientID;
            this.force = force;
        }

        @Override
        public Void call() throws Exception {
            boolean finished = false;
            while (!finished) {
                UpgradeFinalization.StatusAndMessages progress;
                block6: {
                    block5: {
                        Thread.sleep(500L);
                        progress = this.client.queryUpgradeFinalizationProgress(this.upgradeClientID, this.force, false);
                        if (UpgradeFinalization.isFinalized((UpgradeFinalization.Status)progress.status())) {
                            System.out.println("Finalization already finished.");
                            UpgradeFinalization.emitExitMsg();
                            return null;
                        }
                        if (UpgradeFinalization.isInprogress((UpgradeFinalization.Status)progress.status())) break block5;
                        if (!UpgradeFinalization.isDone((UpgradeFinalization.Status)progress.status())) break block6;
                    }
                    progress.msgs().stream().forEachOrdered(System.out::println);
                }
                if (!UpgradeFinalization.isDone((UpgradeFinalization.Status)progress.status())) continue;
                UpgradeFinalization.emitExitMsg();
                finished = true;
            }
            return null;
        }
    }
}

