/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.om;

import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.admin.om.OMAdmin;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalization;
import picocli.CommandLine;

@CommandLine.Command(name="finalizationstatus", description={"Get the finalization status of om cluster."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class FinalizationStatusSubCommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private OMAdmin parent;
    @CommandLine.Option(names={"-id", "--service-id"}, description={"Ozone Manager Service ID"})
    private String omServiceId;
    @CommandLine.Option(names={"-host", "--service-host"}, description={"Ozone Manager Host"})
    private String omHost;

    @Override
    public Void call() throws Exception {
        OzoneManagerProtocolClientSideTranslatorPB client = this.parent.createOmClient(this.omServiceId, this.omHost, false);
        String upgradeClientID = "Upgrade-Client-" + UUID.randomUUID().toString();
        UpgradeFinalization.StatusAndMessages progress = client.queryUpgradeFinalizationProgress(upgradeClientID, false, true);
        System.out.println(progress.status());
        return null;
    }
}

