/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.datanode;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.cli.datanode.DecommissionSubCommand;
import org.apache.hadoop.hdds.scm.cli.datanode.HostNameParameters;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import picocli.CommandLine;

@CommandLine.Command(name="maintenance", description={"Put a datanode into Maintenance Mode"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class MaintenanceSubCommand
extends ScmSubcommand {
    @CommandLine.Mixin
    private HostNameParameters hostNameParams;
    @CommandLine.Option(names={"--end"}, description={"Automatically end maintenance after the given hours. By default, maintenance must be ended manually."})
    private int endInHours = 0;
    @CommandLine.Option(names={"--force"}, defaultValue="false", description={"Forcefully try to decommission the datanode(s)"})
    private boolean force;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        List<String> hosts = this.hostNameParams.getHostNames();
        List errors = scmClient.startMaintenanceNodes(hosts, this.endInHours, this.force);
        System.out.println("Entering maintenance mode on datanode(s):\n" + String.join((CharSequence)"\n", hosts));
        DecommissionSubCommand.showErrors(errors, "Some nodes could not start the maintenance workflow");
    }
}

