/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication.health;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.scm.container.replication.ContainerCheckRequest;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.health.AbstractCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosingContainerHandler
extends AbstractCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ClosingContainerHandler.class);
    private final ReplicationManager replicationManager;
    private final Clock clock;

    public ClosingContainerHandler(ReplicationManager rm, Clock clock) {
        this.replicationManager = rm;
        this.clock = clock;
    }

    @Override
    public boolean handle(ContainerCheckRequest request) {
        boolean forceClose;
        ContainerInfo containerInfo = request.getContainerInfo();
        if (containerInfo.getState() != HddsProtos.LifeCycleState.CLOSING) {
            return false;
        }
        LOG.debug("Checking container {} in ClosingContainerHandler", (Object)containerInfo);
        boolean bl = forceClose = containerInfo.getReplicationConfig().getReplicationType() != HddsProtos.ReplicationType.RATIS;
        if (request.getContainerReplicas().isEmpty()) {
            request.getReport().incrementAndSample(ReplicationManagerReport.HealthState.MISSING, containerInfo.containerID());
        }
        if (request.isReadOnly()) {
            return true;
        }
        boolean allUnhealthy = true;
        for (ContainerReplica replica : request.getContainerReplicas()) {
            if (replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY) continue;
            allUnhealthy = false;
            this.replicationManager.sendCloseContainerReplicaCommand(containerInfo, replica.getDatanodeDetails(), forceClose);
        }
        if (allUnhealthy && !request.getContainerReplicas().isEmpty()) {
            HddsProtos.LifeCycleEvent event = HddsProtos.LifeCycleEvent.QUASI_CLOSE;
            if (containerInfo.getReplicationConfig().getReplicationType() == HddsProtos.ReplicationType.EC) {
                event = HddsProtos.LifeCycleEvent.CLOSE;
            }
            LOG.debug("Container {} has only unhealthy replicas and is closing, so executing the {} event.", (Object)containerInfo, (Object)event);
            this.replicationManager.updateContainerState(containerInfo.containerID(), event);
        }
        if (request.getContainerReplicas().isEmpty() && containerInfo.getNumberOfKeys() == 0L && this.hasWaitTimeElapsed(containerInfo)) {
            LOG.debug("Container appears to be empty, has no replicas, and has been closing, so moving to closed state: {}", (Object)containerInfo);
            this.replicationManager.updateContainerState(containerInfo.containerID(), HddsProtos.LifeCycleEvent.CLOSE);
        }
        return true;
    }

    private boolean hasWaitTimeElapsed(ContainerInfo containerInfo) {
        Duration waitTime = this.replicationManager.getConfig().getInterval().multipliedBy(5L);
        Instant closingTime = containerInfo.getStateEnterTime();
        return this.clock.instant().isAfter(closingTime.plus(waitTime));
    }
}

