/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.token;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ContainerBlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyVerifierClient;
import org.apache.hadoop.hdds.security.token.BlockTokenException;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.hdds.security.token.ShortLivedTokenVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockTokenVerifier
extends ShortLivedTokenVerifier<OzoneBlockTokenIdentifier> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockTokenVerifier.class);

    public static String getTokenService(BlockID blockID) {
        return BlockTokenVerifier.getTokenService(blockID.getContainerBlockID());
    }

    public static String getTokenService(ContainerBlockID blockID) {
        return String.valueOf(blockID);
    }

    public BlockTokenVerifier(SecurityConfig conf, SecretKeyVerifierClient secretKeyClient) {
        super(conf, secretKeyClient);
    }

    @Override
    protected boolean isTokenRequired(ContainerProtos.Type cmdType) {
        return this.getConf().isBlockTokenEnabled() && HddsUtils.requireBlockToken((ContainerProtos.Type)cmdType);
    }

    @Override
    protected OzoneBlockTokenIdentifier createTokenIdentifier() {
        return new OzoneBlockTokenIdentifier();
    }

    @Override
    protected Object getService(ContainerProtos.ContainerCommandRequestProtoOrBuilder cmd) {
        BlockID blockID = HddsUtils.getBlockID((ContainerProtos.ContainerCommandRequestProtoOrBuilder)cmd);
        Preconditions.checkNotNull((Object)blockID, (String)"no blockID in %s command", (Object)cmd.getCmdType());
        return BlockTokenVerifier.getTokenService(blockID);
    }

    @Override
    protected void verify(OzoneBlockTokenIdentifier tokenId, ContainerProtos.ContainerCommandRequestProtoOrBuilder cmd) throws SCMSecurityException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Verifying token:{} for user:{} ", (Object)tokenId, (Object)tokenId.getUser());
        }
        HddsProtos.BlockTokenSecretProto.AccessModeProto accessMode = HddsUtils.isReadOnly((ContainerProtos.ContainerCommandRequestProtoOrBuilder)cmd) ? HddsProtos.BlockTokenSecretProto.AccessModeProto.READ : (cmd.getCmdType() == ContainerProtos.Type.DeleteBlock || cmd.getCmdType() == ContainerProtos.Type.DeleteChunk ? HddsProtos.BlockTokenSecretProto.AccessModeProto.DELETE : HddsProtos.BlockTokenSecretProto.AccessModeProto.WRITE);
        if (!tokenId.getAccessModes().contains(accessMode)) {
            throw new BlockTokenException("Block token with " + tokenId.getService() + " doesn't have " + accessMode + " permission");
        }
    }
}

