/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.managed;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@InterfaceAudience.Private
@Metrics(about="Ozone Manage RocksObject Metrics", context="ozone")
public class ManagedRocksObjectMetrics {
    public static final ManagedRocksObjectMetrics INSTANCE = ManagedRocksObjectMetrics.create();
    private static final String SOURCE_NAME = ManagedRocksObjectMetrics.class.getSimpleName();
    @Metric(about="Total number of managed RocksObjects that are not closed before being GCed.")
    private MutableCounterLong totalLeakObjects;
    @Metric(about="Total Number of managed RocksObjects.")
    private MutableCounterLong totalManagedObjects;

    void increaseLeakObject() {
        this.totalLeakObjects.incr();
    }

    public void assertNoLeaks() {
        long cnt = this.totalLeakObjects.value();
        if (cnt > 0L) {
            throw new AssertionError((Object)("Found " + cnt + " leaked objects, check logs"));
        }
    }

    void increaseManagedObject() {
        this.totalManagedObjects.incr();
    }

    @VisibleForTesting
    long totalLeakObjects() {
        return this.totalLeakObjects.value();
    }

    @VisibleForTesting
    long totalManagedObjects() {
        return this.totalManagedObjects.value();
    }

    private static ManagedRocksObjectMetrics create() {
        return (ManagedRocksObjectMetrics)DefaultMetricsSystem.instance().register(SOURCE_NAME, "OzoneManager DoubleBuffer Metrics", (Object)new ManagedRocksObjectMetrics());
    }
}

