/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.managed;

import java.util.concurrent.atomic.AtomicBoolean;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.Cache;

public class ManagedBlockBasedTableConfig
extends BlockBasedTableConfig {
    private Cache blockCacheHolder;
    private AtomicBoolean closed = new AtomicBoolean(false);

    public synchronized ManagedBlockBasedTableConfig closeAndSetBlockCache(Cache blockCache) {
        Cache previous = this.blockCacheHolder;
        if (previous != null && previous.isOwningHandle()) {
            previous.close();
        }
        return this.setBlockCache(blockCache);
    }

    public synchronized ManagedBlockBasedTableConfig setBlockCache(Cache blockCache) {
        Cache previous = this.blockCacheHolder;
        if (previous != null && previous.isOwningHandle()) {
            throw new IllegalStateException("Overriding an unclosed value.");
        }
        this.blockCacheHolder = blockCache;
        super.setBlockCache(blockCache);
        return this;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.filterPolicy() != null) {
                this.filterPolicy().close();
            }
            if (this.blockCacheHolder != null) {
                this.blockCacheHolder.close();
            }
        }
    }
}

