/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.upgrade;

import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.upgrade.HDDSUpgradeAction;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.CodecException;
import org.apache.hadoop.hdds.utils.db.RocksDatabaseException;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.TypedTable;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeStateMachine;
import org.apache.hadoop.ozone.container.metadata.ContainerCreateInfo;
import org.apache.hadoop.ozone.container.metadata.WitnessedContainerDBDefinition;
import org.apache.hadoop.ozone.container.metadata.WitnessedContainerMetadataStore;
import org.apache.hadoop.ozone.container.metadata.WitnessedContainerMetadataStoreImpl;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.ozone.upgrade.UpgradeActionHdds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UpgradeActionHdds(feature=HDDSLayoutFeature.WITNESSED_CONTAINER_DB_PROTO_VALUE, component=UpgradeActionHdds.Component.DATANODE, type=LayoutFeature.UpgradeActionType.ON_FINALIZE)
public class ContainerTableSchemaFinalizeAction
implements HDDSUpgradeAction<DatanodeStateMachine> {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerTableSchemaFinalizeAction.class);

    public void execute(DatanodeStateMachine arg) throws Exception {
        WitnessedContainerMetadataStore metadataStore = arg.getContainer().getWitnessedContainerMetadataStore();
        Table<ContainerID, ContainerCreateInfo> previousTable = ((WitnessedContainerMetadataStoreImpl)metadataStore).getPreviousVersionTables().getContainerIdsTable();
        TypedTable currTable = WitnessedContainerDBDefinition.CONTAINER_CREATE_INFO_TABLE_DEF.getTable(metadataStore.getStore());
        try (TableIterator curTblItr = currTable.keyIterator();){
            ContainerTableSchemaFinalizeAction.truncateCurrentTable((TableIterator<ContainerID, ContainerID>)curTblItr, (Table<ContainerID, ContainerCreateInfo>)currTable);
        }
        try (BatchOperation batch = metadataStore.getStore().initBatchOperation();
             Table.KeyValueIterator iterator = previousTable.iterator();){
            while (iterator.hasNext()) {
                Table.KeyValue next = (Table.KeyValue)iterator.next();
                currTable.putWithBatch(batch, (Object)((ContainerID)next.getKey()), (Object)((ContainerCreateInfo)next.getValue()));
            }
            metadataStore.getStore().commitBatchOperation(batch);
            LOG.info("Finished copy to containerIdsTable from previous table");
        }
    }

    private static void truncateCurrentTable(TableIterator<ContainerID, ContainerID> curTblItr, Table<ContainerID, ContainerCreateInfo> currTable) throws RocksDatabaseException, CodecException {
        ContainerID startContainerID = null;
        ContainerID endContainerID = null;
        if (curTblItr.hasNext()) {
            endContainerID = startContainerID = (ContainerID)curTblItr.next();
        }
        while (curTblItr.hasNext()) {
            endContainerID = (ContainerID)curTblItr.next();
        }
        if (startContainerID != null) {
            if (startContainerID != endContainerID) {
                currTable.deleteRange((Object)startContainerID, (Object)endContainerID);
            }
            currTable.delete((Object)endContainerID);
        }
    }
}

