/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.stream;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.ssl.SslContext;
import io.netty.util.CharsetUtil;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.ozone.container.stream.DirstreamClientHandler;
import org.apache.hadoop.ozone.container.stream.StreamingDestination;
import org.apache.hadoop.ozone.container.stream.StreamingException;

public class StreamingClient
implements AutoCloseable {
    private final Bootstrap bootstrap;
    private final DirstreamClientHandler dirstreamClientHandler;
    private EventLoopGroup group;
    private int port;
    private String host;

    public StreamingClient(String host, int port, StreamingDestination streamingDestination) {
        this(host, port, streamingDestination, null);
    }

    public StreamingClient(final String host, final int port, StreamingDestination streamingDestination, final SslContext sslContext) {
        this.port = port;
        this.host = host;
        this.group = new NioEventLoopGroup(100);
        this.dirstreamClientHandler = new DirstreamClientHandler(streamingDestination);
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.group)).channel(NioSocketChannel.class)).option(ChannelOption.SO_RCVBUF, (Object)0x100000)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                if (sslContext != null) {
                    p.addLast(new ChannelHandler[]{sslContext.newHandler(ch.alloc(), host, port)});
                }
                p.addLast(new ChannelHandler[]{new StringEncoder(CharsetUtil.UTF_8), StreamingClient.this.dirstreamClientHandler});
            }
        });
    }

    public void stream(String id) {
        this.stream(id, 200L, TimeUnit.SECONDS);
    }

    public void stream(String id, long timeout, TimeUnit unit) {
        try {
            Channel channel = this.bootstrap.connect(this.host, this.port).sync().channel();
            channel.writeAndFlush((Object)(id + "\n")).await(timeout, unit);
            channel.closeFuture().await(timeout, unit);
            if (!this.dirstreamClientHandler.isAtTheEnd()) {
                throw new StreamingException("Streaming is failed. Not all files are streamed. Please check the log of the server. Last (partial?) streamed file: " + this.dirstreamClientHandler.getCurrentFileName());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StreamingException(e);
        }
    }

    @Override
    public void close() {
        this.group.shutdownGracefully();
    }
}

