/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerDataYaml;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.VolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.utils.StorageVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.TarContainerPacker;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.replication.CopyContainerCompression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerImporter {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerImporter.class);
    public static final String CONTAINER_COPY_DIR = "container-copy";
    private static final String CONTAINER_COPY_TMP_DIR = "tmp";
    private final ContainerSet containerSet;
    private final ContainerController controller;
    private final MutableVolumeSet volumeSet;
    private final VolumeChoosingPolicy volumeChoosingPolicy;
    private final long defaultContainerSize;
    private final Set<Long> importContainerProgress = Collections.synchronizedSet(new HashSet());
    private final ConfigurationSource conf;

    public ContainerImporter(@Nonnull ConfigurationSource conf, @Nonnull ContainerSet containerSet, @Nonnull ContainerController controller, @Nonnull MutableVolumeSet volumeSet, @Nonnull VolumeChoosingPolicy volumeChoosingPolicy) {
        this.containerSet = containerSet;
        this.controller = controller;
        this.volumeSet = volumeSet;
        this.volumeChoosingPolicy = volumeChoosingPolicy;
        this.defaultContainerSize = (long)conf.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
        this.conf = conf;
    }

    public boolean isAllowedContainerImport(long containerID) {
        return !this.importContainerProgress.contains(containerID) && this.containerSet.getContainer(containerID) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importContainer(long containerID, Path tarFilePath, HddsVolume targetVolume, CopyContainerCompression compression) throws IOException {
        if (!this.importContainerProgress.add(containerID)) {
            ContainerImporter.deleteFileQuietely(tarFilePath);
            String log = "Container import in progress with container Id " + containerID;
            LOG.warn(log);
            throw new StorageContainerException(log, ContainerProtos.Result.CONTAINER_EXISTS);
        }
        try {
            KeyValueContainerData containerData;
            if (this.containerSet.getContainer(containerID) != null) {
                String log = "Container already exists with container Id " + containerID;
                LOG.warn(log);
                throw new StorageContainerException(log, ContainerProtos.Result.CONTAINER_EXISTS);
            }
            TarContainerPacker packer = this.getPacker(compression);
            try (InputStream input = Files.newInputStream(tarFilePath, new OpenOption[0]);){
                byte[] containerDescriptorYaml = packer.unpackContainerDescriptor(input);
                containerData = this.getKeyValueContainerData(containerDescriptorYaml);
            }
            ContainerUtils.verifyContainerFileChecksum(containerData, this.conf);
            containerData.setVolume(targetVolume);
            containerData.setDataScanTimestamp(null);
            try {
                input = Files.newInputStream(tarFilePath, new OpenOption[0]);
                try {
                    Container container = this.controller.importContainer(containerData, input, packer);
                    targetVolume.incrementUsedSpace(((ContainerData)container.getContainerData()).getBytesUsed());
                    this.containerSet.addContainerByOverwriteMissingContainer(container);
                    this.containerSet.scanContainer(containerID, "Imported container");
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                }
            }
            catch (Exception e) {
                StorageVolumeUtil.onFailure(containerData.getVolume());
                throw e;
            }
        }
        finally {
            this.importContainerProgress.remove(containerID);
            ContainerImporter.deleteFileQuietely(tarFilePath);
        }
    }

    private static void deleteFileQuietely(Path tarFilePath) {
        try {
            Files.delete(tarFilePath);
        }
        catch (Exception ex) {
            LOG.error("Got exception while deleting temporary container file: " + tarFilePath.toAbsolutePath(), (Throwable)ex);
        }
    }

    HddsVolume chooseNextVolume(long spaceToReserve) throws IOException {
        LOG.debug("Choosing volume to reserve space : {}", (Object)spaceToReserve);
        return this.volumeChoosingPolicy.chooseVolume(StorageVolumeUtil.getHddsVolumesList(this.volumeSet.getVolumesList()), spaceToReserve);
    }

    public static Path getUntarDirectory(HddsVolume hddsVolume) throws IOException {
        return Paths.get(hddsVolume.getVolumeRootDir(), new String[0]).resolve(CONTAINER_COPY_TMP_DIR).resolve(CONTAINER_COPY_DIR);
    }

    protected KeyValueContainerData getKeyValueContainerData(byte[] containerDescriptorYaml) throws IOException {
        return (KeyValueContainerData)ContainerDataYaml.readContainer(containerDescriptorYaml);
    }

    protected Set<Long> getImportContainerProgress() {
        return this.importContainerProgress;
    }

    protected TarContainerPacker getPacker(CopyContainerCompression compression) {
        return new TarContainerPacker(compression);
    }

    public long getDefaultReplicationSpace() {
        return HddsServerUtil.requiredReplicationSpace((long)this.defaultContainerSize);
    }

    public long getRequiredReplicationSpace(long actualContainerSize) {
        return HddsServerUtil.requiredReplicationSpace((long)actualContainerSize);
    }

    public long getSpaceToReserve(Long replicateSize) {
        if (replicateSize != null) {
            return this.getRequiredReplicationSpace(replicateSize);
        }
        return this.getDefaultReplicationSpace();
    }
}

