/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdfs.util.Canceler;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerScanHelper;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerScannerConfiguration;
import org.apache.hadoop.ozone.container.ozoneimpl.OnDemandScannerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OnDemandContainerScanner {
    private static final Logger LOG = LoggerFactory.getLogger(OnDemandContainerScanner.class);
    private final ExecutorService scanExecutor;
    private final DataTransferThrottler throttler;
    private final Canceler canceler;
    private final ConcurrentHashMap.KeySetView<Long, Boolean> containerRescheduleCheckSet;
    private final OnDemandScannerMetrics metrics;
    private final ContainerScanHelper scannerHelper;
    private final ContainerScanHelper scannerHelperWithoutGap;

    public OnDemandContainerScanner(ContainerScannerConfiguration conf, ContainerController controller) {
        this.throttler = new DataTransferThrottler(conf.getOnDemandBandwidthPerVolume());
        this.canceler = new Canceler();
        this.metrics = OnDemandScannerMetrics.create();
        this.scanExecutor = Executors.newSingleThreadExecutor();
        this.containerRescheduleCheckSet = ConcurrentHashMap.newKeySet();
        this.scannerHelper = ContainerScanHelper.withScanGap(LOG, controller, this.metrics, conf);
        this.scannerHelperWithoutGap = ContainerScanHelper.withoutScanGap(LOG, controller, this.metrics);
    }

    public Optional<Future<?>> scanContainer(Container<?> container, String reasonForScan) {
        return this.scanContainer(container, this.scannerHelper, reasonForScan);
    }

    public Optional<Future<?>> scanContainerWithoutGap(Container<?> container, String reasonForScan) {
        return this.scanContainer(container, this.scannerHelperWithoutGap, reasonForScan);
    }

    private Optional<Future<?>> scanContainer(Container<?> container, ContainerScanHelper helper, String reasonForScan) {
        if (!helper.shouldScanMetadata(container)) {
            return Optional.empty();
        }
        Future<?> resultFuture = null;
        long containerId = ((ContainerData)container.getContainerData()).getContainerID();
        if (this.addContainerToScheduledContainers(containerId)) {
            resultFuture = this.scanExecutor.submit(() -> {
                this.performOnDemandScan(container, helper, reasonForScan);
                this.removeContainerFromScheduledContainers(containerId);
            });
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Skipping OnDemandScan for Container {} triggered due to '{}'. Reason: Already scheduled.", (Object)containerId, (Object)reasonForScan);
        }
        return Optional.ofNullable(resultFuture);
    }

    private boolean addContainerToScheduledContainers(long containerId) {
        return this.containerRescheduleCheckSet.add(containerId);
    }

    private void removeContainerFromScheduledContainers(long containerId) {
        this.containerRescheduleCheckSet.remove(containerId);
    }

    private void performOnDemandScan(Container<?> container, ContainerScanHelper helper, String reasonForScan) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduling OnDemandScan for Container {}, Reason: {}", (Object)((ContainerData)container.getContainerData()).getContainerID(), (Object)reasonForScan);
        }
        try {
            if (helper.shouldScanData(container)) {
                helper.scanData(container, this.throttler, this.canceler);
            } else {
                helper.scanMetadata(container);
            }
        }
        catch (IOException e) {
            LOG.warn("Unexpected exception while scanning container " + ((ContainerData)container.getContainerData()).getContainerID(), (Throwable)e);
        }
        catch (InterruptedException ex) {
            LOG.info("On demand container scan interrupted.");
        }
    }

    public OnDemandScannerMetrics getMetrics() {
        return this.metrics;
    }

    public synchronized void shutdown() {
        this.metrics.unregister();
        String shutdownMessage = "On-demand container scanner is shutting down.";
        LOG.info(shutdownMessage);
        this.canceler.cancel(shutdownMessage);
        if (!this.scanExecutor.isShutdown()) {
            this.scanExecutor.shutdown();
        }
        try {
            long timeoutSeconds = 5L;
            if (!this.scanExecutor.awaitTermination(timeoutSeconds, TimeUnit.SECONDS)) {
                LOG.warn("On demand scanner shut down forcefully after {} seconds", (Object)timeoutSeconds);
                this.scanExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOG.warn("On demand scanner interrupted while waiting for shut down.");
            this.scanExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

