/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Striped;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.ByteStringConversion;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocolPB.ContainerCommandResponseBuilders;
import org.apache.hadoop.hdds.scm.storage.BlockInputStream;
import org.apache.hadoop.hdds.scm.storage.BlockLocationInfo;
import org.apache.hadoop.hdds.scm.storage.ChunkInputStream;
import org.apache.hadoop.hdds.scm.utils.ClientCommandsUtils;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.utils.FaultInjector;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.client.io.BlockInputStreamFactoryImpl;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.common.ChecksumData;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.hadoop.ozone.common.ChunkBufferToByteString;
import org.apache.hadoop.ozone.common.OzoneChecksumException;
import org.apache.hadoop.ozone.common.utils.BufferUtils;
import org.apache.hadoop.ozone.container.checksum.ContainerChecksumTreeManager;
import org.apache.hadoop.ozone.container.checksum.ContainerDiffReport;
import org.apache.hadoop.ozone.container.checksum.ContainerMerkleTreeWriter;
import org.apache.hadoop.ozone.container.checksum.DNContainerOperationClient;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerLayoutVersion;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.interfaces.BlockIterator;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.DBHandle;
import org.apache.hadoop.ozone.container.common.interfaces.Handler;
import org.apache.hadoop.ozone.container.common.interfaces.ScanResult;
import org.apache.hadoop.ozone.container.common.interfaces.VolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.report.IncrementalReportSender;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.DispatcherContext;
import org.apache.hadoop.ozone.container.common.utils.ContainerLogger;
import org.apache.hadoop.ozone.container.common.utils.StorageVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeChoosingPolicyFactory;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainer;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.TarContainerPacker;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.keyvalue.helpers.ChunkUtils;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyValueContainerUtil;
import org.apache.hadoop.ozone.container.keyvalue.impl.BlockManagerImpl;
import org.apache.hadoop.ozone.container.keyvalue.impl.ChunkManagerFactory;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.BlockManager;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.ChunkManager;
import org.apache.hadoop.ozone.container.upgrade.VersionedDatanodeFeatures;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Time;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueHandler
extends Handler {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueHandler.class);
    private final BlockManager blockManager;
    private final ChunkManager chunkManager;
    private final VolumeChoosingPolicy volumeChoosingPolicy;
    private final long maxContainerSize;
    private final long maxDeleteLockWaitMs;
    private final Function<ByteBuffer, ByteString> byteBufferToByteString;
    private final boolean validateChunkChecksumData;
    private final int chunkSize;
    private final Striped<Lock> containerCreationLocks;
    private final ContainerChecksumTreeManager checksumManager;
    private static FaultInjector injector;
    private final Clock clock;
    private final BlockInputStreamFactoryImpl blockInputStreamFactory;

    public KeyValueHandler(ConfigurationSource config, String datanodeId, ContainerSet contSet, VolumeSet volSet, ContainerMetrics metrics, IncrementalReportSender<Container> icrSender, ContainerChecksumTreeManager checksumManager) {
        this(config, datanodeId, contSet, volSet, null, metrics, icrSender, Clock.systemUTC(), checksumManager);
    }

    public KeyValueHandler(ConfigurationSource config, String datanodeId, ContainerSet contSet, VolumeSet volSet, VolumeChoosingPolicy volumeChoosingPolicy, ContainerMetrics metrics, IncrementalReportSender<Container> icrSender, Clock clock, ContainerChecksumTreeManager checksumManager) {
        super(config, datanodeId, contSet, volSet, metrics, icrSender);
        this.clock = clock;
        this.blockManager = new BlockManagerImpl(config);
        this.validateChunkChecksumData = ((DatanodeConfiguration)((Object)this.conf.getObject(DatanodeConfiguration.class))).isChunkDataValidationCheck();
        this.chunkManager = ChunkManagerFactory.createChunkManager(config, this.blockManager, volSet);
        this.checksumManager = checksumManager;
        this.volumeChoosingPolicy = volumeChoosingPolicy != null ? volumeChoosingPolicy : VolumeChoosingPolicyFactory.getPolicy(config);
        this.maxContainerSize = (long)config.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
        DatanodeConfiguration dnConf = (DatanodeConfiguration)((Object)this.conf.getObject(DatanodeConfiguration.class));
        this.maxDeleteLockWaitMs = dnConf.getDeleteContainerTimeoutMs();
        int threadCountPerDisk = this.conf.getInt("hdds.container.ratis.num.write.chunk.threads.per.volume", 10);
        int numberOfDisks = HddsServerUtil.getDatanodeStorageDirs((ConfigurationSource)this.conf).size();
        this.containerCreationLocks = Striped.lazyWeakLock((int)(threadCountPerDisk * numberOfDisks));
        boolean isUnsafeByteBufferConversionEnabled = this.conf.getBoolean("ozone.UnsafeByteOperations.enabled", true);
        this.byteBufferToByteString = ByteStringConversion.createByteBufferConversion((boolean)isUnsafeByteBufferConversionEnabled);
        this.blockInputStreamFactory = new BlockInputStreamFactoryImpl();
        this.chunkSize = (int)this.conf.getStorageSize("ozone.scm.chunk.size", "4MB", StorageUnit.BYTES);
        if (ContainerLayoutVersion.getConfiguredVersion(this.conf) == ContainerLayoutVersion.FILE_PER_CHUNK) {
            LOG.warn("FILE_PER_CHUNK layout is not supported. Falling back to default : {}.", (Object)ContainerLayoutVersion.DEFAULT_LAYOUT.name());
            OzoneConfiguration.of((ConfigurationSource)this.conf).set("ozone.scm.container.layout", ContainerLayoutVersion.DEFAULT_LAYOUT.name());
        }
    }

    @Override
    public StateMachine.DataChannel getStreamDataChannel(Container container, ContainerProtos.ContainerCommandRequestProto msg) throws StorageContainerException {
        KeyValueContainer kvContainer = (KeyValueContainer)container;
        this.checkContainerOpen(kvContainer);
        if (msg.hasWriteChunk()) {
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)msg.getWriteChunk().getBlockID());
            return this.chunkManager.getStreamDataChannel(kvContainer, blockID, this.metrics);
        }
        throw new StorageContainerException("Malformed request.", ContainerProtos.Result.IO_EXCEPTION);
    }

    @Override
    public void stop() {
        this.chunkManager.shutdown();
        this.blockManager.shutdown();
    }

    @Override
    public ContainerProtos.ContainerCommandResponseProto handle(ContainerProtos.ContainerCommandRequestProto request, Container container, DispatcherContext dispatcherContext) {
        try {
            return KeyValueHandler.dispatchRequest(this, request, (KeyValueContainer)container, dispatcherContext);
        }
        catch (RuntimeException e) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException((Throwable)e, ContainerProtos.Result.CONTAINER_INTERNAL_ERROR), request);
        }
    }

    @VisibleForTesting
    static ContainerProtos.ContainerCommandResponseProto dispatchRequest(KeyValueHandler handler, ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer, DispatcherContext dispatcherContext) {
        ContainerProtos.Type cmdType = request.getCmdType();
        if (kvContainer != null) {
            try {
                handler.validateRequestDatanodeId(kvContainer.getContainerData().getReplicaIndex(), request.getDatanodeUuid());
            }
            catch (StorageContainerException e) {
                return ContainerUtils.logAndReturnError(LOG, e, request);
            }
        }
        switch (cmdType) {
            case CreateContainer: {
                return handler.handleCreateContainer(request, kvContainer);
            }
            case ReadContainer: {
                return handler.handleReadContainer(request, kvContainer);
            }
            case UpdateContainer: {
                return handler.handleUpdateContainer(request, kvContainer);
            }
            case DeleteContainer: {
                return handler.handleDeleteContainer(request, kvContainer);
            }
            case ListContainer: {
                return handler.handleUnsupportedOp(request);
            }
            case CloseContainer: {
                return handler.handleCloseContainer(request, kvContainer);
            }
            case PutBlock: {
                return handler.handlePutBlock(request, kvContainer, dispatcherContext);
            }
            case GetBlock: {
                return handler.handleGetBlock(request, kvContainer);
            }
            case DeleteBlock: {
                return handler.handleDeleteBlock(request, kvContainer);
            }
            case ListBlock: {
                return handler.handleListBlock(request, kvContainer);
            }
            case ReadChunk: {
                return handler.handleReadChunk(request, kvContainer, dispatcherContext);
            }
            case DeleteChunk: {
                return handler.handleDeleteChunk(request, kvContainer);
            }
            case WriteChunk: {
                return handler.handleWriteChunk(request, kvContainer, dispatcherContext);
            }
            case StreamInit: {
                return handler.handleStreamInit(request, kvContainer, dispatcherContext);
            }
            case ListChunk: {
                return handler.handleUnsupportedOp(request);
            }
            case CompactChunk: {
                return handler.handleUnsupportedOp(request);
            }
            case PutSmallFile: {
                return handler.handlePutSmallFile(request, kvContainer, dispatcherContext);
            }
            case GetSmallFile: {
                return handler.handleGetSmallFile(request, kvContainer);
            }
            case GetCommittedBlockLength: {
                return handler.handleGetCommittedBlockLength(request, kvContainer);
            }
            case FinalizeBlock: {
                return handler.handleFinalizeBlock(request, kvContainer);
            }
            case Echo: {
                return handler.handleEcho(request, kvContainer);
            }
            case GetContainerChecksumInfo: {
                return handler.handleGetContainerChecksumInfo(request, kvContainer);
            }
        }
        return null;
    }

    @VisibleForTesting
    public ChunkManager getChunkManager() {
        return this.chunkManager;
    }

    @VisibleForTesting
    public BlockManager getBlockManager() {
        return this.blockManager;
    }

    @VisibleForTesting
    public ContainerChecksumTreeManager getChecksumManager() {
        return this.checksumManager;
    }

    ContainerProtos.ContainerCommandResponseProto handleStreamInit(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer, DispatcherContext dispatcherContext) {
        if (!request.hasWriteChunk()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed {} request. trace ID: {}", (Object)request.getCmdType(), (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        ContainerProtos.WriteChunkRequestProto writeChunk = request.getWriteChunk();
        BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)writeChunk.getBlockID());
        String path = null;
        try {
            this.checkContainerOpen(kvContainer);
            path = this.chunkManager.streamInit(kvContainer, blockID);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        return ContainerCommandResponseBuilders.getSuccessResponseBuilder((ContainerProtos.ContainerCommandRequestProto)request).setMessage(path).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContainerProtos.ContainerCommandResponseProto handleCreateContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasCreateContainer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Create Container request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        if (kvContainer != null) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Container creation failed because key value container already exists", null, ContainerProtos.Result.CONTAINER_ALREADY_EXISTS), request);
        }
        try {
            this.validateRequestDatanodeId(request.getCreateContainer().hasReplicaIndex() ? Integer.valueOf(request.getCreateContainer().getReplicaIndex()) : null, request.getDatanodeUuid());
        }
        catch (StorageContainerException e) {
            return ContainerUtils.logAndReturnError(LOG, e, request);
        }
        long containerID = request.getContainerID();
        ContainerProtos.ContainerDataProto.State containerState = request.getCreateContainer().getState();
        if (containerState != ContainerProtos.ContainerDataProto.State.RECOVERING) {
            try {
                this.containerSet.ensureContainerNotMissing(containerID, containerState);
            }
            catch (StorageContainerException ex) {
                return ContainerUtils.logAndReturnError(LOG, ex, request);
            }
        }
        ContainerLayoutVersion layoutVersion = ContainerLayoutVersion.getConfiguredVersion(this.conf);
        KeyValueContainerData newContainerData = new KeyValueContainerData(containerID, layoutVersion, this.maxContainerSize, request.getPipelineID(), this.getDatanodeId());
        ContainerProtos.ContainerDataProto.State state = request.getCreateContainer().getState();
        if (state != null) {
            newContainerData.setState(state);
        }
        newContainerData.setReplicaIndex(request.getCreateContainer().getReplicaIndex());
        KeyValueContainer newContainer = new KeyValueContainer(newContainerData, this.conf);
        boolean created = false;
        Lock containerIdLock = (Lock)this.containerCreationLocks.get((Object)containerID);
        containerIdLock.lock();
        try {
            if (this.containerSet.getContainer(containerID) == null) {
                newContainer.create(this.volumeSet, this.volumeChoosingPolicy, this.clusterId);
                created = ContainerProtos.ContainerDataProto.State.RECOVERING == newContainer.getContainerState() ? this.containerSet.addContainerByOverwriteMissingContainer(newContainer) : this.containerSet.addContainer(newContainer);
            } else {
                LOG.debug("Container already exists. container Id {}", (Object)containerID);
            }
        }
        catch (StorageContainerException ex) {
            newContainerData.releaseCommitSpace();
            ContainerProtos.ContainerCommandResponseProto containerCommandResponseProto = ContainerUtils.logAndReturnError(LOG, ex, request);
            return containerCommandResponseProto;
        }
        finally {
            containerIdLock.unlock();
        }
        if (created) {
            ContainerLogger.logOpen(newContainerData);
            try {
                this.sendICR(newContainer);
            }
            catch (StorageContainerException ex) {
                return ContainerUtils.logAndReturnError(LOG, ex, request);
            }
        }
        return ContainerCommandResponseBuilders.getSuccessResponse((ContainerProtos.ContainerCommandRequestProto)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateContainerPathFields(KeyValueContainer container, HddsVolume hddsVolume) throws IOException {
        this.volumeSet.readLock();
        try {
            String idDir = VersionedDatanodeFeatures.ScmHA.chooseContainerPathID(hddsVolume, this.clusterId);
            container.populatePathFields(idDir, hddsVolume);
        }
        finally {
            this.volumeSet.readUnlock();
        }
    }

    ContainerProtos.ContainerCommandResponseProto handleReadContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasReadContainer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Read Container request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        KeyValueContainerData containerData = kvContainer.getContainerData();
        return ContainerCommandResponseBuilders.getReadContainerResponse((ContainerProtos.ContainerCommandRequestProto)request, (ContainerProtos.ContainerDataProto)containerData.getProtoBufMessage());
    }

    ContainerProtos.ContainerCommandResponseProto handleUpdateContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasUpdateContainer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Update Container request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        boolean forceUpdate = request.getUpdateContainer().getForceUpdate();
        List keyValueList = request.getUpdateContainer().getMetadataList();
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (ContainerProtos.KeyValue keyValue : keyValueList) {
            metadata.put(keyValue.getKey(), keyValue.getValue());
        }
        try {
            if (!metadata.isEmpty()) {
                kvContainer.update(metadata, forceUpdate);
            }
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        return ContainerCommandResponseBuilders.getSuccessResponse((ContainerProtos.ContainerCommandRequestProto)request);
    }

    ContainerProtos.ContainerCommandResponseProto handleDeleteContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasDeleteContainer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Delete container request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        boolean forceDelete = request.getDeleteContainer().getForceDelete();
        try {
            this.deleteInternal(kvContainer, forceDelete);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        return ContainerCommandResponseBuilders.getSuccessResponse((ContainerProtos.ContainerCommandRequestProto)request);
    }

    ContainerProtos.ContainerCommandResponseProto handleCloseContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasCloseContainer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Update Container request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            ContainerProtos.ContainerDataProto.State previousState = kvContainer.getContainerState();
            this.markContainerForClose(kvContainer);
            this.closeContainer(kvContainer);
            if (previousState == ContainerProtos.ContainerDataProto.State.RECOVERING) {
                this.containerSet.scanContainer(kvContainer.getContainerData().getContainerID(), "EC Reconstruction");
            }
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Close Container failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.getSuccessResponse((ContainerProtos.ContainerCommandRequestProto)request);
    }

    ContainerProtos.ContainerCommandResponseProto handlePutBlock(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer, DispatcherContext dispatcherContext) {
        ContainerProtos.BlockData blockDataProto;
        if (!request.hasPutBlock()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Put Key request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            this.checkContainerOpen(kvContainer);
            ContainerProtos.BlockData data = request.getPutBlock().getBlockData();
            BlockData blockData = BlockData.getFromProtoBuf((ContainerProtos.BlockData)data);
            Preconditions.checkNotNull((Object)blockData);
            boolean endOfBlock = false;
            if (!request.getPutBlock().hasEof() || request.getPutBlock().getEof()) {
                if (!request.getPutBlock().getBlockData().getChunksList().isEmpty() || blockData.getMetadata().containsKey("incremental")) {
                    this.chunkManager.finishWriteChunks(kvContainer, blockData);
                }
                endOfBlock = true;
            }
            long bcsId = dispatcherContext == null ? 0L : dispatcherContext.getLogIndex();
            blockData.setBlockCommitSequenceId(bcsId);
            this.blockManager.putBlock(kvContainer, blockData, endOfBlock);
            blockDataProto = blockData.getProtoBufMessage();
            long numBytes = blockDataProto.getSerializedSize();
            this.metrics.incContainerBytesStats(ContainerProtos.Type.PutBlock, numBytes);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Put Key failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.putBlockResponseSuccess((ContainerProtos.ContainerCommandRequestProto)request, (ContainerProtos.BlockData)blockDataProto);
    }

    ContainerProtos.ContainerCommandResponseProto handleFinalizeBlock(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        ContainerProtos.BlockData responseData;
        ContainerProtos.ContainerCommandResponseProto responseProto = this.checkFaultInjector(request);
        if (responseProto != null) {
            return responseProto;
        }
        if (!request.hasFinalizeBlock()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Finalize block request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            if (!VersionedDatanodeFeatures.isFinalized(HDDSLayoutFeature.HBASE_SUPPORT)) {
                throw new StorageContainerException("DataNode has not finalized upgrading to a version that supports block finalization.", ContainerProtos.Result.UNSUPPORTED_REQUEST);
            }
            this.checkContainerOpen(kvContainer);
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)request.getFinalizeBlock().getBlockID());
            Preconditions.checkNotNull((Object)blockID);
            LOG.info("Finalized Block request received {} ", (Object)blockID);
            responseData = this.blockManager.getBlock(kvContainer, blockID).getProtoBufMessage();
            this.chunkManager.finalizeWriteChunk(kvContainer, blockID);
            this.blockManager.finalizeBlock(kvContainer, blockID);
            kvContainer.getContainerData().addToFinalizedBlockSet(blockID.getLocalID());
            LOG.info("Block has been finalized {} ", (Object)blockID);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Finalize Block failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.getFinalizeBlockResponse((ContainerProtos.ContainerCommandRequestProto)request, (ContainerProtos.BlockData)responseData);
    }

    ContainerProtos.ContainerCommandResponseProto handleEcho(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        return ContainerCommandResponseBuilders.getEchoResponse((ContainerProtos.ContainerCommandRequestProto)request);
    }

    ContainerProtos.ContainerCommandResponseProto handleGetContainerChecksumInfo(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        boolean stateSupportsChecksumInfo;
        if (!request.hasGetContainerChecksumInfo()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Read Container Merkle tree request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        KeyValueContainerData containerData = kvContainer.getContainerData();
        ContainerProtos.ContainerDataProto.State state = containerData.getState();
        boolean bl = stateSupportsChecksumInfo = state == ContainerProtos.ContainerDataProto.State.CLOSED || state == ContainerProtos.ContainerDataProto.State.QUASI_CLOSED || state == ContainerProtos.ContainerDataProto.State.UNHEALTHY;
        if (!stateSupportsChecksumInfo) {
            return ContainerProtos.ContainerCommandResponseProto.newBuilder().setCmdType(request.getCmdType()).setTraceID(request.getTraceID()).setResult(ContainerProtos.Result.UNCLOSED_CONTAINER_IO).setMessage("Checksum information is not available for containers in state " + state).build();
        }
        ByteString checksumTree = null;
        try {
            checksumTree = this.checksumManager.getContainerChecksumInfo(containerData);
        }
        catch (IOException ex) {
            if (ex instanceof FileNotFoundException) {
                try {
                    LOG.info("Checksum tree file not found for container {}. Building merkle tree from container metadata.", (Object)containerData.getContainerID());
                    ContainerProtos.ContainerChecksumInfo checksumInfo = this.updateAndGetContainerChecksumFromMetadata(kvContainer);
                    checksumTree = checksumInfo.toByteString();
                }
                catch (IOException metadataEx) {
                    LOG.error("Failed to build merkle tree from metadata for container {}", (Object)containerData.getContainerID(), (Object)metadataEx);
                    return ContainerProtos.ContainerCommandResponseProto.newBuilder().setCmdType(request.getCmdType()).setTraceID(request.getTraceID()).setResult(ContainerProtos.Result.IO_EXCEPTION).setMessage("Failed to get or build merkle tree: " + metadataEx.getMessage()).build();
                }
            }
            LOG.error("Error occurred when reading checksum file for container {}", (Object)containerData.getContainerID(), (Object)ex);
            return ContainerProtos.ContainerCommandResponseProto.newBuilder().setCmdType(request.getCmdType()).setTraceID(request.getTraceID()).setResult(ContainerProtos.Result.IO_EXCEPTION).setMessage(ex.getMessage()).build();
        }
        return ContainerCommandResponseBuilders.getGetContainerMerkleTreeResponse((ContainerProtos.ContainerCommandRequestProto)request, (ByteString)checksumTree);
    }

    ContainerProtos.ContainerCommandResponseProto handleGetBlock(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        ContainerProtos.BlockData responseData;
        if (!request.hasGetBlock()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Get Key request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)request.getGetBlock().getBlockID());
            BlockUtils.verifyReplicaIdx(kvContainer, blockID);
            responseData = this.blockManager.getBlock(kvContainer, blockID).getProtoBufMessage();
            long numBytes = responseData.getSerializedSize();
            this.metrics.incContainerBytesStats(ContainerProtos.Type.GetBlock, numBytes);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Get Key failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.getBlockDataResponse((ContainerProtos.ContainerCommandRequestProto)request, (ContainerProtos.BlockData)responseData);
    }

    ContainerProtos.ContainerCommandResponseProto handleGetCommittedBlockLength(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        long blockLength;
        ContainerProtos.ContainerCommandResponseProto responseProto = this.checkFaultInjector(request);
        if (responseProto != null) {
            return responseProto;
        }
        if (!request.hasGetCommittedBlockLength()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Get Key request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)request.getGetCommittedBlockLength().getBlockID());
            BlockUtils.verifyBCSId(kvContainer, blockID);
            blockLength = this.blockManager.getCommittedBlockLength(kvContainer, blockID);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("GetCommittedBlockLength failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.getBlockLengthResponse((ContainerProtos.ContainerCommandRequestProto)request, (long)blockLength);
    }

    ContainerProtos.ContainerCommandResponseProto handleListBlock(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasListBlock()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed list block request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        ArrayList<ContainerProtos.BlockData> returnData = new ArrayList<ContainerProtos.BlockData>();
        try {
            int count = request.getListBlock().getCount();
            long startLocalId = -1L;
            if (request.getListBlock().hasStartLocalID()) {
                startLocalId = request.getListBlock().getStartLocalID();
            }
            List<BlockData> responseData = this.blockManager.listBlock(kvContainer, startLocalId, count);
            for (BlockData responseDatum : responseData) {
                returnData.add(responseDatum.getProtoBufMessage());
            }
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("List blocks failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.getListBlockResponse((ContainerProtos.ContainerCommandRequestProto)request, returnData);
    }

    @Deprecated
    ContainerProtos.ContainerCommandResponseProto handleDeleteBlock(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        throw new UnsupportedOperationException("Datanode handles block deletion using BlockDeletingService");
    }

    ContainerProtos.ContainerCommandResponseProto handleReadChunk(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer, DispatcherContext dispatcherContext) {
        ChunkBufferToByteString data;
        if (!request.hasReadChunk()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Read Chunk request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            boolean isReadChunkV0;
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)request.getReadChunk().getBlockID());
            ChunkInfo chunkInfo = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)request.getReadChunk().getChunkData());
            Preconditions.checkNotNull((Object)chunkInfo);
            BlockUtils.verifyReplicaIdx(kvContainer, blockID);
            BlockUtils.verifyBCSId(kvContainer, blockID);
            if (dispatcherContext == null) {
                dispatcherContext = DispatcherContext.getHandleReadChunk();
            }
            if (isReadChunkV0 = ClientCommandsUtils.getReadChunkVersion((ContainerProtos.ReadChunkRequestProto)request.getReadChunk()).equals((Object)ContainerProtos.ReadChunkVersion.V0)) {
                chunkInfo.setReadDataIntoSingleBuffer(true);
            }
            data = this.chunkManager.readChunk(kvContainer, blockID, chunkInfo, dispatcherContext);
            LOG.debug("read chunk from block {} chunk {}", (Object)blockID, (Object)chunkInfo);
            if (DispatcherContext.op(dispatcherContext).readFromTmpFile()) {
                this.validateChunkChecksumData(data, chunkInfo);
                this.metrics.incBytesReadStateMachine(chunkInfo.getLen());
                this.metrics.incNumReadStateMachine();
            }
            this.metrics.incContainerBytesStats(ContainerProtos.Type.ReadChunk, chunkInfo.getLen());
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Read Chunk failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        Preconditions.checkNotNull((Object)data, (Object)"Chunk data is null");
        return ContainerCommandResponseBuilders.getReadChunkResponse((ContainerProtos.ContainerCommandRequestProto)request, (ChunkBufferToByteString)data, this.byteBufferToByteString);
    }

    @Deprecated
    ContainerProtos.ContainerCommandResponseProto handleDeleteChunk(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        throw new UnsupportedOperationException("Datanode handles chunk deletion using BlockDeletingService");
    }

    private void validateChunkChecksumData(ChunkBufferToByteString data, ChunkInfo info) throws StorageContainerException {
        if (this.validateChunkChecksumData) {
            try {
                if (data instanceof ChunkBuffer) {
                    ChunkBuffer b = (ChunkBuffer)data;
                    Checksum.verifyChecksum((ChunkBuffer)b.duplicate(b.position(), b.limit()), (ChecksumData)info.getChecksumData(), (int)0);
                } else {
                    Checksum.verifyChecksum((ByteBuffer)data.toByteString(this.byteBufferToByteString).asReadOnlyByteBuffer(), (ChecksumData)info.getChecksumData(), (int)0);
                }
            }
            catch (OzoneChecksumException ex) {
                throw ChunkUtils.wrapInStorageContainerException((Exception)((Object)ex));
            }
        }
    }

    ContainerProtos.ContainerCommandResponseProto handleWriteChunk(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer, DispatcherContext dispatcherContext) {
        if (!request.hasWriteChunk()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Write Chunk request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        ContainerProtos.BlockData blockDataProto = null;
        try {
            boolean isWrite;
            this.checkContainerOpen(kvContainer);
            ContainerProtos.WriteChunkRequestProto writeChunk = request.getWriteChunk();
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)writeChunk.getBlockID());
            ContainerProtos.ChunkInfo chunkInfoProto = writeChunk.getChunkData();
            ChunkInfo chunkInfo = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunkInfoProto);
            Preconditions.checkNotNull((Object)chunkInfo);
            ChunkBuffer data = null;
            if (dispatcherContext == null) {
                dispatcherContext = DispatcherContext.getHandleWriteChunk();
            }
            if (isWrite = dispatcherContext.getStage().isWrite()) {
                data = ChunkBuffer.wrap((List)writeChunk.getData().asReadOnlyByteBufferList());
                this.validateChunkChecksumData((ChunkBufferToByteString)data, chunkInfo);
            }
            this.chunkManager.writeChunk((Container)kvContainer, blockID, chunkInfo, data, dispatcherContext);
            boolean isCommit = dispatcherContext.getStage().isCommit();
            if (isCommit && writeChunk.hasBlock()) {
                long startTime = Time.monotonicNowNanos();
                this.metrics.incContainerOpsMetrics(ContainerProtos.Type.PutBlock);
                BlockData blockData = BlockData.getFromProtoBuf((ContainerProtos.BlockData)writeChunk.getBlock().getBlockData());
                blockData.setBlockCommitSequenceId(dispatcherContext.getLogIndex());
                boolean eob = writeChunk.getBlock().getEof();
                if (eob) {
                    this.chunkManager.finishWriteChunks(kvContainer, blockData);
                }
                this.blockManager.putBlock(kvContainer, blockData, eob);
                blockDataProto = blockData.getProtoBufMessage();
                long numBytes = blockDataProto.getSerializedSize();
                this.metrics.incContainerBytesStats(ContainerProtos.Type.PutBlock, numBytes);
                this.metrics.incContainerOpsLatencies(ContainerProtos.Type.PutBlock, Time.monotonicNowNanos() - startTime);
            }
            if (isWrite) {
                this.metrics.incContainerBytesStats(ContainerProtos.Type.WriteChunk, writeChunk.getChunkData().getLen());
            }
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Write Chunk failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.getWriteChunkResponseSuccess((ContainerProtos.ContainerCommandRequestProto)request, blockDataProto);
    }

    public void writeChunkForClosedContainer(ChunkInfo chunkInfo, BlockID blockID, ChunkBuffer data, KeyValueContainer kvContainer) throws IOException {
        Preconditions.checkNotNull((Object)kvContainer);
        Preconditions.checkNotNull((Object)chunkInfo);
        Preconditions.checkNotNull((Object)data);
        long writeChunkStartTime = Time.monotonicNowNanos();
        if (!this.checkContainerClose(kvContainer)) {
            throw new IOException("Container #" + kvContainer.getContainerData().getContainerID() + " is not in closed state, Container state is " + kvContainer.getContainerState());
        }
        DispatcherContext dispatcherContext = DispatcherContext.getHandleWriteChunk();
        this.chunkManager.writeChunk((Container)kvContainer, blockID, chunkInfo, data, dispatcherContext);
        this.metrics.incClosedContainerBytesStats(ContainerProtos.Type.WriteChunk, chunkInfo.getLen());
        this.metrics.incContainerOpsLatencies(ContainerProtos.Type.WriteChunk, Time.monotonicNowNanos() - writeChunkStartTime);
    }

    public void putBlockForClosedContainer(KeyValueContainer kvContainer, BlockData blockData, long blockCommitSequenceId, boolean overwriteBscId) throws IOException {
        Preconditions.checkNotNull((Object)kvContainer);
        Preconditions.checkNotNull((Object)blockData);
        long startTime = Time.monotonicNowNanos();
        if (!this.checkContainerClose(kvContainer)) {
            throw new IOException("Container #" + kvContainer.getContainerData().getContainerID() + " is not in closed state, Container state is " + kvContainer.getContainerState());
        }
        if (overwriteBscId) {
            blockData.setBlockCommitSequenceId(blockCommitSequenceId);
        }
        this.blockManager.putBlockForClosedContainer(kvContainer, blockData, overwriteBscId);
        ContainerProtos.BlockData blockDataProto = blockData.getProtoBufMessage();
        long numBytes = blockDataProto.getSerializedSize();
        this.metrics.incClosedContainerBytesStats(ContainerProtos.Type.PutBlock, numBytes);
        this.metrics.incContainerOpsLatencies(ContainerProtos.Type.PutBlock, Time.monotonicNowNanos() - startTime);
    }

    ContainerProtos.ContainerCommandResponseProto handlePutSmallFile(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer, DispatcherContext dispatcherContext) {
        ContainerProtos.BlockData blockDataProto;
        if (!request.hasPutSmallFile()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Put Small File request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        ContainerProtos.PutSmallFileRequestProto putSmallFileReq = request.getPutSmallFile();
        try {
            this.checkContainerOpen(kvContainer);
            BlockData blockData = BlockData.getFromProtoBuf((ContainerProtos.BlockData)putSmallFileReq.getBlock().getBlockData());
            Preconditions.checkNotNull((Object)blockData);
            ContainerProtos.ChunkInfo chunkInfoProto = putSmallFileReq.getChunkInfo();
            ChunkInfo chunkInfo = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunkInfoProto);
            Preconditions.checkNotNull((Object)chunkInfo);
            ChunkBuffer data = ChunkBuffer.wrap((List)putSmallFileReq.getData().asReadOnlyByteBufferList());
            if (dispatcherContext == null) {
                dispatcherContext = DispatcherContext.getHandlePutSmallFile();
            }
            BlockID blockID = blockData.getBlockID();
            this.validateChunkChecksumData((ChunkBufferToByteString)data, chunkInfo);
            this.chunkManager.writeChunk((Container)kvContainer, blockID, chunkInfo, data, dispatcherContext);
            this.chunkManager.finishWriteChunks(kvContainer, blockData);
            LinkedList<ContainerProtos.ChunkInfo> chunks = new LinkedList<ContainerProtos.ChunkInfo>();
            chunks.add(chunkInfoProto);
            blockData.setChunks(chunks);
            blockData.setBlockCommitSequenceId(dispatcherContext.getLogIndex());
            this.blockManager.putBlock(kvContainer, blockData);
            blockDataProto = blockData.getProtoBufMessage();
            this.metrics.incContainerBytesStats(ContainerProtos.Type.PutSmallFile, chunkInfo.getLen());
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Read Chunk failed", (Throwable)ex, ContainerProtos.Result.PUT_SMALL_FILE_ERROR), request);
        }
        return ContainerCommandResponseBuilders.getPutFileResponseSuccess((ContainerProtos.ContainerCommandRequestProto)request, (ContainerProtos.BlockData)blockDataProto);
    }

    ContainerProtos.ContainerCommandResponseProto handleGetSmallFile(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasGetSmallFile()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Get Small File request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        ContainerProtos.GetSmallFileRequestProto getSmallFileReq = request.getGetSmallFile();
        try {
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)getSmallFileReq.getBlock().getBlockID());
            BlockData responseData = this.blockManager.getBlock(kvContainer, blockID);
            ContainerProtos.ChunkInfo chunkInfoProto = null;
            ArrayList dataBuffers = new ArrayList();
            DispatcherContext dispatcherContext = DispatcherContext.getHandleGetSmallFile();
            for (ContainerProtos.ChunkInfo chunk : responseData.getChunks()) {
                ChunkInfo chunkInfo = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunk);
                boolean isReadChunkV0 = ClientCommandsUtils.getReadChunkVersion((ContainerProtos.GetSmallFileRequestProto)request.getGetSmallFile()).equals((Object)ContainerProtos.ReadChunkVersion.V0);
                if (isReadChunkV0) {
                    chunkInfo.setReadDataIntoSingleBuffer(true);
                }
                ChunkBufferToByteString data = this.chunkManager.readChunk(kvContainer, blockID, chunkInfo, dispatcherContext);
                dataBuffers.addAll(data.toByteStringList(this.byteBufferToByteString));
                chunkInfoProto = chunk;
            }
            this.metrics.incContainerBytesStats(ContainerProtos.Type.GetSmallFile, BufferUtils.getBuffersLen(dataBuffers));
            return ContainerCommandResponseBuilders.getGetSmallFileResponseSuccess((ContainerProtos.ContainerCommandRequestProto)request, dataBuffers, chunkInfoProto);
        }
        catch (StorageContainerException e) {
            return ContainerUtils.logAndReturnError(LOG, e, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Write Chunk failed", (Throwable)ex, ContainerProtos.Result.GET_SMALL_FILE_ERROR), request);
        }
    }

    ContainerProtos.ContainerCommandResponseProto handleUnsupportedOp(ContainerProtos.ContainerCommandRequestProto request) {
        return ContainerCommandResponseBuilders.unsupportedRequest((ContainerProtos.ContainerCommandRequestProto)request);
    }

    private void checkContainerOpen(KeyValueContainer kvContainer) throws StorageContainerException {
        ContainerProtos.Result result;
        ContainerProtos.ContainerDataProto.State containerState = kvContainer.getContainerState();
        if (containerState == ContainerProtos.ContainerDataProto.State.OPEN || containerState == ContainerProtos.ContainerDataProto.State.CLOSING || containerState == ContainerProtos.ContainerDataProto.State.RECOVERING) {
            return;
        }
        switch (containerState) {
            case QUASI_CLOSED: {
                result = ContainerProtos.Result.CLOSED_CONTAINER_IO;
                break;
            }
            case CLOSED: {
                result = ContainerProtos.Result.CLOSED_CONTAINER_IO;
                break;
            }
            case UNHEALTHY: {
                result = ContainerProtos.Result.CONTAINER_UNHEALTHY;
                break;
            }
            case INVALID: {
                result = ContainerProtos.Result.INVALID_CONTAINER_STATE;
                break;
            }
            default: {
                result = ContainerProtos.Result.CONTAINER_INTERNAL_ERROR;
            }
        }
        String msg = "Requested operation not allowed as ContainerState is " + containerState;
        throw new StorageContainerException(msg, result);
    }

    private boolean checkContainerClose(KeyValueContainer kvContainer) {
        ContainerProtos.ContainerDataProto.State containerState = kvContainer.getContainerState();
        return containerState == ContainerProtos.ContainerDataProto.State.QUASI_CLOSED || containerState == ContainerProtos.ContainerDataProto.State.CLOSED || containerState == ContainerProtos.ContainerDataProto.State.UNHEALTHY;
    }

    @Override
    public Container importContainer(ContainerData originalContainerData, InputStream rawContainerStream, TarContainerPacker packer) throws IOException {
        Preconditions.checkState((boolean)(originalContainerData instanceof KeyValueContainerData), (Object)"Should be KeyValueContainerData instance");
        KeyValueContainerData containerData = new KeyValueContainerData((KeyValueContainerData)originalContainerData);
        KeyValueContainer container = new KeyValueContainer(containerData, this.conf);
        HddsVolume targetVolume = originalContainerData.getVolume();
        this.populateContainerPathFields(container, targetVolume);
        container.importContainerData(rawContainerStream, packer);
        ContainerLogger.logImported(containerData);
        this.sendICR(container);
        return container;
    }

    @Override
    public void exportContainer(Container container, OutputStream outputStream, TarContainerPacker packer) throws IOException {
        KeyValueContainer kvc = (KeyValueContainer)container;
        kvc.exportContainerData(outputStream, packer);
        ContainerLogger.logExported(container.getContainerData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markContainerForClose(Container container) throws IOException {
        container.writeLock();
        boolean stateChanged = false;
        try {
            ContainerProtos.ContainerDataProto.State state = container.getContainerState();
            if (HddsUtils.isOpenToWriteState((ContainerProtos.ContainerDataProto.State)state)) {
                if (state == ContainerProtos.ContainerDataProto.State.RECOVERING) {
                    this.containerSet.removeRecoveringContainer(((ContainerData)container.getContainerData()).getContainerID());
                    ContainerLogger.logRecovered(container.getContainerData());
                }
                container.markContainerForClose();
                stateChanged = true;
            }
        }
        finally {
            container.writeUnlock();
        }
        ContainerLogger.logClosing(container.getContainerData());
        if (stateChanged) {
            this.sendICR(container);
        } else {
            this.sendDeferredICR(container);
        }
    }

    @Override
    public void updateContainerChecksum(Container container, ContainerMerkleTreeWriter treeWriter) throws IOException {
        this.updateAndGetContainerChecksum(container, treeWriter, true);
    }

    private void updateContainerChecksumFromMetadataIfNeeded(Container container) {
        if (!((ContainerData)container.getContainerData()).needsDataChecksum()) {
            return;
        }
        try {
            KeyValueContainer keyValueContainer = (KeyValueContainer)container;
            this.updateAndGetContainerChecksumFromMetadata(keyValueContainer);
        }
        catch (IOException ex) {
            LOG.error("Cannot create container checksum for container {} , Exception: ", (Object)((ContainerData)container.getContainerData()).getContainerID(), (Object)ex);
        }
    }

    @VisibleForTesting
    public ContainerProtos.ContainerChecksumInfo updateAndGetContainerChecksumFromMetadata(KeyValueContainer container) throws IOException {
        ContainerMerkleTreeWriter merkleTree = new ContainerMerkleTreeWriter();
        try (DBHandle dbHandle = BlockUtils.getDB(container.getContainerData(), this.conf);
             BlockIterator<BlockData> blockIterator = dbHandle.getStore().getBlockIterator(container.getContainerData().getContainerID());){
            while (blockIterator.hasNext()) {
                BlockData blockData = blockIterator.nextBlock();
                merkleTree.addBlock(blockData.getLocalID());
                List chunkInfos = blockData.getChunks();
                merkleTree.addChunks(blockData.getLocalID(), true, chunkInfos);
            }
        }
        return this.updateAndGetContainerChecksum(container, merkleTree, false);
    }

    private ContainerProtos.ContainerChecksumInfo updateAndGetContainerChecksum(Container container, ContainerMerkleTreeWriter treeWriter, boolean sendICR) throws IOException {
        KeyValueContainerData containerData = (KeyValueContainerData)container.getContainerData();
        long originalDataChecksum = containerData.getDataChecksum();
        boolean hadDataChecksum = !containerData.needsDataChecksum();
        ContainerProtos.ContainerChecksumInfo updateChecksumInfo = this.checksumManager.updateTree(containerData, treeWriter);
        long updatedDataChecksum = updateChecksumInfo.getContainerMerkleTree().getDataChecksum();
        if (updatedDataChecksum != originalDataChecksum) {
            containerData.setDataChecksum(updatedDataChecksum);
            try (DBHandle dbHandle = BlockUtils.getDB(containerData, this.conf);){
                dbHandle.getStore().getMetadataTable().put((Object)containerData.getContainerDataChecksumKey(), (Object)updatedDataChecksum);
            }
            catch (IOException e) {
                LOG.error("Failed to update container data checksum in RocksDB for container {}. Leaving the original checksum in RocksDB: {}", new Object[]{containerData.getContainerID(), HddsUtils.checksumToString((long)originalDataChecksum), e});
            }
            if (sendICR) {
                this.sendICR(container);
            }
            String message = "Container " + containerData.getContainerID() + " data checksum updated from " + HddsUtils.checksumToString((long)originalDataChecksum) + " to " + HddsUtils.checksumToString((long)updatedDataChecksum);
            if (hadDataChecksum) {
                LOG.warn(message);
                ContainerLogger.logChecksumUpdated(containerData, originalDataChecksum);
            } else {
                LOG.debug(message);
            }
        }
        return updateChecksumInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markContainerUnhealthy(Container container, ScanResult reason) throws IOException {
        container.writeLock();
        long containerID = ((ContainerData)container.getContainerData()).getContainerID();
        try {
            if (container.getContainerState() == ContainerProtos.ContainerDataProto.State.UNHEALTHY) {
                LOG.debug("Call to mark already unhealthy container {} as unhealthy", (Object)containerID);
                return;
            }
            HddsVolume containerVolume = ((ContainerData)container.getContainerData()).getVolume();
            if (containerVolume.isFailed()) {
                LOG.debug("Ignoring unhealthy container {} detected on an already failed volume {}", (Object)containerID, (Object)containerVolume);
                return;
            }
            container.markContainerUnhealthy();
        }
        catch (StorageContainerException ex) {
            LOG.warn("Unexpected error while marking container {} unhealthy", (Object)containerID, (Object)ex);
        }
        finally {
            container.writeUnlock();
        }
        this.updateContainerChecksumFromMetadataIfNeeded(container);
        ContainerLogger.logUnhealthy(container.getContainerData(), reason);
        this.sendICR(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void quasiCloseContainer(Container container, String reason) throws IOException {
        container.writeLock();
        try {
            ContainerProtos.ContainerDataProto.State state = container.getContainerState();
            if (state == ContainerProtos.ContainerDataProto.State.QUASI_CLOSED) {
                return;
            }
            if (state != ContainerProtos.ContainerDataProto.State.CLOSING) {
                ContainerProtos.Result error = state == ContainerProtos.ContainerDataProto.State.INVALID ? ContainerProtos.Result.INVALID_CONTAINER_STATE : ContainerProtos.Result.CONTAINER_INTERNAL_ERROR;
                throw new StorageContainerException("Cannot quasi close container #" + ((ContainerData)container.getContainerData()).getContainerID() + " while in " + state + " state.", error);
            }
            container.quasiClose();
        }
        finally {
            container.writeUnlock();
        }
        this.updateContainerChecksumFromMetadataIfNeeded(container);
        ContainerLogger.logQuasiClosed(container.getContainerData(), reason);
        this.sendICR(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeContainer(Container container) throws IOException {
        container.writeLock();
        try {
            ContainerProtos.ContainerDataProto.State state = container.getContainerState();
            if (state == ContainerProtos.ContainerDataProto.State.CLOSED) {
                return;
            }
            if (state == ContainerProtos.ContainerDataProto.State.UNHEALTHY) {
                throw new StorageContainerException("Cannot close container #" + ((ContainerData)container.getContainerData()).getContainerID() + " while in " + state + " state.", ContainerProtos.Result.CONTAINER_UNHEALTHY);
            }
            if (state != ContainerProtos.ContainerDataProto.State.CLOSING && state != ContainerProtos.ContainerDataProto.State.QUASI_CLOSED) {
                ContainerProtos.Result error = state == ContainerProtos.ContainerDataProto.State.INVALID ? ContainerProtos.Result.INVALID_CONTAINER_STATE : ContainerProtos.Result.CONTAINER_INTERNAL_ERROR;
                throw new StorageContainerException("Cannot close container #" + ((ContainerData)container.getContainerData()).getContainerID() + " while in " + state + " state.", error);
            }
            container.close();
        }
        finally {
            container.writeUnlock();
        }
        this.updateContainerChecksumFromMetadataIfNeeded(container);
        ContainerLogger.logClosed(container.getContainerData());
        this.sendICR(container);
    }

    @Override
    public void deleteContainer(Container container, boolean force) throws IOException {
        this.deleteInternal(container, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconcileContainer(DNContainerOperationClient dnClient, Container<?> container, Collection<DatanodeDetails> peers) throws IOException {
        long containerID = ((ContainerData)container.getContainerData()).getContainerID();
        try {
            this.reconcileContainerInternal(dnClient, container, peers);
        }
        finally {
            this.containerSet.scanContainerWithoutGap(containerID, "Container reconciliation");
        }
    }

    private void reconcileContainerInternal(DNContainerOperationClient dnClient, Container<?> container, Collection<DatanodeDetails> peers) throws IOException {
        long latestDataChecksum;
        KeyValueContainer kvContainer = (KeyValueContainer)container;
        KeyValueContainerData containerData = (KeyValueContainerData)container.getContainerData();
        long containerID = containerData.getContainerID();
        ContainerProtos.ContainerChecksumInfo originalChecksumInfo = this.checksumManager.read(containerData);
        if (!ContainerChecksumTreeManager.hasDataChecksum(originalChecksumInfo)) {
            originalChecksumInfo = this.updateAndGetContainerChecksumFromMetadata(kvContainer);
        }
        ContainerProtos.ContainerChecksumInfo latestChecksumInfo = originalChecksumInfo;
        int successfulPeerCount = 0;
        HashSet<Long> allBlocksUpdated = new HashSet<Long>();
        ByteBuffer chunkByteBuffer = ByteBuffer.allocate(this.chunkSize);
        for (DatanodeDetails peer : peers) {
            try {
                long latestDataChecksum2;
                long localID;
                long numMissingBlocksRepaired = 0L;
                long numCorruptChunksRepaired = 0L;
                long numMissingChunksRepaired = 0L;
                long numDivergedDeletedBlocksUpdated = 0L;
                LOG.info("Beginning reconciliation for container {} with peer {}. Current data checksum is {}", new Object[]{containerID, peer, HddsUtils.checksumToString((long)ContainerChecksumTreeManager.getDataChecksum(latestChecksumInfo))});
                long start = Instant.now().toEpochMilli();
                ContainerProtos.ContainerChecksumInfo peerChecksumInfo = dnClient.getContainerChecksumInfo(containerID, peer);
                if (peerChecksumInfo == null) {
                    LOG.warn("Cannot reconcile container {} with peer {} which has not yet generated a checksum", (Object)containerID, (Object)peer);
                    continue;
                }
                ContainerMerkleTreeWriter updatedTreeWriter = new ContainerMerkleTreeWriter(latestChecksumInfo.getContainerMerkleTree());
                ContainerDiffReport diffReport = this.checksumManager.diff(latestChecksumInfo, peerChecksumInfo);
                Pipeline pipeline = DNContainerOperationClient.createSingleNodePipeline(peer);
                for (ContainerProtos.BlockMerkleTree blockMerkleTree : diffReport.getMissingBlocks()) {
                    try {
                        localID = blockMerkleTree.getBlockID();
                        BlockID blockID = new BlockID(containerID, localID);
                        if (this.getBlockManager().blockExists(container, blockID)) {
                            LOG.warn("Cannot reconcile block {} in container {} which was previously reported missing but is now present. Our container merkle tree is stale.", (Object)localID, (Object)containerID);
                            continue;
                        }
                        long chunksInBlockRetrieved = this.reconcileChunksPerBlock(kvContainer, pipeline, dnClient, localID, blockMerkleTree.getChunkMerkleTreeList(), updatedTreeWriter, chunkByteBuffer);
                        if (chunksInBlockRetrieved == 0L) continue;
                        allBlocksUpdated.add(localID);
                        ++numMissingBlocksRepaired;
                    }
                    catch (IOException e) {
                        LOG.error("Error while reconciling missing block for block {} in container {}", new Object[]{blockMerkleTree.getBlockID(), containerID, e});
                    }
                }
                for (Map.Entry entry : diffReport.getMissingChunks().entrySet()) {
                    localID = (Long)entry.getKey();
                    try {
                        long missingChunksRepaired = this.reconcileChunksPerBlock(kvContainer, pipeline, dnClient, (Long)entry.getKey(), (List)entry.getValue(), updatedTreeWriter, chunkByteBuffer);
                        if (missingChunksRepaired == 0L) continue;
                        allBlocksUpdated.add(localID);
                        numMissingChunksRepaired += missingChunksRepaired;
                    }
                    catch (IOException e) {
                        LOG.error("Error while reconciling missing chunk for block {} in container {}", new Object[]{entry.getKey(), containerID, e});
                    }
                }
                for (Map.Entry entry : diffReport.getCorruptChunks().entrySet()) {
                    localID = (Long)entry.getKey();
                    try {
                        long corruptChunksRepaired = this.reconcileChunksPerBlock(kvContainer, pipeline, dnClient, (Long)entry.getKey(), (List)entry.getValue(), updatedTreeWriter, chunkByteBuffer);
                        if (corruptChunksRepaired == 0L) continue;
                        allBlocksUpdated.add(localID);
                        numCorruptChunksRepaired += corruptChunksRepaired;
                    }
                    catch (IOException e) {
                        LOG.error("Error while reconciling corrupt chunk for block {} in container {}", new Object[]{entry.getKey(), containerID, e});
                    }
                }
                for (ContainerDiffReport.DeletedBlock deletedBlock : diffReport.getDivergedDeletedBlocks()) {
                    updatedTreeWriter.setDeletedBlock(deletedBlock.getBlockID(), deletedBlock.getDataChecksum());
                    ++numDivergedDeletedBlocksUpdated;
                }
                ContainerProtos.ContainerChecksumInfo previousChecksumInfo = latestChecksumInfo;
                latestChecksumInfo = this.updateAndGetContainerChecksum(container, updatedTreeWriter, false);
                long l = Instant.now().toEpochMilli() - start;
                long previousDataChecksum = ContainerChecksumTreeManager.getDataChecksum(previousChecksumInfo);
                if (previousDataChecksum == (latestDataChecksum2 = ContainerChecksumTreeManager.getDataChecksum(latestChecksumInfo))) {
                    if (numCorruptChunksRepaired != 0L || numMissingBlocksRepaired != 0L || numMissingChunksRepaired != 0L || numDivergedDeletedBlocksUpdated != 0L) {
                        LOG.error("Checksum of container was not updated but blocks were repaired.");
                    }
                    LOG.info("Container {} reconciled with peer {}. Data checksum {} was not updated. Time taken: {} ms", new Object[]{containerID, peer, HddsUtils.checksumToString((long)previousDataChecksum), l});
                } else {
                    LOG.warn("Container {} reconciled with peer {}. Data checksum updated from {} to {}.\nMissing blocks repaired: {}/{}\nMissing chunks repaired: {}/{}\nCorrupt chunks repaired:  {}/{}\nDiverged deleted blocks updated:  {}/{}\nTime taken: {} ms", new Object[]{containerID, peer, HddsUtils.checksumToString((long)previousDataChecksum), HddsUtils.checksumToString((long)latestDataChecksum2), numMissingBlocksRepaired, diffReport.getNumMissingBlocks(), numMissingChunksRepaired, diffReport.getNumMissingChunks(), numCorruptChunksRepaired, diffReport.getNumCorruptChunks(), numDivergedDeletedBlocksUpdated, diffReport.getNumdivergedDeletedBlocks(), l});
                }
                ContainerLogger.logReconciled(container.getContainerData(), previousDataChecksum, peer);
                ++successfulPeerCount;
            }
            catch (IOException ex) {
                LOG.error("Failed to reconcile with peer {} for container #{}. Skipping to next peer.", new Object[]{peer, containerID, ex});
            }
        }
        long originalDataChecksum = ContainerChecksumTreeManager.getDataChecksum(originalChecksumInfo);
        if (originalDataChecksum == (latestDataChecksum = ContainerChecksumTreeManager.getDataChecksum(latestChecksumInfo))) {
            LOG.info("Completed reconciliation for container {} with {}/{} peers. Original data checksum {} was not updated", new Object[]{containerID, successfulPeerCount, peers.size(), HddsUtils.checksumToString((long)latestDataChecksum)});
        } else {
            LOG.warn("Completed reconciliation for container {} with {}/{} peers. {} blocks were updated. Data checksum updated from {} to {}", new Object[]{containerID, successfulPeerCount, peers.size(), allBlocksUpdated.size(), HddsUtils.checksumToString((long)originalDataChecksum), HddsUtils.checksumToString((long)latestDataChecksum)});
            if (LOG.isDebugEnabled()) {
                LOG.debug("Blocks updated in container {} after reconciling with {} peers: {}", new Object[]{containerID, successfulPeerCount, allBlocksUpdated});
            }
        }
        this.containerSet.scanContainerWithoutGap(containerID, "Container reconciliation");
        this.sendICR(container);
    }

    private long reconcileChunksPerBlock(KeyValueContainer container, Pipeline pipeline, DNContainerOperationClient dnClient, long localID, List<ContainerProtos.ChunkMerkleTree> peerChunkList, ContainerMerkleTreeWriter treeWriter, ByteBuffer chunkByteBuffer) throws IOException {
        NavigableMap<Long, ContainerProtos.ChunkInfo> localOffset2Chunk;
        BlockData localBlockData;
        long containerID = container.getContainerData().getContainerID();
        DatanodeDetails peer = pipeline.getFirstNode();
        BlockID blockID = new BlockID(containerID, localID);
        Token<OzoneBlockTokenIdentifier> blockToken = dnClient.getTokenHelper().getBlockToken(blockID, 0L);
        long localBcsid = 0L;
        if (this.blockManager.blockExists(container, blockID)) {
            localBlockData = this.blockManager.getBlock(container, blockID);
            localOffset2Chunk = localBlockData.getChunks().stream().collect(Collectors.toMap(ContainerProtos.ChunkInfo::getOffset, Function.identity(), (chunk1, chunk2) -> chunk1, TreeMap::new));
            localBcsid = localBlockData.getBlockCommitSequenceId();
        } else {
            localOffset2Chunk = new TreeMap();
            localBlockData = new BlockData(blockID);
        }
        boolean allChunksSuccessful = true;
        int numSuccessfulChunks = 0;
        BlockLocationInfo blkInfo = new BlockLocationInfo.Builder().setBlockID(blockID).setPipeline(pipeline).setToken(blockToken).build();
        blkInfo.setUnderConstruction(true);
        try (BlockInputStream blockInputStream = (BlockInputStream)this.blockInputStreamFactory.create((ReplicationConfig)RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.ONE), blkInfo, pipeline, blockToken, (XceiverClientFactory)dnClient.getXceiverClientManager(), null, (OzoneClientConfig)this.conf.getObject(OzoneClientConfig.class));){
            ContainerProtos.ChunkMerkleTree chunkMerkleTree;
            long chunkOffset;
            blockInputStream.initialize();
            ContainerProtos.BlockData peerBlockData = blockInputStream.getStreamBlockData();
            long maxBcsId = Math.max(localBcsid, peerBlockData.getBlockID().getBlockCommitSequenceId());
            Iterator<ContainerProtos.ChunkMerkleTree> iterator = peerChunkList.iterator();
            while (iterator.hasNext() && this.previousChunkPresent(blockID, chunkOffset = (chunkMerkleTree = iterator.next()).getOffset(), localOffset2Chunk)) {
                if (!chunkMerkleTree.getChecksumMatches()) {
                    LOG.warn("Skipping chunk at offset {} in block {} of container {} from peer {} since peer reported it as unhealthy.", new Object[]{chunkOffset, localID, containerID, peer});
                    continue;
                }
                try {
                    blockInputStream.seek(chunkOffset);
                    ChunkInputStream currentChunkStream = (ChunkInputStream)blockInputStream.getChunkStreams().get(blockInputStream.getChunkIndex());
                    ContainerProtos.ChunkInfo chunkInfoProto = currentChunkStream.getChunkInfo();
                    if (localOffset2Chunk.containsKey(chunkOffset)) {
                        this.verifyChunksLength(chunkInfoProto, (ContainerProtos.ChunkInfo)localOffset2Chunk.get(chunkOffset));
                    }
                    int chunkLength = (int)chunkInfoProto.getLen();
                    if (chunkByteBuffer.capacity() < chunkLength) {
                        chunkByteBuffer = ByteBuffer.allocate(chunkLength);
                    }
                    chunkByteBuffer.clear();
                    chunkByteBuffer.limit(chunkLength);
                    int bytesRead = blockInputStream.read(chunkByteBuffer);
                    if (bytesRead != chunkLength) {
                        throw new IOException("Error while reading chunk data from peer " + peer + ". Expected length: " + chunkLength + ", Actual length: " + bytesRead);
                    }
                    chunkByteBuffer.flip();
                    ChunkBuffer chunkBuffer = ChunkBuffer.wrap((ByteBuffer)chunkByteBuffer);
                    ChunkInfo chunkInfo = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunkInfoProto);
                    chunkInfo.addMetadata("OverWriteRequested", "true");
                    this.writeChunkForClosedContainer(chunkInfo, blockID, chunkBuffer, container);
                    localOffset2Chunk.put(chunkOffset, chunkInfoProto);
                    treeWriter.addChunks(localID, true, chunkInfoProto);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Successfully ingested chunk at offset {} into block {} of container {} from peer {}", new Object[]{chunkOffset, localID, containerID, peer});
                    }
                    ++numSuccessfulChunks;
                }
                catch (IOException ex) {
                    LOG.error("Failed to ingest chunk at offset {} for block {} in container {} from peer {}", new Object[]{chunkOffset, localID, containerID, peer, ex});
                    allChunksSuccessful = false;
                }
                if (allChunksSuccessful) continue;
                break;
            }
            if (!localOffset2Chunk.isEmpty()) {
                ArrayList allChunks = new ArrayList(localOffset2Chunk.values());
                localBlockData.setChunks(allChunks);
                this.putBlockForClosedContainer(container, localBlockData, maxBcsId, allChunksSuccessful);
                this.chunkManager.finishWriteChunks(container, localBlockData);
            }
        }
        if (!allChunksSuccessful) {
            LOG.warn("Partially reconciled block {} in container {} with peer {}. {}/{} chunks were obtained successfully", new Object[]{localID, containerID, peer, numSuccessfulChunks, peerChunkList.size()});
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Reconciled all {} chunks in block {} in container {} from peer {}", new Object[]{peerChunkList.size(), localID, containerID, peer});
        }
        return numSuccessfulChunks;
    }

    private void verifyChunksLength(ContainerProtos.ChunkInfo peerChunkInfo, ContainerProtos.ChunkInfo localChunkInfo) throws StorageContainerException {
        if (localChunkInfo == null || peerChunkInfo == null) {
            return;
        }
        if (peerChunkInfo.getOffset() != localChunkInfo.getOffset()) {
            throw new StorageContainerException("Offset mismatch for chunk. Expected: " + localChunkInfo.getOffset() + ", Actual: " + peerChunkInfo.getOffset(), ContainerProtos.Result.CHUNK_FILE_INCONSISTENCY);
        }
        if (peerChunkInfo.getLen() != localChunkInfo.getLen()) {
            throw new StorageContainerException("Length mismatch for chunk at offset " + localChunkInfo.getOffset() + ". Expected: " + localChunkInfo.getLen() + ", Actual: " + peerChunkInfo.getLen(), ContainerProtos.Result.CHUNK_FILE_INCONSISTENCY);
        }
    }

    private boolean previousChunkPresent(BlockID blockID, long chunkOffset, NavigableMap<Long, ContainerProtos.ChunkInfo> localOffset2Chunk) {
        long prevLength;
        if (chunkOffset == 0L) {
            return true;
        }
        long localID = blockID.getLocalID();
        long containerID = blockID.getContainerID();
        Map.Entry<Long, ContainerProtos.ChunkInfo> prevEntry = localOffset2Chunk.lowerEntry(chunkOffset);
        if (prevEntry == null) {
            LOG.warn("Exiting reconciliation for block {} in container {} at length {}. The previous chunk required for offset {} is not present locally.", new Object[]{localID, containerID, 0, chunkOffset});
            return false;
        }
        long prevOffset = prevEntry.getKey();
        if (prevOffset + (prevLength = prevEntry.getValue().getLen()) != chunkOffset) {
            LOG.warn("Exiting reconciliation for block {} in container {} at length {}. The previous chunk required for offset {} is not present locally.", new Object[]{localID, containerID, prevOffset + prevLength, chunkOffset});
            return false;
        }
        return true;
    }

    @Override
    public void deleteBlock(Container container, BlockData blockData) throws IOException {
        this.chunkManager.deleteChunks(container, blockData);
        if (LOG.isDebugEnabled()) {
            for (ContainerProtos.ChunkInfo chunkInfo : blockData.getChunks()) {
                ChunkInfo info = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunkInfo);
                LOG.debug("block {} chunk {} deleted", (Object)blockData.getBlockID(), (Object)info);
            }
        }
    }

    @Override
    public void deleteUnreferenced(Container container, long localID) throws IOException {
        StringBuilder prefixBuilder = new StringBuilder();
        ContainerLayoutVersion layoutVersion = ((ContainerData)container.getContainerData()).getLayoutVersion();
        long containerID = ((ContainerData)container.getContainerData()).getContainerID();
        switch (layoutVersion) {
            case FILE_PER_BLOCK: {
                prefixBuilder.append(localID).append(".block");
                break;
            }
            case FILE_PER_CHUNK: {
                prefixBuilder.append(localID).append("_chunk_");
                break;
            }
            default: {
                throw new IOException("Unsupported container layout version " + (Object)((Object)layoutVersion) + " for the container " + containerID);
            }
        }
        String prefix = prefixBuilder.toString();
        File chunkDir = ContainerUtils.getChunkDir(container.getContainerData());
        String[] chunkNames = this.getFilesWithPrefix(prefix, chunkDir);
        if (chunkNames.length == 0) {
            LOG.warn("Missing delete block(Container = {}, Block = {}", (Object)containerID, (Object)localID);
            return;
        }
        for (String name : chunkNames) {
            File file = new File(chunkDir, name);
            if (!file.isFile()) continue;
            FileUtil.fullyDelete((File)file);
            LOG.info("Deleted unreferenced chunk/block {} in container {}", (Object)name, (Object)containerID);
        }
    }

    @Override
    public void addFinalizedBlock(Container container, long localID) {
        KeyValueContainer keyValueContainer = (KeyValueContainer)container;
        keyValueContainer.getContainerData().addToFinalizedBlockSet(localID);
    }

    @Override
    public boolean isFinalizedBlockExist(Container container, long localID) {
        KeyValueContainer keyValueContainer = (KeyValueContainer)container;
        return keyValueContainer.getContainerData().isFinalizedBlockExist(localID);
    }

    private String[] getFilesWithPrefix(String prefix, File chunkDir) {
        FilenameFilter filter = (dir, name) -> name.startsWith(prefix);
        return chunkDir.list(filter);
    }

    private boolean logBlocksIfNonZero(Container container) throws IOException {
        boolean nonZero = false;
        try (DBHandle dbHandle = BlockUtils.getDB((KeyValueContainerData)container.getContainerData(), this.conf);){
            StringBuilder stringBuilder = new StringBuilder();
            try (BlockIterator<BlockData> blockIterator = dbHandle.getStore().getBlockIterator(((ContainerData)container.getContainerData()).getContainerID());){
                while (blockIterator.hasNext()) {
                    nonZero = true;
                    stringBuilder.append(blockIterator.nextBlock());
                    if (!((double)stringBuilder.length() > StorageUnit.KB.toBytes(32.0))) continue;
                    break;
                }
            }
            if (nonZero) {
                LOG.error("blocks in rocksDB on container delete: {}", (Object)stringBuilder.toString());
            }
        }
        return nonZero;
    }

    private boolean logBlocksFoundOnDisk(Container container) throws IOException {
        File chunksPath = new File(((ContainerData)container.getContainerData()).getChunksPath());
        Preconditions.checkArgument((boolean)chunksPath.isDirectory());
        boolean notEmpty = false;
        try (DirectoryStream<Path> dir = Files.newDirectoryStream(chunksPath.toPath());){
            StringBuilder stringBuilder = new StringBuilder();
            for (Path block : dir) {
                if (notEmpty) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(block);
                notEmpty = true;
                if (!((double)stringBuilder.length() > StorageUnit.KB.toBytes(16.0))) continue;
                break;
            }
            if (notEmpty) {
                LOG.error("Files still part of the container on delete: {}", (Object)stringBuilder.toString());
            }
        }
        return notEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteInternal(Container container, boolean force) throws StorageContainerException {
        block16: {
            long startTime = this.clock.millis();
            container.writeLock();
            try {
                HddsVolume hddsVolume;
                KeyValueContainerData keyValueContainerData;
                block17: {
                    Object data = container.getContainerData();
                    if (((ContainerData)container.getContainerData()).getVolume().isFailed()) {
                        LOG.info("Delete container issued on containerID {} which is in a failed volume. Skipping", (Object)((ContainerData)container.getContainerData()).getContainerID());
                        return;
                    }
                    if (!force) {
                        if (((ContainerData)container.getContainerData()).isOpen()) {
                            throw new StorageContainerException("Deletion of Open Container is not allowed.", ContainerProtos.Result.DELETE_ON_OPEN_CONTAINER);
                        }
                        if (container.hasBlocks()) {
                            this.metrics.incContainerDeleteFailedNonEmpty();
                            LOG.error("Received container deletion command for non-empty {}: {}", data, (Object)((ContainerData)data).getStatistics());
                            this.logBlocksIfNonZero(container);
                            this.logBlocksFoundOnDisk(container);
                            throw new StorageContainerException("Non-force deletion of non-empty container is not allowed.", ContainerProtos.Result.DELETE_ON_NON_EMPTY_CONTAINER);
                        }
                    } else {
                        this.metrics.incContainersForceDelete();
                    }
                    if (!(container.getContainerData() instanceof KeyValueContainerData)) break block16;
                    keyValueContainerData = (KeyValueContainerData)container.getContainerData();
                    hddsVolume = keyValueContainerData.getVolume();
                    long waitTime = this.clock.millis() - startTime;
                    if (waitTime <= this.maxDeleteLockWaitMs) break block17;
                    LOG.warn("An attempt to delete container {} took {} ms acquiring locks and pre-checks. The delete has been skipped and should be retried automatically by SCM.", (Object)((ContainerData)container.getContainerData()).getContainerID(), (Object)waitTime);
                    return;
                }
                try {
                    container.markContainerForDelete();
                    long containerId = ((ContainerData)container.getContainerData()).getContainerID();
                    this.containerSet.removeContainer(containerId);
                    ContainerLogger.logDeleted(container.getContainerData(), force);
                    KeyValueContainerUtil.removeContainer(keyValueContainerData, this.conf);
                }
                catch (IOException ioe) {
                    LOG.error("Failed to move container under " + hddsVolume.getDeletedContainerDir());
                    String errorMsg = "Failed to move container" + ((ContainerData)container.getContainerData()).getContainerID();
                    this.triggerVolumeScanAndThrowException(container, errorMsg, ContainerProtos.Result.CONTAINER_INTERNAL_ERROR);
                }
            }
            catch (StorageContainerException e) {
                throw e;
            }
            catch (IOException e) {
                LOG.error("Could not determine if the container {} is empty", (Object)((ContainerData)container.getContainerData()).getContainerID(), (Object)e);
                String errorMsg = "Failed to read container dir" + ((ContainerData)container.getContainerData()).getContainerID();
                this.triggerVolumeScanAndThrowException(container, errorMsg, ContainerProtos.Result.CONTAINER_INTERNAL_ERROR);
            }
            finally {
                container.writeUnlock();
            }
        }
        this.sendICR(container);
        long bytesUsed = ((ContainerData)container.getContainerData()).getBytesUsed();
        HddsVolume volume = ((ContainerData)container.getContainerData()).getVolume();
        container.delete();
        volume.decrementUsedSpace(bytesUsed);
    }

    private void triggerVolumeScanAndThrowException(Container container, String msg, ContainerProtos.Result result) throws StorageContainerException {
        StorageVolumeUtil.onFailure(((ContainerData)container.getContainerData()).getVolume());
        throw new StorageContainerException(msg, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContainerProtos.ContainerCommandResponseProto checkFaultInjector(ContainerProtos.ContainerCommandRequestProto request) {
        if (injector != null) {
            FaultInjector faultInjector = injector;
            synchronized (faultInjector) {
                ContainerProtos.Type type = injector.getType();
                if (request.getCmdType().equals((Object)type) || type == null) {
                    Throwable ex = injector.getException();
                    if (ex != null) {
                        if (type == null) {
                            injector = null;
                        }
                        return ContainerUtils.logAndReturnError(LOG, (StorageContainerException)ex, request);
                    }
                    try {
                        injector.pause();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    @VisibleForTesting
    public static FaultInjector getInjector() {
        return injector;
    }

    @VisibleForTesting
    public static void setInjector(FaultInjector instance) {
        injector = instance;
    }

    private boolean validateRequestDatanodeId(Integer containerReplicaIdx, String requestDatanodeUUID) throws StorageContainerException {
        if (containerReplicaIdx != null && containerReplicaIdx > 0 && !requestDatanodeUUID.equals(this.getDatanodeId())) {
            throw new StorageContainerException(String.format("Request is trying to write to node with uuid : %s but the current nodeId is: %s .", requestDatanodeUUID, this.getDatanodeId()), ContainerProtos.Result.INVALID_ARGUMENT);
        }
        return true;
    }
}

