/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.ozone.container.common.utils.StorageVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.DbVolume;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.metadata.DatanodeStore;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;

public final class HddsVolumeUtil {
    private HddsVolumeUtil() {
    }

    public static String getHddsRoot(String volumeRoot) {
        if (volumeRoot.endsWith("hdds")) {
            return volumeRoot;
        }
        File hddsRoot = new File(volumeRoot, "hdds");
        return hddsRoot.getPath();
    }

    public static void initPerDiskDBStore(String containerDBPath, ConfigurationSource conf, boolean readOnly) throws IOException {
        DatanodeStore store = BlockUtils.getUncachedDatanodeStore(containerDBPath, "3", conf, readOnly);
        BlockUtils.addDB(store, containerDBPath, conf, "3");
    }

    public static void loadAllHddsVolumeDbStore(MutableVolumeSet hddsVolumeSet, MutableVolumeSet dbVolumeSet, boolean readOnly, Logger logger) {
        HddsVolumeUtil.mapDbVolumesToDataVolumesIfNeeded(hddsVolumeSet, dbVolumeSet);
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        List<HddsVolume> hddsVolumes = StorageVolumeUtil.getHddsVolumesList(hddsVolumeSet.getVolumesList());
        long start = Time.monotonicNow();
        for (HddsVolume hddsVolume : hddsVolumes) {
            futures.add(CompletableFuture.runAsync(() -> HddsVolumeUtil.loadVolume(volume, readOnly, logger)));
        }
        for (CompletableFuture completableFuture : futures) {
            completableFuture.join();
        }
        if (logger != null) {
            logger.info("Load {} volumes DbStore cost: {}ms", (Object)hddsVolumes.size(), (Object)(Time.monotonicNow() - start));
        }
    }

    private static void loadVolume(HddsVolume volume, boolean readOnly, Logger logger) {
        block2: {
            try {
                volume.loadDbStore(readOnly);
            }
            catch (IOException e) {
                StorageVolumeUtil.onFailure(volume);
                if (logger == null) break block2;
                logger.error("Load db store for HddsVolume {} failed", (Object)volume.getStorageDir().getAbsolutePath(), (Object)e);
            }
        }
    }

    private static void mapDbVolumesToDataVolumesIfNeeded(MutableVolumeSet hddsVolumeSet, MutableVolumeSet dbVolumeSet) {
        if (dbVolumeSet == null || dbVolumeSet.getVolumesList().isEmpty()) {
            return;
        }
        List<HddsVolume> hddsVolumes = StorageVolumeUtil.getHddsVolumesList(hddsVolumeSet.getVolumesList());
        List<DbVolume> dbVolumes = StorageVolumeUtil.getDbVolumesList(dbVolumeSet.getVolumesList());
        HashMap globalDbVolumeMap = new HashMap();
        dbVolumes.forEach(dbVolume -> dbVolume.getHddsVolumeIDs().forEach(storageID -> globalDbVolumeMap.put(storageID, dbVolume)));
        hddsVolumes.forEach(hddsVolume -> hddsVolume.setDbVolume(globalDbVolumeMap.getOrDefault(hddsVolume.getStorageID(), null)));
    }
}

