/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.interfaces;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.BlockDeletingService;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDeletionChoosingPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContainerDeletionChoosingPolicyTemplate
implements ContainerDeletionChoosingPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerDeletionChoosingPolicyTemplate.class);

    @Override
    public final List<BlockDeletingService.ContainerBlockInfo> chooseContainerForBlockDeletion(int blockCount, Map<Long, ContainerData> candidateContainers) throws StorageContainerException {
        Preconditions.checkNotNull(candidateContainers, (Object)"Internal assertion: candidate containers cannot be null");
        int originalBlockCount = blockCount;
        ArrayList<BlockDeletingService.ContainerBlockInfo> result = new ArrayList<BlockDeletingService.ContainerBlockInfo>();
        LinkedList<ContainerData> orderedList = new LinkedList<ContainerData>();
        for (ContainerData entry : candidateContainers.values()) {
            orderedList.add(entry);
        }
        this.orderByDescendingPriority(orderedList);
        for (ContainerData entry : orderedList) {
            long pendingDeletionBlocks = ContainerUtils.getPendingDeletionBlocks(entry);
            if (pendingDeletionBlocks <= 0L) continue;
            long numBlocksToDelete = Math.min((long)blockCount, pendingDeletionBlocks);
            blockCount = (int)((long)blockCount - numBlocksToDelete);
            result.add(new BlockDeletingService.ContainerBlockInfo(entry, numBlocksToDelete));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Select container {} for block deletion, pending deletion blocks num: {}.", (Object)entry.getContainerID(), (Object)pendingDeletionBlocks);
            }
            if (blockCount != 0) continue;
            break;
        }
        if (!orderedList.isEmpty()) {
            LOG.info("Chosen {}/{} blocks from {} candidate containers.", new Object[]{originalBlockCount - blockCount, blockCount, orderedList.size()});
        }
        return result;
    }

    protected abstract void orderByDescendingPriority(List<ContainerData> var1);
}

