/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.helpers;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.fs.SpaceUsageSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.scm.protocolPB.ContainerCommandResponseBuilders;
import org.apache.hadoop.ozone.container.common.helpers.DatanodeIdYaml;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerDataYaml;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public final class ContainerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerUtils.class);

    private ContainerUtils() {
    }

    public static ContainerProtos.ContainerCommandResponseProto logAndReturnError(Logger log, StorageContainerException ex, ContainerProtos.ContainerCommandRequestProto request) {
        String logInfo = "Operation: {} , Trace ID: {} , Message: {} , Result: {} , StorageContainerException Occurred.";
        if (ex.getResult() == ContainerProtos.Result.CLOSED_CONTAINER_IO || ex.getResult() == ContainerProtos.Result.CONTAINER_NOT_OPEN) {
            if (log.isDebugEnabled()) {
                log.debug(logInfo, new Object[]{request.getCmdType(), request.getTraceID(), ex.getMessage(), ex.getResult().getValueDescriptor().getName(), ex});
            }
        } else {
            log.warn(logInfo, new Object[]{request.getCmdType(), request.getTraceID(), ex.getMessage(), ex.getResult().getValueDescriptor().getName(), ex});
        }
        return ContainerCommandResponseBuilders.getContainerCommandResponse((ContainerProtos.ContainerCommandRequestProto)request, (ContainerProtos.Result)ex.getResult(), (String)ex.getMessage()).build();
    }

    public static String getContainerNameFromFile(File containerFile) {
        Preconditions.checkNotNull((Object)containerFile);
        return Paths.get(containerFile.getParent(), new String[0]).resolve(FilenameUtils.removeExtension((String)containerFile.getName())).toString();
    }

    public static long getContainerIDFromFile(File containerFile) {
        Preconditions.checkNotNull((Object)containerFile);
        String containerID = ContainerUtils.getContainerNameFromFile(containerFile);
        return Long.parseLong(containerID);
    }

    public static void verifyIsNewContainer(File containerFile) throws FileAlreadyExistsException {
        Logger log = LoggerFactory.getLogger(ContainerSet.class);
        Preconditions.checkNotNull((Object)containerFile, (Object)"containerFile Should not be null");
        if (containerFile.getParentFile().exists()) {
            log.error("Container already exists on disk. File: {}", (Object)containerFile.toPath());
            throw new FileAlreadyExistsException("container already exists on disk.");
        }
    }

    public static String getContainerDbFileName(String containerName) {
        return containerName + "-dn-container.db";
    }

    public static synchronized void writeDatanodeDetailsTo(DatanodeDetails datanodeDetails, File path, ConfigurationSource conf) throws IOException {
        if (path.exists()) {
            if (!path.delete() || !path.createNewFile()) {
                throw new IOException("Unable to overwrite the datanode ID file.");
            }
        } else if (!path.getParentFile().exists() && !path.getParentFile().mkdirs()) {
            throw new IOException("Unable to create datanode ID directories.");
        }
        DatanodeIdYaml.createDatanodeIdFile(datanodeDetails, path, conf);
    }

    public static synchronized DatanodeDetails readDatanodeDetailsFrom(File path) throws IOException {
        if (!path.exists()) {
            throw new IOException("Datanode ID file not found.");
        }
        try {
            return DatanodeIdYaml.readDatanodeIdFile(path);
        }
        catch (IOException e) {
            DatanodeDetails datanodeDetails;
            block11: {
                LOG.warn("Error loading DatanodeDetails yaml from {}", (Object)path.getAbsolutePath(), (Object)e);
                InputStream in = Files.newInputStream(path.toPath(), new OpenOption[0]);
                try {
                    datanodeDetails = DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)HddsProtos.DatanodeDetailsProto.parseFrom((InputStream)in));
                    if (in == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException io) {
                        throw new IOException("Failed to parse DatanodeDetails from " + path.getAbsolutePath(), io);
                    }
                }
                in.close();
            }
            return datanodeDetails;
        }
    }

    public static void verifyContainerFileChecksum(ContainerData containerData, ConfigurationSource conf) throws IOException {
        boolean enabled = conf.getBoolean("hdds.container.checksum.verification.enabled", true);
        if (enabled) {
            String storedChecksum = containerData.getContainerFileChecksum();
            Yaml yaml = ContainerDataYaml.getYamlForContainerType(containerData.getContainerType(), containerData instanceof KeyValueContainerData && ((KeyValueContainerData)containerData).getReplicaIndex() > 0);
            containerData.computeAndSetContainerFileChecksum(yaml);
            String computedChecksum = containerData.getContainerFileChecksum();
            if (storedChecksum == null || !storedChecksum.equals(computedChecksum)) {
                throw new StorageContainerException("Container checksum error for ContainerID: " + containerData.getContainerID() + ". \nStored Checksum: " + storedChecksum + "\nExpected Checksum: " + computedChecksum, ContainerProtos.Result.CONTAINER_CHECKSUM_ERROR);
            }
        }
    }

    public static String getContainerFileChecksum(String containerDataYamlStr) throws StorageContainerException {
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            sha.update(containerDataYamlStr.getBytes(ContainerData.CHARSET_ENCODING));
            return DigestUtils.sha256Hex((byte[])sha.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new StorageContainerException("Unable to create Message Digest, usually this is a java configuration issue.", ContainerProtos.Result.NO_SUCH_ALGORITHM);
        }
    }

    public static File getContainerFile(File containerBaseDir) {
        String containerFilePath = "metadata" + File.separator + ContainerUtils.getContainerID(containerBaseDir) + ".container";
        return new File(containerBaseDir, containerFilePath);
    }

    public static File getChunkDir(ContainerData containerData) throws StorageContainerException {
        Preconditions.checkNotNull((Object)containerData, (Object)"Container data can't be null");
        String chunksPath = containerData.getChunksPath();
        if (chunksPath == null) {
            LOG.error("Chunks path is null in the container data");
            throw new StorageContainerException("Unable to get Chunks directory.", ContainerProtos.Result.UNABLE_TO_FIND_DATA_DIR);
        }
        File chunksDir = new File(chunksPath);
        if (!chunksDir.exists()) {
            LOG.error("Chunks dir {} does not exist", (Object)chunksDir.getAbsolutePath());
            throw new StorageContainerException("Chunks directory " + chunksDir.getAbsolutePath() + " does not exist.", ContainerProtos.Result.UNABLE_TO_FIND_DATA_DIR);
        }
        return chunksDir;
    }

    public static long getContainerID(File containerBaseDir) {
        return Long.parseLong(containerBaseDir.getName());
    }

    public static String getContainerTarName(long containerId) {
        return "container-" + containerId + "-" + UUID.randomUUID() + ".tar";
    }

    public static long retrieveContainerIdFromTarName(String tarName) throws IOException {
        assert (tarName != null);
        Pattern pattern = Pattern.compile("container-(\\d+)-.*\\.tar");
        Matcher m = pattern.matcher(tarName);
        if (m.find()) {
            return Long.parseLong(m.group(1));
        }
        throw new IOException("Illegal container tar gz file " + tarName);
    }

    public static long getPendingDeletionBlocks(ContainerData containerData) {
        if (containerData.getContainerType().equals((Object)ContainerProtos.ContainerType.KeyValueContainer)) {
            return ((KeyValueContainerData)containerData).getNumPendingDeletionBlocks();
        }
        throw new IllegalArgumentException("getPendingDeletionBlocks for ContainerType: " + containerData.getContainerType() + " not support.");
    }

    public static void assertSpaceAvailability(long containerId, HddsVolume volume, int sizeRequested) throws StorageContainerException {
        SpaceUsageSource currentUsage = volume.getCurrentUsage();
        long spared = volume.getFreeSpaceToSpare(currentUsage.getCapacity());
        if (currentUsage.getAvailable() - spared < (long)sizeRequested) {
            throw new StorageContainerException("Failed to write " + sizeRequested + " bytes to container " + containerId + " due to volume " + volume + " out of space " + currentUsage + ", minimum free space spared=" + spared, ContainerProtos.Result.DISK_OUT_OF_SPACE);
        }
    }
}

