/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.checksum;

import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableRate;

public class ContainerMerkleTreeMetrics {
    private static final String METRICS_SOURCE_NAME = ContainerMerkleTreeMetrics.class.getSimpleName();
    @Metric(about="Number of Merkle tree write failure")
    private MutableCounterLong numMerkleTreeWriteFailure;
    @Metric(about="Number of Merkle tree read failure")
    private MutableCounterLong numMerkleTreeReadFailure;
    @Metric(about="Number of Merkle tree diff failure")
    private MutableCounterLong numMerkleTreeDiffFailure;
    @Metric(about="Number of container diff that doesn't require repair")
    private MutableCounterLong numNoRepairContainerDiff;
    @Metric(about="Number of container diff that requires repair")
    private MutableCounterLong numRepairContainerDiff;
    @Metric(about="Number of missing blocks identified during container reconciliation")
    private MutableCounterLong numMissingBlocksIdentified;
    @Metric(about="Number of missing chunks identified during container reconciliation")
    private MutableCounterLong numMissingChunksIdentified;
    @Metric(about="Number of corrupt chunks identified during container reconciliation")
    private MutableCounterLong numCorruptChunksIdentified;
    @Metric(about="Number of diverged block deletes identified during container reconciliation")
    private MutableCounterLong numDivergedDeletedBlocksIdentified;
    @Metric(about="Merkle tree write latency")
    private MutableRate merkleTreeWriteLatencyNS;
    @Metric(about="Merkle tree read latency")
    private MutableRate merkleTreeReadLatencyNS;
    @Metric(about="Merkle tree creation latency")
    private MutableRate merkleTreeCreateLatencyNS;
    @Metric(about="Merkle tree diff latency")
    private MutableRate merkleTreeDiffLatencyNS;

    public static ContainerMerkleTreeMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        MetricsSource source = ms.getSource(METRICS_SOURCE_NAME);
        if (source != null) {
            ms.unregisterSource(METRICS_SOURCE_NAME);
        }
        return (ContainerMerkleTreeMetrics)ms.register(METRICS_SOURCE_NAME, "Container Merkle Tree Metrics", (Object)new ContainerMerkleTreeMetrics());
    }

    public static void unregister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(METRICS_SOURCE_NAME);
    }

    public void incrementMerkleTreeWriteFailures() {
        this.numMerkleTreeWriteFailure.incr();
    }

    public void incrementMerkleTreeReadFailures() {
        this.numMerkleTreeReadFailure.incr();
    }

    public void incrementMerkleTreeDiffFailures() {
        this.numMerkleTreeDiffFailure.incr();
    }

    public void incrementNoRepairContainerDiffs() {
        this.numNoRepairContainerDiff.incr();
    }

    public void incrementRepairContainerDiffs() {
        this.numRepairContainerDiff.incr();
    }

    public void incrementMissingBlocksIdentified(long value) {
        this.numMissingBlocksIdentified.incr(value);
    }

    public void incrementMissingChunksIdentified(long value) {
        this.numMissingChunksIdentified.incr(value);
    }

    public void incrementCorruptChunksIdentified(long value) {
        this.numCorruptChunksIdentified.incr(value);
    }

    public void incrementDivergedDeletedBlocksIdentified(long value) {
        this.numDivergedDeletedBlocksIdentified.incr(value);
    }

    public MutableRate getWriteContainerMerkleTreeLatencyNS() {
        return this.merkleTreeWriteLatencyNS;
    }

    public MutableRate getReadContainerMerkleTreeLatencyNS() {
        return this.merkleTreeReadLatencyNS;
    }

    public MutableRate getCreateMerkleTreeLatencyNS() {
        return this.merkleTreeCreateLatencyNS;
    }

    public MutableRate getMerkleTreeDiffLatencyNS() {
        return this.merkleTreeDiffLatencyNS;
    }

    public long getNoRepairContainerDiffs() {
        return this.numNoRepairContainerDiff.value();
    }

    public long getRepairContainerDiffs() {
        return this.numRepairContainerDiff.value();
    }

    public long getMerkleTreeDiffFailure() {
        return this.numMerkleTreeDiffFailure.value();
    }

    public long getMissingBlocksIdentified() {
        return this.numMissingBlocksIdentified.value();
    }

    public long getMissingChunksIdentified() {
        return this.numMissingChunksIdentified.value();
    }

    public long getCorruptChunksIdentified() {
        return this.numCorruptChunksIdentified.value();
    }
}

