/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.checksum;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;

public class ContainerDiffReport {
    private final List<ContainerProtos.BlockMerkleTree> missingBlocks = new ArrayList<ContainerProtos.BlockMerkleTree>();
    private final Map<Long, List<ContainerProtos.ChunkMerkleTree>> missingChunks = new HashMap<Long, List<ContainerProtos.ChunkMerkleTree>>();
    private final Map<Long, List<ContainerProtos.ChunkMerkleTree>> corruptChunks = new HashMap<Long, List<ContainerProtos.ChunkMerkleTree>>();
    private final List<DeletedBlock> divergedDeletedBlocks = new ArrayList<DeletedBlock>();
    private final long containerID;

    public ContainerDiffReport(long containerID) {
        this.containerID = containerID;
    }

    public long getContainerID() {
        return this.containerID;
    }

    public void addMissingBlock(ContainerProtos.BlockMerkleTree missingBlockMerkleTree) {
        this.missingBlocks.add(missingBlockMerkleTree);
    }

    public void addMissingChunk(long blockId, ContainerProtos.ChunkMerkleTree missingChunkMerkleTree) {
        this.missingChunks.computeIfAbsent(blockId, any -> new ArrayList()).add(missingChunkMerkleTree);
    }

    public void addCorruptChunk(long blockId, ContainerProtos.ChunkMerkleTree corruptChunk) {
        this.corruptChunks.computeIfAbsent(blockId, any -> new ArrayList()).add(corruptChunk);
    }

    public void addDivergedDeletedBlock(ContainerProtos.BlockMerkleTree blockMerkleTree) {
        this.divergedDeletedBlocks.add(new DeletedBlock(blockMerkleTree.getBlockID(), blockMerkleTree.getDataChecksum()));
    }

    public List<ContainerProtos.BlockMerkleTree> getMissingBlocks() {
        return this.missingBlocks;
    }

    public Map<Long, List<ContainerProtos.ChunkMerkleTree>> getMissingChunks() {
        return this.missingChunks;
    }

    public Map<Long, List<ContainerProtos.ChunkMerkleTree>> getCorruptChunks() {
        return this.corruptChunks;
    }

    public List<DeletedBlock> getDivergedDeletedBlocks() {
        return this.divergedDeletedBlocks;
    }

    public boolean needsRepair() {
        return !this.missingBlocks.isEmpty() || !this.missingChunks.isEmpty() || !this.corruptChunks.isEmpty() || !this.divergedDeletedBlocks.isEmpty();
    }

    public long getNumCorruptChunks() {
        return this.corruptChunks.values().stream().mapToInt(List::size).sum();
    }

    public long getNumMissingChunks() {
        return this.missingChunks.values().stream().mapToInt(List::size).sum();
    }

    public long getNumMissingBlocks() {
        return this.missingBlocks.size();
    }

    public long getNumdivergedDeletedBlocks() {
        return this.divergedDeletedBlocks.size();
    }

    public String toString() {
        return "Diff report for container " + this.containerID + ": Missing Blocks: " + this.getNumMissingBlocks() + " Missing Chunks: " + this.getNumMissingChunks() + " chunks from " + this.missingChunks.size() + " blocks Corrupt Chunks: " + this.getNumCorruptChunks() + " chunks from " + this.corruptChunks.size() + " blocks Diverged Deleted Blocks: " + this.getNumdivergedDeletedBlocks();
    }

    public static class DeletedBlock {
        private final long blockID;
        private final long dataChecksum;

        public DeletedBlock(long blockID, long dataChecksum) {
            this.blockID = blockID;
            this.dataChecksum = dataChecksum;
        }

        public long getBlockID() {
            return this.blockID;
        }

        public long getDataChecksum() {
            return this.dataChecksum;
        }
    }
}

