/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.upgrade;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.ozone.upgrade.UpgradeException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class UpgradeFinalization {
    public static final StatusAndMessages STARTING_MSG = new StatusAndMessages(Status.STARTING_FINALIZATION, Collections.singletonList("Starting Finalization"));
    public static final StatusAndMessages FINALIZATION_IN_PROGRESS_MSG = new StatusAndMessages(Status.FINALIZATION_IN_PROGRESS, Collections.singletonList("Finalization in progress"));
    public static final StatusAndMessages FINALIZATION_REQUIRED_MSG = new StatusAndMessages(Status.FINALIZATION_REQUIRED, Collections.singletonList("Finalization required"));
    public static final StatusAndMessages FINALIZED_MSG = new StatusAndMessages(Status.ALREADY_FINALIZED, Collections.emptyList());

    public static void handleInvalidRequestAfterInitiatingFinalization(boolean force, UpgradeException e) throws IOException {
        if (UpgradeException.ResultCodes.INVALID_REQUEST.equals((Object)e.getResult())) {
            if (force) {
                return;
            }
            System.err.println("Finalization is already in progress, it is notpossible to initiate it again.");
            e.printStackTrace(System.err);
            System.err.println("If you want to track progress from a new clientfor any reason, use --takeover, and the status update will bereceived by the new client. Note that with forcing to monitorprogress from a new client, the old one initiated the upgradewill not be able to monitor the progress further and exit.");
            throw new IOException("Exiting...");
        }
        throw e;
    }

    public static void emitExitMsg() {
        System.out.println("Exiting...");
    }

    public static boolean isFinalized(Status status) {
        return Status.ALREADY_FINALIZED.equals((Object)status);
    }

    public static boolean isDone(Status status) {
        return Status.FINALIZATION_DONE.equals((Object)status);
    }

    public static boolean isInprogress(Status status) {
        return Status.FINALIZATION_IN_PROGRESS.equals((Object)status);
    }

    public static boolean isStarting(Status status) {
        return Status.STARTING_FINALIZATION.equals((Object)status);
    }

    public static void emitGeneralErrorMsg() {
        System.err.println("Finalization was not successful.");
    }

    public static void emitFinishedMsg(String component) {
        System.out.println("Finalization of " + component + "'s metadata upgrade finished.");
    }

    public static void emitCancellationMsg(String component) {
        System.err.println("Finalization command was cancelled. Note that, thiswill not cancel finalization in " + component + ". Progress can bemonitored in the Ozone Manager's log.");
    }

    private UpgradeFinalization() {
    }

    public static final class StatusAndMessages {
        private final Status status;
        private final Collection<String> msgs;

        public StatusAndMessages(Status status, Collection<String> msgs) {
            this.status = status;
            this.msgs = msgs;
        }

        public Status status() {
            return this.status;
        }

        public Collection<String> msgs() {
            return this.msgs;
        }
    }

    public static enum Status {
        ALREADY_FINALIZED,
        STARTING_FINALIZATION,
        FINALIZATION_IN_PROGRESS,
        FINALIZATION_DONE,
        FINALIZATION_REQUIRED;

    }
}

