/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.ratis.thirdparty.io.netty.buffer.Unpooled;

public final class StringUtils {
    private static final Charset UTF8 = StandardCharsets.UTF_8;

    private StringUtils() {
    }

    public static String bytes2String(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length, UTF8);
    }

    public static String bytes2String(ByteBuffer bytes) {
        return StringUtils.bytes2String(bytes, UTF8);
    }

    public static String bytes2String(ByteBuffer bytes, Charset charset) {
        return Unpooled.wrappedBuffer((ByteBuffer)bytes.asReadOnlyBuffer()).toString(charset);
    }

    public static String bytes2Hex(ByteBuffer buffer, int max) {
        buffer = buffer.asReadOnlyBuffer();
        int remaining = buffer.remaining();
        int n = Math.min(max, remaining);
        StringBuilder builder = new StringBuilder(3 * n);
        for (int i = 0; i < n; ++i) {
            builder.append(String.format("%02X ", buffer.get()));
        }
        return builder + (remaining > max ? "..." : "");
    }

    public static String bytes2Hex(ByteBuffer buffer) {
        return StringUtils.bytes2Hex(buffer, buffer.remaining());
    }

    public static String bytes2Hex(byte[] array) {
        return StringUtils.bytes2Hex(ByteBuffer.wrap(array));
    }

    public static String bytes2String(byte[] bytes) {
        return StringUtils.bytes2String(bytes, 0, bytes.length);
    }

    public static byte[] string2Bytes(String str) {
        return str.getBytes(UTF8);
    }

    public static String appendIfNotPresent(String str, char c) {
        Preconditions.checkNotNull((Object)str, (Object)"Input string is null");
        return str.isEmpty() || str.charAt(str.length() - 1) != c ? str + c : str;
    }
}

