/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hdds.scm.storage.ByteBufferStreamOutput;

public abstract class ByteArrayStreamOutput
extends OutputStream
implements ByteBufferStreamOutput {
    private static final int ARRAY_SIZE_LIMIT = 65536;

    @Override
    public void write(ByteBuffer buffer, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (buffer.hasArray()) {
            this.write(buffer.array(), off, len);
        } else {
            byte[] array = new byte[Math.min(65536, len)];
            while (len > 0) {
                ByteBuffer readonly = buffer.asReadOnlyBuffer();
                int writeSize = Math.min(array.length, len);
                readonly.position(off);
                readonly.limit(off += writeSize);
                readonly.get(array, 0, writeSize);
                this.write(array, 0, writeSize);
                len -= writeSize;
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }
}

