/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;

public class BadDataLocationException
extends IOException {
    private final List<DatanodeDetails> failedLocations = new ArrayList<DatanodeDetails>();
    private int failedLocationIndex;

    public BadDataLocationException(String message) {
        super(message);
    }

    public BadDataLocationException(DatanodeDetails dn) {
        this.failedLocations.add(dn);
    }

    public BadDataLocationException(DatanodeDetails dn, String message) {
        super(message);
        this.failedLocations.add(dn);
    }

    public BadDataLocationException(DatanodeDetails dn, String message, Throwable ex) {
        super(message, ex);
        this.failedLocations.add(dn);
    }

    public BadDataLocationException(DatanodeDetails dn, Throwable ex) {
        super(ex);
        this.failedLocations.add(dn);
    }

    public BadDataLocationException(int failedIndex, Throwable ex, List<DatanodeDetails> failedLocations) {
        super(ex);
        this.failedLocationIndex = failedIndex;
        this.failedLocations.addAll(failedLocations);
    }

    public BadDataLocationException(DatanodeDetails dn, int failedIndex, Throwable ex) {
        super(ex);
        this.failedLocations.add(dn);
        this.failedLocationIndex = failedIndex;
    }

    public List<DatanodeDetails> getFailedLocations() {
        return this.failedLocations;
    }

    public void addFailedLocations(List<DatanodeDetails> dns) {
        this.failedLocations.addAll(dns);
    }

    public int getFailedLocationIndex() {
        return this.failedLocationIndex;
    }
}

