/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.mapreduce.OrcMapreduceRecordReader;

public class OrcInputFormat<V extends WritableComparable>
extends FileInputFormat<NullWritable, V> {
    public static void setSearchArgument(Configuration conf, SearchArgument sarg, String[] columnNames) {
        org.apache.orc.mapred.OrcInputFormat.setSearchArgument(conf, sarg, columnNames);
    }

    public RecordReader<NullWritable, V> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        FileSplit split = (FileSplit)inputSplit;
        Configuration conf = taskAttemptContext.getConfiguration();
        Reader file = OrcFile.createReader((Path)split.getPath(), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf).maxLength(OrcConf.MAX_FILE_LENGTH.getLong(conf)));
        return new OrcMapreduceRecordReader(file, org.apache.orc.mapred.OrcInputFormat.buildOptions(conf, file, split.getStart(), split.getLength()));
    }
}

